/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.characters;

import java.nio.charset.Charset;
import java.util.Arrays;
import org.xith3d.utility.characters.CharIndex;

class BinarySearchCharIndex
extends CharIndex {
    private final Charset charset;
    private final char[] sortedPrintableCharacters;
    private final int definedCharacters;

    public Charset getCharset() {
        return this.charset;
    }

    public int getIndex(char ch) {
        int offset = Arrays.binarySearch(this.sortedPrintableCharacters, ch);
        return Math.max(-1, offset);
    }

    public CharIndex.MemoryStrategy getMemoryStrategy() {
        return CharIndex.MemoryStrategy.BINSEARCH_OPTIMIZED;
    }

    public int getNumberOfPrintableChars() {
        return this.sortedPrintableCharacters.length;
    }

    public int getTotalNumberOfCharacters() {
        return this.definedCharacters;
    }

    public BinarySearchCharIndex(Charset charset) {
        int max = 65535;
        int definedCharacters = 0;
        int printableCharacters = 0;
        char[] chars = new char[65536];
        for (char ch = '\u0000'; ch <= Short.MAX_VALUE; ch = (char)(ch + '\u0001')) {
            if (!Character.isDefined(ch)) continue;
            ++definedCharacters;
            if (!CharIndex.isPrintable(ch, charset)) continue;
            chars[printableCharacters++] = ch;
        }
        char[] result = new char[printableCharacters];
        System.arraycopy(chars, 0, result, 0, printableCharacters);
        this.charset = charset;
        this.definedCharacters = definedCharacters;
        this.sortedPrintableCharacters = result;
    }
}

