/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.commandline;

import org.openmali.types.twodee.Dim2i;
import org.openmali.types.twodee.Sized2iRO;
import org.xith3d.render.config.CanvasConstructionInfo;
import org.xith3d.render.config.DisplayMode;
import org.xith3d.render.config.DisplayModeSelector;
import org.xith3d.render.config.FSAA;
import org.xith3d.render.config.OpenGLLayer;

public class BasicApplicationArguments {
    private static final int DEFAULT_COLOR_DEPTH = 32;
    private static final int DEFAULT_FREQUENCY = 75;
    private OpenGLLayer oglLayer = OpenGLLayer.getDefault();
    int[] displayMode = new int[]{800, 600, 32, 75};
    private boolean fullscreen = false;
    private boolean undecorated = false;
    private boolean vsync = false;
    private FSAA fsaa = FSAA.OFF;
    private boolean invertMouseY = true;
    private Float maxFPS = Float.valueOf(120.0f);
    private CanvasConstructionInfo canvasInfo = null;

    public void setOpenGLLayer(OpenGLLayer oglLayer) {
        this.oglLayer = oglLayer;
    }

    public final OpenGLLayer getOpenGLLayer() {
        return this.oglLayer;
    }

    public void setResolution(int resX, int resY) {
        this.displayMode[0] = resX;
        this.displayMode[1] = resY;
    }

    public final Sized2iRO getResolution() {
        return new Dim2i(this.displayMode[0], this.displayMode[1]);
    }

    public final int getResolutionWidth() {
        return this.displayMode[0];
    }

    public final int getResolutionHeight() {
        return this.displayMode[1];
    }

    public void setColorDepth(int bpp) {
        if (this.displayMode.length < 3) {
            int[] tmp = new int[3];
            System.arraycopy(this.displayMode, 0, tmp, 0, this.displayMode.length);
            this.displayMode = tmp;
        }
        this.displayMode[2] = bpp;
    }

    public final int getColorDepth() {
        if (this.displayMode.length >= 3 && this.displayMode[2] > 0) {
            return this.displayMode[2];
        }
        return 32;
    }

    public void setFrequency(int freq) {
        if (this.displayMode.length < 4) {
            int[] tmp = new int[4];
            System.arraycopy(this.displayMode, 0, tmp, 0, this.displayMode.length);
            if (this.displayMode.length < 3) {
                tmp[2] = 32;
            }
            this.displayMode = tmp;
        }
        this.displayMode[3] = freq;
    }

    public final int getFrequency() {
        if (this.displayMode.length >= 4 && this.displayMode[3] > 0) {
            return this.displayMode[3];
        }
        return 75;
    }

    public final DisplayMode getDisplayMode() {
        return DisplayModeSelector.getImplementation(this.getOpenGLLayer()).getBestMode(this.getResolutionWidth(), this.getResolutionHeight(), this.getColorDepth(), this.getFrequency());
    }

    public void setFullscreenMode(DisplayMode.FullscreenMode fullscreenMode) {
        this.fullscreen = fullscreenMode.isFullscreen();
        this.undecorated = fullscreenMode.isUndecorated();
    }

    public final DisplayMode.FullscreenMode getFullscreenMode() {
        if (this.fullscreen) {
            return DisplayMode.FullscreenMode.FULLSCREEN;
        }
        if (this.undecorated) {
            return DisplayMode.FullscreenMode.WINDOWED_UNDECORATED;
        }
        return DisplayMode.FullscreenMode.WINDOWED;
    }

    public void setVSync(boolean vsync) {
        this.vsync = vsync;
    }

    public final boolean getVSync() {
        return this.vsync;
    }

    public void setFSAA(FSAA fsaa) {
        this.fsaa = fsaa;
    }

    public final FSAA getFSAA() {
        return this.fsaa;
    }

    public void setMouseYInverted(boolean inverted) {
        this.invertMouseY = inverted;
    }

    public final boolean getMouseYInverted() {
        return this.invertMouseY;
    }

    public void setMaxFPS(Float maxFPS) {
        this.maxFPS = maxFPS;
    }

    public final Float getMaxFPS() {
        return this.maxFPS;
    }

    public final float getConcreteMaxFPS() {
        return this.maxFPS == null ? Float.MAX_VALUE : this.maxFPS.floatValue();
    }

    public final CanvasConstructionInfo getCanvasConstructionInfo() {
        if (this.canvasInfo == null) {
            this.canvasInfo = new CanvasConstructionInfo(this.getOpenGLLayer(), this.getDisplayMode(), this.getFullscreenMode(), this.getVSync(), this.getFSAA(), "Xith3D Application");
        }
        return this.canvasInfo;
    }

    public BasicApplicationArguments() {
    }

    public BasicApplicationArguments(OpenGLLayer layer, DisplayMode displayMode, DisplayMode.FullscreenMode fullscreen, boolean vsync, FSAA fsaa, boolean mouseYInverted) {
        this.oglLayer = layer;
        this.displayMode = new int[]{displayMode.getWidth(), displayMode.getHeight(), displayMode.getBPP(), displayMode.getFrequency()};
        this.fullscreen = fullscreen.isFullscreen();
        this.undecorated = fullscreen == DisplayMode.FullscreenMode.WINDOWED_UNDECORATED;
        this.vsync = vsync;
        this.fsaa = fsaa;
        this.invertMouseY = mouseYInverted;
    }
}

