/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.comparator;

import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Matrix4f;
import org.openmali.vecmath2.Tuple2f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector4f;
import org.xith3d.scenegraph.Transform3D;

public class ComparatorHelper {
    public static int compare(Colorf ca, Colorf cb) {
        if (ca == cb) {
            return 0;
        }
        if (ca == null) {
            return -1;
        }
        if (cb == null) {
            return 1;
        }
        if (ca.getRed() < cb.getRed()) {
            return -1;
        }
        if (ca.getRed() > cb.getRed()) {
            return 1;
        }
        if (ca.getGreen() < cb.getGreen()) {
            return -1;
        }
        if (ca.getGreen() > cb.getGreen()) {
            return 1;
        }
        if (ca.getBlue() < cb.getBlue()) {
            return -1;
        }
        if (ca.getBlue() > cb.getBlue()) {
            return 1;
        }
        if (ca.hasAlpha() || cb.hasAlpha()) {
            if (ca.getAlpha() < cb.getAlpha()) {
                return -1;
            }
            if (ca.getAlpha() > cb.getAlpha()) {
                return 1;
            }
        }
        return 0;
    }

    public static int compareTuple(Tuple3f ta, Tuple3f tb) {
        if (ta == tb) {
            return 0;
        }
        if (ta == null) {
            return -1;
        }
        if (tb == null) {
            return 1;
        }
        if (ta.getX() < tb.getX()) {
            return -1;
        }
        if (ta.getX() > tb.getX()) {
            return 1;
        }
        if (ta.getY() < tb.getY()) {
            return -1;
        }
        if (ta.getY() > tb.getY()) {
            return 1;
        }
        if (ta.getZ() < tb.getZ()) {
            return -1;
        }
        if (ta.getZ() > tb.getZ()) {
            return 1;
        }
        return 0;
    }

    public static int compareTuple(Tuple2f ta, Tuple2f tb) {
        if (ta == tb) {
            return 0;
        }
        if (ta == null) {
            return -1;
        }
        if (tb == null) {
            return 1;
        }
        if (ta.getX() < tb.getX()) {
            return -1;
        }
        if (ta.getX() > tb.getX()) {
            return 1;
        }
        if (ta.getY() < tb.getY()) {
            return -1;
        }
        if (ta.getY() > tb.getY()) {
            return 1;
        }
        return 0;
    }

    public static int compareTuple(Vector4f ta, Vector4f tb) {
        if (ta == tb) {
            return 0;
        }
        if (ta == null) {
            return -1;
        }
        if (tb == null) {
            return 1;
        }
        if (ta.getX() < tb.getX()) {
            return -1;
        }
        if (ta.getX() > tb.getX()) {
            return 1;
        }
        if (ta.getY() < tb.getY()) {
            return -1;
        }
        if (ta.getY() > tb.getY()) {
            return 1;
        }
        if (ta.getZ() < tb.getZ()) {
            return -1;
        }
        if (ta.getZ() > tb.getZ()) {
            return 1;
        }
        if (ta.getW() < tb.getW()) {
            return -1;
        }
        if (ta.getW() > tb.getW()) {
            return 1;
        }
        return 0;
    }

    public static int fdiff(float diff) {
        if (diff < 0.0f) {
            return -1;
        }
        if (diff > 0.0f) {
            return 1;
        }
        return 0;
    }

    public static int compare(Matrix4f ma, Matrix4f mb) {
        if (ma == mb) {
            return 0;
        }
        if (ma == null) {
            return -1;
        }
        if (mb == null) {
            return 1;
        }
        float r = 0.0f;
        r = ma.m00() - mb.m00();
        if (r != 0.0f) {
            return ComparatorHelper.fdiff(r);
        }
        r = ma.m01() - mb.m01();
        if (r != 0.0f) {
            return ComparatorHelper.fdiff(r);
        }
        r = ma.m02() - mb.m02();
        if (r != 0.0f) {
            return ComparatorHelper.fdiff(r);
        }
        r = ma.m03() - mb.m03();
        if (r != 0.0f) {
            return ComparatorHelper.fdiff(r);
        }
        r = ma.m10() - mb.m10();
        if (r != 0.0f) {
            return ComparatorHelper.fdiff(r);
        }
        r = ma.m11() - mb.m11();
        if (r != 0.0f) {
            return ComparatorHelper.fdiff(r);
        }
        r = ma.m12() - mb.m12();
        if (r != 0.0f) {
            return ComparatorHelper.fdiff(r);
        }
        r = ma.m13() - mb.m13();
        if (r != 0.0f) {
            return ComparatorHelper.fdiff(r);
        }
        r = ma.m20() - mb.m20();
        if (r != 0.0f) {
            return ComparatorHelper.fdiff(r);
        }
        r = ma.m21() - mb.m21();
        if (r != 0.0f) {
            return ComparatorHelper.fdiff(r);
        }
        r = ma.m22() - mb.m22();
        if (r != 0.0f) {
            return ComparatorHelper.fdiff(r);
        }
        r = ma.m23() - mb.m23();
        if (r != 0.0f) {
            return ComparatorHelper.fdiff(r);
        }
        r = ma.m30() - mb.m30();
        if (r != 0.0f) {
            return ComparatorHelper.fdiff(r);
        }
        r = ma.m31() - mb.m31();
        if (r != 0.0f) {
            return ComparatorHelper.fdiff(r);
        }
        r = ma.m32() - mb.m32();
        if (r != 0.0f) {
            return ComparatorHelper.fdiff(r);
        }
        r = ma.m33() - mb.m33();
        if (r != 0.0f) {
            return ComparatorHelper.fdiff(r);
        }
        return 0;
    }

    public static int compare(Transform3D ta, Transform3D tb) {
        if (ta == tb) {
            return 0;
        }
        if (ta == null) {
            return -1;
        }
        if (tb == null) {
            return 1;
        }
        return ComparatorHelper.compare(ta.getMatrix4f(), tb.getMatrix4f());
    }

    public static int compare(String ta, String tb) {
        if (ta == tb) {
            return 0;
        }
        if (ta == null) {
            return -1;
        }
        if (tb == null) {
            return 1;
        }
        return ta.compareTo(tb);
    }

    public static int compareBoolean(boolean b1, boolean b2) {
        if (b1 == b2) {
            return 0;
        }
        if (!b1) {
            return -1;
        }
        return 1;
    }

    public static int compare(int[] a1, int[] a2) {
        if (a1 == a2) {
            return 0;
        }
        if (a1 == null) {
            return -1;
        }
        if (a2 == null) {
            return 1;
        }
        if (a1.length < a2.length) {
            return -1;
        }
        if (a1.length > a2.length) {
            return 1;
        }
        for (int i = 0; i < a1.length; ++i) {
            int diff = a2[i] - a1[i];
            if (diff < 0) {
                return -1;
            }
            if (diff <= 0) continue;
            return 1;
        }
        return 0;
    }

    public static int compare(Vector4f[] a1, Vector4f[] a2) {
        if (a1 == a2) {
            return 0;
        }
        if (a1 == null) {
            return -1;
        }
        if (a2 == null) {
            return 1;
        }
        if (a1.length < a2.length) {
            return -1;
        }
        if (a1.length > a2.length) {
            return 1;
        }
        for (int i = 0; i < a1.length; ++i) {
            int diff = ComparatorHelper.compareTuple(a1[i], a2[i]);
            if (diff == 0) continue;
            return diff;
        }
        return 0;
    }
}

