/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.comparator;

import java.util.Comparator;
import org.jagatoo.datatypes.Chainable;
import org.jagatoo.datatypes.DoublyChainable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Sorter {
    private static <E> void swap(E[] a, int i, int j) {
        E tmp = a[i];
        a[i] = a[j];
        a[j] = tmp;
    }

    public static <E> void quickSort(E[] a, int lo0, int hi0, Comparator<E> comp) {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            E mid = a[lo0 + hi0 >>> 1];
            while (lo <= hi) {
                while (lo < hi0 && comp.compare(a[lo], mid) < 0) {
                    ++lo;
                }
                while (hi > lo0 && comp.compare(a[hi], mid) > 0) {
                    --hi;
                }
                if (lo > hi) continue;
                Sorter.swap(a, lo, hi);
                ++lo;
                --hi;
            }
            if (lo0 < hi) {
                Sorter.quickSort(a, lo0, hi, comp);
            }
            if (lo < hi0) {
                Sorter.quickSort(a, lo, hi0, comp);
            }
        }
    }

    public static <E extends Chainable<E>> E mergeSort(E head, Comparator<E> comp) {
        boolean isCircular = false;
        if (head == null) {
            return null;
        }
        int inSize = 1;
        while (true) {
            Object p = head;
            E oldHead = head;
            head = null;
            Object tail = null;
            int merges = 0;
            while (p != null) {
                ++merges;
                Object q = p;
                int pSize = 0;
                for (int i = 0; i < inSize; ++i) {
                    ++pSize;
                    if ((q = (Chainable)q.getNext()) == null) break;
                }
                int qSize = inSize;
                while (pSize > 0 || qSize > 0 && q != null) {
                    Object e;
                    if (pSize == 0) {
                        e = q;
                        q = (Chainable)q.getNext();
                        --qSize;
                    } else if (qSize == 0 || q == null) {
                        e = p;
                        p = (Chainable)p.getNext();
                        --pSize;
                    } else if (comp.compare(p, q) <= 0) {
                        e = p;
                        p = (Chainable)p.getNext();
                        --pSize;
                    } else {
                        e = q;
                        q = (Chainable)q.getNext();
                        --qSize;
                    }
                    if (tail != null) {
                        tail.setNext(e);
                    } else {
                        head = e;
                    }
                    if (oldHead instanceof DoublyChainable) {
                        ((DoublyChainable)e).setPrevious(tail);
                    }
                    tail = e;
                }
                p = q;
            }
            tail.setNext(null);
            if (merges <= 1) {
                return head;
            }
            inSize *= 2;
        }
    }

    private Sorter() {
    }
}

