/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.geometry;

import org.openmali.vecmath2.TexCoordf;
import org.openmali.vecmath2.Tuple3f;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.IndexedTriangleArray;
import org.xith3d.scenegraph.IndexedTriangleStripArray;
import org.xith3d.scenegraph.TriangleArray;
import org.xith3d.utility.geometry.GeometryInfo;
import org.xith3d.utility.geometry.nvtristrip.PrimitiveGroup;
import org.xith3d.utility.geometry.nvtristrip.TriStrip;

public class XithGeometryInfo
extends GeometryInfo {
    private void fillData(Geometry geom, int vertexFormat) {
        int i;
        int count = this.vertices.length;
        if ((vertexFormat & 1) != 0) {
            for (i = 0; i < count; ++i) {
                geom.setCoordinate(i, (Tuple3f)this.vertices[i].coord);
            }
        }
        if ((vertexFormat & 2) != 0) {
            for (i = 0; i < count; ++i) {
                geom.setNormal(i, this.vertices[i].normal);
            }
        }
        if ((vertexFormat & 4) != 0) {
            for (i = 0; i < count; ++i) {
                geom.setColor(i, this.vertices[i].color);
            }
        }
        if ((vertexFormat & 8) != 0) {
            for (i = 0; i < count; ++i) {
                for (int tc = 0; tc < this.vertices[i].texCoords.length; ++tc) {
                    geom.setTextureCoordinate(tc, i, (TexCoordf<?>)this.vertices[i].texCoords[tc]);
                }
            }
        }
    }

    public TriangleArray createRawTriangleArray(int vertexFormat) {
        this.unweldVertices();
        TriangleArray ta = new TriangleArray(this.vertices.length);
        this.fillData(ta, vertexFormat);
        return ta;
    }

    public IndexedTriangleArray createIndexedTriangleArray(int vertexFormat) {
        IndexedTriangleArray ita = new IndexedTriangleArray(this.vertices.length, this.triangles.length);
        this.fillData(ita, vertexFormat);
        ita.setIndex(this.triangles);
        ita.setValidIndexCount(this.triangles.length);
        return ita;
    }

    public IndexedTriangleStripArray createContinousStripArray(int vertexFormat) {
        int[] flow = this.createContinousStrip();
        IndexedTriangleStripArray itsa = new IndexedTriangleStripArray(this.vertices.length, flow.length);
        this.fillData(itsa, vertexFormat);
        itsa.setValidIndexCount(flow.length);
        itsa.setIndex(flow);
        return itsa;
    }

    public IndexedTriangleStripArray createChunkedStripArray(int vertexFormat) {
        TriStrip ts = new TriStrip();
        ts.setCacheSize(this.getVertexCacheSize());
        ts.setListsOnly(false);
        ts.setMinStripSize(0);
        ts.setStitchStrips(false);
        PrimitiveGroup[] pg = ts.generateStrips(this.triangles);
        int[] strips = new int[pg.length];
        int totalCount = 0;
        for (int i = 0; i < strips.length; ++i) {
            assert (pg[i].type == 1);
            strips[i] = pg[i].numIndices;
            totalCount += pg[i].numIndices;
        }
        int[] flow = new int[totalCount];
        int current = 0;
        for (int i = 0; i < strips.length; ++i) {
            System.arraycopy(pg[i].indices, 0, flow, current, pg[i].numIndices);
            current += pg[i].numIndices;
        }
        assert (current == totalCount);
        IndexedTriangleStripArray itsa = new IndexedTriangleStripArray(this.vertices.length, this.triangles.length, strips);
        this.fillData(itsa, vertexFormat);
        itsa.setIndex(flow);
        itsa.setValidIndexCount(this.triangles.length);
        return itsa;
    }
}

