/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.geometry.nvtristrip;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import org.xith3d.utility.geometry.nvtristrip.FaceInfo;
import org.xith3d.utility.geometry.nvtristrip.PrimitiveGroup;
import org.xith3d.utility.geometry.nvtristrip.StripInfo;
import org.xith3d.utility.geometry.nvtristrip.Stripifier;

public class TriStrip {
    public static final int CACHESIZE_GEFORCE1_2 = 16;
    public static final int CACHESIZE_GEFORCE3 = 24;
    private int cacheSize = 16;
    private boolean bStitchStrips = true;
    private int minStripSize = 0;
    private boolean bListsOnly = false;

    public void setListsOnly(boolean _bListsOnly) {
        this.bListsOnly = _bListsOnly;
    }

    public void setCacheSize(int _cacheSize) {
        this.cacheSize = _cacheSize;
    }

    public void setStitchStrips(boolean _bStitchStrips) {
        this.bStitchStrips = _bStitchStrips;
    }

    public void setMinStripSize(int _minStripSize) {
        this.minStripSize = _minStripSize;
    }

    public PrimitiveGroup[] generateStrips(int[] in_indices) {
        PrimitiveGroup[] primGroups;
        block16: {
            int i;
            int numSeparateStrips;
            Vector<Integer> stripIndices;
            Stripifier stripifier;
            ArrayList<FaceInfo> tempFaces;
            ArrayList<StripInfo> tempStrips;
            int numGroups;
            block15: {
                int i2;
                numGroups = 0;
                Vector<Integer> tempIndices = new Vector<Integer>();
                int maxIndex = 0;
                for (int i3 = 0; i3 < in_indices.length; ++i3) {
                    tempIndices.add(in_indices[i3]);
                    if (in_indices[i3] <= maxIndex) continue;
                    maxIndex = in_indices[i3];
                }
                tempStrips = new ArrayList<StripInfo>();
                tempFaces = new ArrayList<FaceInfo>();
                stripifier = new Stripifier();
                stripifier.stripify(tempIndices, this.cacheSize, this.minStripSize, maxIndex, tempStrips, tempFaces);
                stripIndices = new Vector<Integer>();
                numSeparateStrips = 0;
                if (!this.bListsOnly) break block15;
                numGroups = 1;
                primGroups = new PrimitiveGroup[numGroups];
                primGroups[0] = new PrimitiveGroup();
                PrimitiveGroup[] primGroupArray = primGroups;
                int numIndices = 0;
                for (int i4 = 0; i4 < tempStrips.size(); ++i4) {
                    numIndices += tempStrips.get((int)i4).m_faces.size() * 3;
                }
                primGroupArray[0].type = 0;
                primGroupArray[0].indices = new int[numIndices += tempFaces.size() * 3];
                primGroupArray[0].numIndices = numIndices;
                int indexCtr = 0;
                for (i2 = 0; i2 < tempStrips.size(); ++i2) {
                    for (int j = 0; j < tempStrips.get((int)i2).m_faces.size(); ++j) {
                        if (!Stripifier.isDegenerate(tempStrips.get((int)i2).m_faces.get(j))) {
                            primGroupArray[0].indices[indexCtr++] = tempStrips.get((int)i2).m_faces.get((int)j).m_v0;
                            primGroupArray[0].indices[indexCtr++] = tempStrips.get((int)i2).m_faces.get((int)j).m_v1;
                            primGroupArray[0].indices[indexCtr++] = tempStrips.get((int)i2).m_faces.get((int)j).m_v2;
                            continue;
                        }
                        primGroupArray[0].numIndices -= 3;
                    }
                }
                for (i2 = 0; i2 < tempFaces.size(); ++i2) {
                    primGroupArray[0].indices[indexCtr++] = tempFaces.get((int)i2).m_v0;
                    primGroupArray[0].indices[indexCtr++] = tempFaces.get((int)i2).m_v1;
                    primGroupArray[0].indices[indexCtr++] = tempFaces.get((int)i2).m_v2;
                }
                break block16;
            }
            numSeparateStrips = stripifier.createStrips(tempStrips, stripIndices, this.bStitchStrips);
            assert (this.bStitchStrips && numSeparateStrips == 1 || !this.bStitchStrips);
            numGroups = numSeparateStrips;
            if (tempFaces.size() != 0) {
                ++numGroups;
            }
            primGroups = new PrimitiveGroup[numGroups];
            for (int i5 = 0; i5 < primGroups.length; ++i5) {
                primGroups[i5] = new PrimitiveGroup();
            }
            PrimitiveGroup[] primGroupArray = primGroups;
            int startingLoc = 0;
            for (int stripCtr = 0; stripCtr < numSeparateStrips; ++stripCtr) {
                int stripLength = 0;
                if (!this.bStitchStrips) {
                    for (i = startingLoc; i < stripIndices.size() && stripIndices.get(i) != -1; ++i) {
                    }
                    stripLength = i - startingLoc;
                } else {
                    stripLength = stripIndices.size();
                }
                primGroupArray[stripCtr].type = 1;
                primGroupArray[stripCtr].indices = new int[stripLength];
                primGroupArray[stripCtr].numIndices = stripLength;
                int indexCtr = 0;
                for (int i6 = startingLoc; i6 < stripLength + startingLoc; ++i6) {
                    primGroupArray[stripCtr].indices[indexCtr++] = stripIndices.get(i6);
                }
                startingLoc += stripLength + 1;
            }
            if (tempFaces.size() == 0) break block16;
            int faceGroupLoc = numGroups - 1;
            primGroupArray[faceGroupLoc].type = 0;
            primGroupArray[faceGroupLoc].indices = new int[tempFaces.size() * 3];
            primGroupArray[faceGroupLoc].numIndices = tempFaces.size() * 3;
            int indexCtr = 0;
            for (i = 0; i < tempFaces.size(); ++i) {
                primGroupArray[faceGroupLoc].indices[indexCtr++] = tempFaces.get((int)i).m_v0;
                primGroupArray[faceGroupLoc].indices[indexCtr++] = tempFaces.get((int)i).m_v1;
                primGroupArray[faceGroupLoc].indices[indexCtr++] = tempFaces.get((int)i).m_v2;
            }
        }
        return primGroups;
    }

    public static int[] remapIndices(int[] indices, int numVerts) {
        int[] indexCache = new int[numVerts];
        Arrays.fill(indexCache, -1);
        int numIndices = indices.length;
        int[] remappedIndices = new int[numIndices];
        int indexCtr = 0;
        for (int j = 0; j < numIndices; ++j) {
            int cachedIndex = indexCache[indices[j]];
            if (cachedIndex == -1) {
                remappedIndices[j] = indexCtr;
                indexCache[indices[j]] = indexCtr++;
                continue;
            }
            remappedIndices[j] = cachedIndex;
        }
        return remappedIndices;
    }

    public static void remapArrays(float[] vertexBuffer, int vertexSize, int[] indices) {
        int[] remapped = TriStrip.remapIndices(indices, vertexBuffer.length / vertexSize);
        float[] bufferCopy = (float[])vertexBuffer.clone();
        for (int i = 0; i < remapped.length; ++i) {
            int from = indices[i] * vertexSize;
            int to = remapped[i] * vertexSize;
            for (int j = 0; j < vertexSize; ++j) {
                vertexBuffer[to + j] = bufferCopy[from + j];
            }
        }
        System.arraycopy(remapped, 0, indices, 0, indices.length);
    }
}

