/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.hud.editor;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import org.jagatoo.input.devices.components.MouseButton;
import org.jagatoo.input.devices.components.MouseButtons;
import org.jagatoo.opengl.enums.TextureFormat;
import org.jagatoo.opengl.enums.TextureImageFormat;
import org.openmali.vecmath2.Point2f;
import org.openmali.vecmath2.Tuple2f;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.TextureImage2D;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.base.Widget;
import org.xith3d.ui.hud.base.WidgetContainer;
import org.xith3d.ui.hud.listeners.WidgetEventsReceiverAdapter;
import org.xith3d.ui.hud.widgets.Image;

public class WidgetManipulator {
    private Image nwHandle;
    private Image neHandle;
    private Image swHandle;
    private Image seHandle;
    private final int HANDLE_X_SIZE = 10;
    private final int HANDLE_Y_SIZE = 10;
    protected Widget widget;
    private Tuple2f old_nwHandle = null;
    private Tuple2f old_neHandle = null;
    private Tuple2f old_swHandle = null;
    private Tuple2f old_seHandle = null;
    private boolean isEventResizing = false;
    private boolean isManipulatorReady = false;
    private StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[2];
    private WERA wera = new WERA();

    public WidgetManipulator(Widget widget) {
        this.widget = widget;
        widget.setDraggable(true);
        widget.addLocationListener(this.wera);
        Texture2D tex = new Texture2D(TextureFormat.RGB);
        tex.setImage(0, new TextureImage2D(TextureImageFormat.LUMINANCE, 8, 8, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1}));
        int handleZIndex = widget.getZIndex() + 1;
        this.nwHandle = new Image(10.0f, 10.0f, tex);
        this.nwHandle.setZIndex(handleZIndex);
        this.nwHandle.setDraggable(true);
        this.nwHandle.addLocationListener(this.wera);
        if (widget.getContainer() != null) {
            widget.getContainer().addWidget(this.nwHandle);
        }
        this.neHandle = new Image(10.0f, 10.0f, tex);
        this.neHandle.setZIndex(handleZIndex);
        this.neHandle.setDraggable(true);
        this.neHandle.addLocationListener(this.wera);
        if (widget.getContainer() != null) {
            widget.getContainer().addWidget(this.neHandle);
        }
        this.swHandle = new Image(10.0f, 10.0f, tex);
        this.swHandle.setZIndex(handleZIndex);
        this.swHandle.setDraggable(true);
        this.swHandle.addLocationListener(this.wera);
        if (widget.getContainer() != null) {
            widget.getContainer().addWidget(this.swHandle);
        }
        this.seHandle = new Image(10.0f, 10.0f, tex);
        this.seHandle.setZIndex(handleZIndex);
        this.seHandle.setDraggable(true);
        this.seHandle.addLocationListener(this.wera);
        if (widget.getContainer() != null) {
            widget.getContainer().addWidget(this.seHandle);
        }
        this.repositionHandles();
        if (widget.getContainer() == null) {
            widget.addContainerListener(this.wera);
        }
        widget.addMouseListener(this.wera);
        this.isManipulatorReady = true;
    }

    private void repositionHandles() {
        if (this.old_nwHandle != null) {
            this.old_nwHandle.set(this.nwHandle.getLeft(), this.nwHandle.getTop());
        }
        this.nwHandle.setLocation(this.widget.getLeft() - 5.0f, this.widget.getTop() - 5.0f);
        if (this.old_nwHandle == null) {
            this.old_nwHandle = new Point2f(this.nwHandle.getLeft(), this.nwHandle.getTop());
        }
        if (this.old_neHandle != null) {
            this.old_neHandle.set(this.neHandle.getLeft(), this.neHandle.getTop());
        }
        this.neHandle.setLocation(this.widget.getLeft() + this.widget.getWidth() - 5.0f, this.widget.getTop() - 5.0f);
        if (this.old_neHandle == null) {
            this.old_neHandle = new Point2f(this.neHandle.getLeft(), this.neHandle.getTop());
        }
        if (this.old_swHandle != null) {
            this.old_swHandle.set(this.swHandle.getLeft(), this.swHandle.getTop());
        }
        this.swHandle.setLocation(this.widget.getLeft() - 5.0f, this.widget.getTop() + this.widget.getHeight() - 5.0f);
        if (this.old_swHandle == null) {
            this.old_swHandle = new Point2f(this.swHandle.getLeft(), this.swHandle.getTop());
        }
        if (this.old_seHandle != null) {
            this.old_seHandle.set(this.seHandle.getLeft(), this.seHandle.getTop());
        }
        this.seHandle.setLocation(this.widget.getLeft() + this.widget.getWidth() - 5.0f, this.widget.getTop() + this.widget.getHeight() - 5.0f);
        if (this.old_seHandle == null) {
            this.old_seHandle = new Point2f(this.seHandle.getLeft(), this.seHandle.getTop());
        }
    }

    private void resizeWidget() {
        if (this.isManipulatorReady) {
            boolean anyChange = false;
            if (this.old_nwHandle.getX() != this.nwHandle.getLeft() || this.old_nwHandle.getY() != this.nwHandle.getTop()) {
                this.widget.setLocation(this.widget.getLeft() + this.nwHandle.getLeft() - this.old_nwHandle.getX(), this.widget.getTop() + this.nwHandle.getTop() - this.old_nwHandle.getY());
                this.widget.setSize(this.widget.getWidth() - this.nwHandle.getLeft() + this.old_nwHandle.getX(), this.widget.getHeight() - this.nwHandle.getTop() + this.old_nwHandle.getY());
                this.old_nwHandle.set(this.nwHandle.getLeft(), this.nwHandle.getTop());
                anyChange = true;
            } else if (this.old_neHandle.getX() != this.neHandle.getLeft() || this.old_neHandle.getY() != this.neHandle.getTop()) {
                this.widget.setLocation(this.widget.getLeft(), this.widget.getTop() + this.neHandle.getTop() - this.old_neHandle.getY());
                this.widget.setSize(this.widget.getWidth() + this.neHandle.getLeft() - this.old_neHandle.getX(), this.widget.getHeight() - this.neHandle.getTop() + this.old_neHandle.getY());
                this.old_neHandle.set(this.neHandle.getLeft(), this.neHandle.getTop());
                anyChange = true;
            } else if (this.old_swHandle.getX() != this.swHandle.getLeft() || this.old_swHandle.getY() != this.swHandle.getTop()) {
                this.widget.setLocation(this.widget.getLeft() + this.swHandle.getLeft() - this.old_swHandle.getX(), this.widget.getTop());
                this.widget.setSize(this.widget.getWidth() - this.swHandle.getLeft() + this.old_swHandle.getX(), this.widget.getHeight() + this.swHandle.getTop() - this.old_swHandle.getY());
                this.old_swHandle.set(this.swHandle.getLeft(), this.swHandle.getTop());
                anyChange = true;
            } else if (this.old_seHandle.getX() != this.seHandle.getLeft() || this.old_seHandle.getY() != this.seHandle.getTop()) {
                this.widget.setSize(this.widget.getWidth() + this.seHandle.getLeft() - this.old_seHandle.getX(), this.widget.getHeight() + this.seHandle.getTop() - this.old_seHandle.getY());
                this.old_seHandle.set(this.seHandle.getLeft(), this.seHandle.getTop());
                anyChange = true;
            }
            if (anyChange) {
                this.repositionHandles();
                this.old_nwHandle.set(this.nwHandle.getLeft(), this.nwHandle.getTop());
                this.old_neHandle.set(this.neHandle.getLeft(), this.neHandle.getTop());
                this.old_swHandle.set(this.swHandle.getLeft(), this.swHandle.getTop());
                this.old_seHandle.set(this.seHandle.getLeft(), this.seHandle.getTop());
            }
        }
    }

    private class WERA
    extends WidgetEventsReceiverAdapter {
        private WERA() {
        }

        public void onWidgetLocationChanged(Widget widget, float oldLeft, float oldTop, float newLeft, float newTop) {
            if (!WidgetManipulator.this.isEventResizing && widget.getHUD() != null) {
                WidgetManipulator.this.isEventResizing = true;
                if (widget == WidgetManipulator.this.widget) {
                    WidgetManipulator.this.repositionHandles();
                } else if (widget == WidgetManipulator.this.nwHandle) {
                    WidgetManipulator.this.resizeWidget();
                } else if (widget == WidgetManipulator.this.neHandle) {
                    WidgetManipulator.this.resizeWidget();
                } else if (widget == WidgetManipulator.this.swHandle) {
                    WidgetManipulator.this.resizeWidget();
                } else if (widget == WidgetManipulator.this.seHandle) {
                    WidgetManipulator.this.resizeWidget();
                }
                WidgetManipulator.this.isEventResizing = false;
            }
        }

        public void onWidgetAttachedToContainer(Widget widget, WidgetContainer container) {
            if (widget == WidgetManipulator.this.widget) {
                widget.getContainer().addWidget(WidgetManipulator.this.nwHandle);
                widget.getContainer().addWidget(WidgetManipulator.this.neHandle);
                widget.getContainer().addWidget(WidgetManipulator.this.swHandle);
                widget.getContainer().addWidget(WidgetManipulator.this.seHandle);
            }
        }

        public void onWidgetAttachedToHUD(Widget widget, HUD hud) {
            if (widget == WidgetManipulator.this.widget) {
                // empty if block
            }
        }

        public void onWidgetDetachedFromContainer(Widget widget, WidgetContainer container) {
        }

        public void onWidgetDetachedFromHUD(Widget widget, HUD hud) {
        }

        public void onMouseButtonPressed(Widget widget, MouseButton button, float x, float y, long when, long lastWhen, boolean isTopMost, boolean hasFocus) {
            if (widget == WidgetManipulator.this.widget && button == MouseButtons.MIDDLE_BUTTON) {
                StringBuffer buff = new StringBuffer();
                String name = WidgetManipulator.this.widget.getClass().getSimpleName().toLowerCase() + ".";
                buff.append(name);
                buff.append("setLocation(");
                buff.append(widget.getLeft());
                buff.append("f,");
                buff.append(widget.getTop());
                buff.append("f);\n");
                buff.append(name);
                buff.append("setSize(");
                buff.append(widget.getWidth());
                buff.append("f,");
                buff.append(widget.getHeight());
                buff.append("f);");
                StringSelection stringSelection = new StringSelection(buff.toString());
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(stringSelection, null);
                System.err.println("Clicked : " + WidgetManipulator.this.stackTraceElement);
            }
        }
    }
}

