/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.image;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import org.xith3d.utility.image.DrawingTools;

public class MaskedBackgroundBuilder {
    private BufferedImage border;
    private BufferedImage borderMask;
    private int leftWidth = 20;
    private int rightWidth = 20;
    private int topWidth = 20;
    private int bottomWidth = 20;
    private BufferedImage center;

    public MaskedBackgroundBuilder(BufferedImage border, BufferedImage borderMask, BufferedImage center) {
        this.border = border;
        this.borderMask = borderMask;
        this.center = center;
    }

    public void setCornerSize(int size) {
        this.leftWidth = size;
        this.rightWidth = size;
        this.bottomWidth = size;
        this.topWidth = size;
    }

    public BufferedImage getImage(int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g = (Graphics2D)image.getGraphics();
        if (this.center == null || this.border == null || this.borderMask == null) {
            if (this.center == null) {
                g.setColor(Color.blue);
                g.fillRect(0, 0, width, height);
            } else {
                g.setColor(Color.white);
                g.fillRect(0, 0, width, height);
            }
            if (this.border == null) {
                g.setColor(Color.red);
                g.drawRect(0, 0, width, height);
            }
            if (this.borderMask == null) {
                g.setColor(Color.green);
                g.drawRect(1, 1, width - 2, height - 2);
            }
            return image;
        }
        try {
            g.setClip(0, 0, width, height);
            g.setComposite(AlphaComposite.Src);
            DrawingTools.drawSegmentedImage(g, this.borderMask, height, width, this.topWidth, this.bottomWidth, this.leftWidth, this.rightWidth);
            g.setComposite(AlphaComposite.SrcIn);
            DrawingTools.fillWithBackground(g, new Rectangle(width, height), this.center);
            g.setComposite(AlphaComposite.SrcOver);
            DrawingTools.drawSegmentedImage(g, this.border, height, width, this.topWidth, this.bottomWidth, this.leftWidth, this.rightWidth);
        }
        catch (Exception error) {
            g.setColor(Color.white);
            g.fillRect(0, 0, width, height);
            g.setColor(Color.black);
            StackTraceElement[] stack = error.getStackTrace();
            g.setFont(new Font("dialog", 0, 10));
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            for (int i = 0; i < stack.length; ++i) {
                g.drawString(stack[i].toString(), 10, i * 15);
            }
        }
        return image;
    }
}

