/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.interpolate;

import org.xith3d.loop.UpdatingThread;

public class AngleInterpolater {
    private static final int STATE_INCREASING = 1;
    private static final int STATE_DECREASING = 2;
    private static final int STATE_STOPPED = 3;
    private int state = 3;
    private float start;
    private float speed;
    private float min;
    private float max;
    private boolean wraps;
    private float value;
    private long lastMicros;

    public AngleInterpolater(float value, float speed, float min, float max, boolean wraps) {
        this.start = value;
        this.value = value;
        this.speed = speed;
        this.min = min;
        this.max = max;
        this.wraps = wraps;
        this.lastMicros = -1L;
    }

    public AngleInterpolater(float speed, float min, float max, boolean wraps) {
        this(0.0f, speed, min, max, wraps);
    }

    public AngleInterpolater(float speed, boolean wraps) {
        this(0.0f, speed, 0.0f, (float)Math.PI * 2, wraps);
    }

    public AngleInterpolater(float speed) {
        this(speed, true);
    }

    public AngleInterpolater() {
        this(0.0f, (float)Math.PI * 2, 0.0f, (float)Math.PI * 2, true);
    }

    public void stop() {
        this.state = 3;
    }

    public boolean isStopped() {
        return this.state == 3;
    }

    public void startIncreasing(long startTime) {
        if (this.state == 3) {
            this.lastMicros = startTime;
        }
        this.state = 1;
    }

    public void resetIncreasing(long startTime) {
        this.value = this.start;
        this.lastMicros = startTime;
        this.state = 1;
    }

    public void resetDecreasing(long startTime) {
        this.value = this.start;
        this.lastMicros = startTime;
        this.state = 2;
    }

    public void startDecreasing(long startTime) {
        if (this.state == 3) {
            this.lastMicros = startTime;
        }
        this.state = 2;
    }

    public void setValue(float angle) {
        this.value = angle;
    }

    public final float getValue(long gameMicros) {
        if (this.lastMicros == -1L) {
            this.lastMicros = gameMicros;
        }
        float elapsedSeconds = (float)(gameMicros - this.lastMicros) / 1000000.0f;
        if (this.state == 1) {
            this.value += elapsedSeconds * this.speed;
            if (this.value > this.max) {
                if (this.wraps) {
                    this.value = this.min + (this.value - this.max);
                } else {
                    this.state = 3;
                    this.value = this.max;
                }
            }
        } else if (this.state == 2) {
            this.value -= elapsedSeconds * this.speed;
            if (this.value < this.min) {
                if (this.wraps) {
                    this.value = this.max - (this.min - this.value);
                } else {
                    this.state = 3;
                    this.value = this.min;
                }
            }
        }
        this.lastMicros = gameMicros;
        return this.value;
    }

    public final float getValue(long gameTime, UpdatingThread.TimingMode timingMode) {
        return this.getValue(timingMode.getMicroSeconds(gameTime));
    }

    public void setStartValue(float startVal) {
        this.start = startVal;
    }

    public float getStartValue() {
        return this.start;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setMinValue(float min) {
        this.min = min;
    }

    public float getMinValue() {
        return this.min;
    }

    public void setMaxValue(float max) {
        this.max = max;
    }

    public float getMaxValue() {
        return this.max;
    }

    public void setWraps(boolean wraps) {
        this.wraps = wraps;
    }

    public boolean getWraps() {
        return this.wraps;
    }
}

