/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.interpolate;

import org.xith3d.loop.UpdatingThread;

public class DistanceInterpolater {
    private static final int STATE_INCREASING = 1;
    private static final int STATE_DECREASING = 2;
    private static final int STATE_STOPPED = 3;
    private int state = 3;
    private float start;
    private float speed;
    private float min;
    private float max;
    private boolean turnsBack;
    private float value;
    private long lastTime;

    public DistanceInterpolater(float value, float speed, float min, float max, boolean turnsBack) {
        this.start = value;
        this.value = value;
        this.speed = speed;
        this.min = min;
        this.max = max;
        this.turnsBack = turnsBack;
        this.lastTime = -1L;
    }

    public DistanceInterpolater(float speed, float min, float max, boolean turnsBack) {
        this(0.0f, speed, min, max, turnsBack);
    }

    public DistanceInterpolater(float value, float speed, float min, float max) {
        this(value, speed, min, max, false);
    }

    public DistanceInterpolater(float speed, float min, float max) {
        this(0.0f, speed, min, max, false);
    }

    public DistanceInterpolater() {
        this(0.0f, 1.0f, 0.0f, 100.0f, false);
    }

    public void stop() {
        this.state = 3;
    }

    public void startIncreasing(long startTime) {
        if (this.state == 3) {
            this.lastTime = startTime;
        }
        this.state = 1;
    }

    public void resetIncreasing(long startTime) {
        this.lastTime = startTime;
        this.value = this.start;
        this.state = 1;
    }

    public void resetDecreasing(long startTime) {
        this.lastTime = startTime;
        this.value = this.start;
        this.state = 2;
    }

    public void startDecreasing(long startTime) {
        if (this.state == 3) {
            this.lastTime = startTime;
        }
        this.state = 2;
    }

    public void setValue(float value) {
        this.value = value;
    }

    public final float getValue(long gameMicros) {
        if (this.lastTime == -1L) {
            this.lastTime = gameMicros;
        }
        float elapsedSeconds = (float)(gameMicros - this.lastTime) / 1000000.0f;
        if (this.turnsBack) {
            if (this.state == 1) {
                this.value += elapsedSeconds * this.speed;
            } else if (this.state == 2) {
                this.value -= elapsedSeconds * this.speed;
            }
            while (this.value < this.min || this.value > this.max) {
                float carry;
                if (this.state == 1) {
                    if (this.value > this.max) {
                        carry = this.value - this.max;
                        this.value = this.max - carry;
                    }
                    this.state = 2;
                    continue;
                }
                if (this.state != 2) continue;
                if (this.value < this.min) {
                    carry = this.value - this.min;
                    this.value = this.min - carry;
                }
                this.state = 1;
            }
        } else if (this.state == 1) {
            this.value += elapsedSeconds * this.speed;
            if (this.value > this.max) {
                this.value = this.max;
                this.state = 3;
            }
        } else if (this.state == 2) {
            this.value -= elapsedSeconds * this.speed;
            if (this.value < this.min) {
                this.value = this.min;
                this.state = 3;
            }
        }
        this.lastTime = gameMicros;
        return this.value;
    }

    public final float getValue(long gameTime, UpdatingThread.TimingMode timingMode) {
        return this.getValue(timingMode.getMicroSeconds(gameTime));
    }

    public void setStartValue(float startVal) {
        this.start = startVal;
    }

    public float getStartValue() {
        return this.start;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setMinValue(float min) {
        this.min = min;
    }

    public float getMinValue() {
        return this.min;
    }

    public void setMaxValue(float max) {
        this.max = max;
    }

    public float getMaxValue() {
        return this.max;
    }

    public void setTurnsBack(boolean turnsBack) {
        this.turnsBack = turnsBack;
    }

    public boolean getTurnsBack() {
        return this.turnsBack;
    }

    public boolean isStarted() {
        return this.state == 1 || this.state == 2;
    }

    public boolean isIncreasing() {
        return this.state == 1;
    }

    public boolean isDecreasing() {
        return this.state == 2;
    }

    public long getTicks(long curTime) {
        return curTime - this.lastTime;
    }
}

