/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.physics.pseudo.joints;

import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.scenegraph.Group;
import org.xith3d.scenegraph.Transform;
import org.xith3d.scenegraph.traversal.DetailedTraversalCallback;
import org.xith3d.utility.physics.pseudo.joints.Joint;

public class HingeJoint
extends Joint {
    private Transform rotationTrans;
    private Vector3f rotationAxis;
    private Transform translationTrans;
    private Vector3f translationAxis;
    private float angle;
    private float length;

    public HingeJoint(Vector3f rotationAxis, Vector3f translationAxis, float length) {
        this(rotationAxis, translationAxis, length, 0.0f);
    }

    public HingeJoint(Vector3f rotationAxis, Vector3f translationAxis, float length, float angle) {
        this.rotationAxis = rotationAxis;
        this.translationAxis = translationAxis;
        this.length = length;
        this.angle = angle;
        this.rotationTrans = new Transform();
        this.translationTrans = new Transform();
        this.addChild(this.rotationTrans);
        this.rotationTrans.addChild(this.translationTrans);
        this.update();
    }

    private void update() {
        this.translationTrans.setAxisTranslation((Tuple3f)this.translationAxis, this.length);
        this.rotationTrans.setAxisRotation((Tuple3f)this.rotationAxis, this.angle);
    }

    public Group getStartGroup() {
        return this.rotationTrans;
    }

    public Group getEndGroup() {
        return this.translationTrans;
    }

    public void addChild(Joint j) {
        this.translationTrans.addChild(j);
    }

    public void removeChild(Joint j) {
        this.translationTrans.removeChild(j);
    }

    public Vector3f getRotationAxis() {
        return this.rotationAxis;
    }

    public void setRotationAxis(Vector3f rotationAxis) {
        this.rotationAxis = rotationAxis;
        this.update();
    }

    public Vector3f getTranslationAxis() {
        return this.translationAxis;
    }

    public void setTranslationAxis(Vector3f translationAxis) {
        this.translationAxis = translationAxis;
        this.update();
    }

    public float getAngle() {
        return this.angle;
    }

    public void setAngle(float angle) {
        this.angle = angle;
        this.update();
    }

    public float getLength() {
        return this.length;
    }

    public void setLength(float length) {
        this.length = length;
        this.update();
    }

    public void addAngle(float angle) {
        this.setAngle(this.angle + angle);
    }

    public void subAngle(float angle) {
        this.setAngle(this.angle - angle);
    }

    public void addLength(float length) {
        this.setLength(this.length + length);
    }

    public void subLength(float length) {
        this.setLength(this.length - length);
    }

    public boolean traverse(DetailedTraversalCallback callback) {
        return this.rotationTrans.traverse(callback);
    }
}

