/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.properties;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Properties;
import org.xith3d.utility.exception.Check;
import org.xith3d.utility.logging.X3DLog;
import org.xith3d.utility.properties.PropertyInterface;

public class PropertyManager {
    private Hashtable<String, PropertyInterface> props = new Hashtable(50);

    public void addProperty(PropertyInterface prop) {
        this.props.put(prop.getName(), prop);
    }

    private String nameToKey(String name) {
        String result = name.replace(' ', '_');
        return result;
    }

    public PropertyInterface getProperty(String name) {
        return this.props.get(name);
    }

    public void save(String filename) {
        try {
            PrintStream prnout = new PrintStream(new BufferedOutputStream(new FileOutputStream(filename)));
            for (PropertyInterface node : this.props.values()) {
                prnout.println("#" + node.getComment());
                prnout.println(this.nameToKey(node.getName()) + "=" + node.convertToString());
                prnout.println();
            }
            prnout.close();
        }
        catch (FileNotFoundException e) {
            Check.assertion(false, e.getMessage());
        }
    }

    public void load(String filename) {
        X3DLog.debug("Loading property file : ", filename);
        try {
            BufferedInputStream infile = new BufferedInputStream(new FileInputStream(filename));
            Properties p = new Properties();
            p.load(infile);
            for (PropertyInterface node : this.props.values()) {
                String key = this.nameToKey(node.getName());
                String value = p.getProperty(key);
                if (value != null) {
                    node.convertFromString(value);
                    X3DLog.debug("   Property ", key, " = ", node.convertToString());
                    continue;
                }
                X3DLog.debug("   Property ", key, " not found, using defaults");
            }
            infile.close();
        }
        catch (FileNotFoundException e) {
            X3DLog.exception("Property file ", filename, " not found, using defaults");
        }
        catch (IOException e) {
            Check.assertion(false, e.getMessage());
        }
    }
}

