/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.timing;

import org.xith3d.loop.Updatable;
import org.xith3d.loop.UpdatingThread;

public class PerformanceStats
implements Updatable {
    private long accumulatedTime;
    private int frameCount = 0;
    private float fps = 0.0f;
    private long mpf = 0L;
    private boolean printingEnabled;
    private static long RESOLUTION = 1000L;

    public PerformanceStats() {
        this(true);
    }

    public PerformanceStats(boolean printingEnabled) {
        this.printingEnabled = printingEnabled;
    }

    public void update(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        this.accumulatedTime += timingMode.getMilliSeconds(frameTime);
        ++this.frameCount;
        if (this.accumulatedTime > RESOLUTION) {
            this.mpf = this.accumulatedTime / (long)this.frameCount;
            this.fps = 1.0f / (float)(this.accumulatedTime / (long)this.frameCount) * (float)RESOLUTION;
            if (this.printingEnabled) {
                this.print();
            }
            this.accumulatedTime = 0L;
            this.frameCount = 0;
        }
    }

    private String round(float f) {
        return Float.toString((int)(f * 1000.0f) / 1000);
    }

    private String format(long l) {
        Long object = new Long(l);
        String base = object.toString();
        String formatted = "";
        int count = 0;
        for (int i = base.length() - 1; i >= 0; --i) {
            formatted = base.substring(i, i + 1) + formatted;
            if (++count != 3 || base.length() < 4) continue;
            count = 0;
            formatted = "'" + formatted;
        }
        return formatted;
    }

    public float getFPS() {
        return this.fps;
    }

    public long getMPF() {
        return this.mpf;
    }

    public boolean isPrintingEnabled() {
        return this.printingEnabled;
    }

    public void setPrintingEnabled(boolean printingEnabled) {
        this.printingEnabled = printingEnabled;
    }

    public void print() {
        System.out.print("Millis per frame  = " + this.format(this.mpf));
        System.out.println("\t\tFrames per second = " + this.round(this.fps));
    }
}

