/*
 * Decompiled with CFR 0.152.
 */
package org.em3d.core;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.em3d.core.AbstractObject;
import org.em3d.core.LocationTypes;
import org.em3d.xml.XML;
import org.em3d.xml.XMLNode;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Tuple3f;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.primitives.Cube;
import org.xith3d.scenegraph.primitives.Sphere;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scene {
    String level;
    int numberOfObjects = 0;
    Map<String, AbstractObject> mapNameObject = new HashMap<String, AbstractObject>();
    Map<String, AbstractObject> mapModelObject = new HashMap<String, AbstractObject>();
    List<AbstractObject> listObjects = new LinkedList<AbstractObject>();
    ListIterator<AbstractObject> objectIterator;
    Map<String, Location> mapNameLocation = new HashMap<String, Location>();
    List<Location> listLocations = new LinkedList<Location>();
    ListIterator<Location> locationIterator;
    List<Socket> listSockets = new LinkedList<Socket>();
    ListIterator<Socket> socketIterator;

    public Scene(String definition) {
        XML source = new XML("scripts/scenes/" + definition);
        this.level = "levels/" + source.get("scene.level", "none");
        for (XMLNode n : source.getAll("scene.sockets.socket")) {
            this.addSocket(Float.valueOf(n.get("x", "0")).floatValue(), Float.valueOf(n.get("y", "0")).floatValue(), Float.valueOf(n.get("z", "0")).floatValue(), Float.valueOf(n.get("width", "1")).floatValue(), Float.valueOf(n.get("height", "1")).floatValue(), n.get("texture", "brushedMetal.png"));
        }
        for (XMLNode n : source.getAll("scene.locations.location")) {
            this.addLocation(n.get("name", "unknown"), LocationTypes.valueOf(n.get("type", "OTHER")), Boolean.valueOf(n.get("pickable", "false")), Float.valueOf(n.get("x", "0")).floatValue(), Float.valueOf(n.get("y", "0")).floatValue(), Float.valueOf(n.get("z", "0")).floatValue(), Float.valueOf(n.get("radius", "0.5")).floatValue());
        }
    }

    public String getLevelName() {
        return this.level;
    }

    public void refreshNumberOfObjects() {
        this.numberOfObjects = this.listObjects.size();
    }

    public int getNumberOfObjects() {
        return this.numberOfObjects;
    }

    public List<Tuple3f> getLocations(String[] names) {
        LinkedList<Tuple3f> locs = new LinkedList<Tuple3f>();
        for (String name : names) {
            locs.add(this.getLocation(name).getValue());
        }
        return locs;
    }

    public void addObject(AbstractObject object) {
        this.mapNameObject.put(object.getName(), object);
        this.mapModelObject.put(object.getModelName(), object);
        this.listObjects.add(object);
    }

    public AbstractObject getObject(String name) {
        return this.mapNameObject.get(name);
    }

    public void resetObjectIterator() {
        this.objectIterator = this.listObjects.listIterator();
    }

    public boolean hasNextObject() {
        return this.objectIterator.hasNext();
    }

    public AbstractObject getNextObject() {
        return this.objectIterator.next();
    }

    public boolean isObject(String name) {
        return this.mapNameObject.containsKey(name);
    }

    public String[] getObjectNames() {
        String[] objectNames = new String[this.listObjects.size()];
        for (int i = 0; i < this.listObjects.size(); ++i) {
            objectNames[i] = this.listObjects.get(i).getName();
        }
        return objectNames;
    }

    public void addLocation(String name, LocationTypes type, boolean pickable, float x, float y, float z, float radius) {
        Location loc = new Location(name, type, pickable, x, y, z, radius);
        this.mapNameLocation.put(name, loc);
        this.listLocations.add(loc);
    }

    public Location getLocation(String name) {
        return this.mapNameLocation.get(name);
    }

    public void resetLocationIterator() {
        this.locationIterator = this.listLocations.listIterator();
    }

    public boolean hasNextLocation() {
        return this.locationIterator.hasNext();
    }

    public Location getNextLocation() {
        return this.locationIterator.next();
    }

    public boolean isLocation(String name) {
        return this.mapNameLocation.containsKey(name);
    }

    public boolean isLocationSocket(String name) {
        if (!this.isLocation(name)) {
            return false;
        }
        return this.mapNameLocation.get((Object)name).type == LocationTypes.SOCKET;
    }

    public boolean isLocationTable(String name) {
        if (!this.isLocation(name)) {
            return false;
        }
        return this.mapNameLocation.get((Object)name).type == LocationTypes.TABLE;
    }

    public String[] getLocationNames(LocationTypes type) {
        LinkedList<String> locations = new LinkedList<String>();
        this.resetLocationIterator();
        while (this.hasNextLocation()) {
            Location loc = this.getNextLocation();
            if (loc.type != type) continue;
            locations.add(loc.getName());
        }
        return locations.toArray(new String[0]);
    }

    public void addSocket(float x, float y, float z, float width, float height, String texture) {
        this.listSockets.add(new Socket(x, y, z, width, height, texture));
    }

    public void resetSocketIterator() {
        this.socketIterator = this.listSockets.listIterator();
    }

    public boolean hasNextSocket() {
        return this.socketIterator.hasNext();
    }

    public Cube getNextSocket(boolean shadows) {
        return this.socketIterator.next().getSocket(shadows);
    }

    public class Socket {
        float x;
        float y;
        float z;
        float width;
        float height;
        String texture;

        Socket(float x, float y, float z, float width, float height, String texture) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.width = width;
            this.height = height;
            this.texture = texture;
        }

        public Tuple3f getPosition() {
            return new Tuple3f(this.x, this.y, this.z);
        }

        public Cube getSocket(boolean shadows) {
            Cube socket = new Cube(1.0f, this.texture);
            StaticTransform.scale(socket, this.width, this.height, this.width);
            StaticTransform.translate(socket, this.x, this.y, this.z);
            if (shadows) {
                socket.setIsOccluder(true);
                socket.setIsShadowReceiver(true);
            }
            return socket;
        }
    }

    public class Location {
        float x;
        float y;
        float z;
        float r;
        String name;
        boolean pickable;
        LocationTypes type;

        Location(String name, LocationTypes type, boolean pickable, float x, float y, float z, float radius) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.r = radius;
            this.name = name;
            this.pickable = pickable;
            this.type = type;
        }

        public Tuple3f getValue() {
            return new Tuple3f(this.x, this.y, this.z);
        }

        public Tuple3f getScaledValue(float scale) {
            return new Tuple3f(this.x / scale, this.y / scale, this.z / scale);
        }

        public float getRadius() {
            return this.r;
        }

        public String getName() {
            return this.name;
        }

        public Sphere getLocationSphere(boolean debug) {
            Sphere loc = new Sphere(this.r, 5, 5, Colorf.BLUE);
            loc.setVisible(debug);
            loc.setPickable(this.pickable);
            loc.setName(this.name);
            StaticTransform.translate(loc, this.x, this.y, this.z);
            return loc;
        }
    }
}

