/*
 * Decompiled with CFR 0.152.
 */
package org.em3d.phases;

import java.util.HashMap;
import java.util.Map;
import org.em3d.core.Scene;
import org.em3d.phases.Phase;
import org.em3d.phases.WorldInterface;
import org.em3d.results.Results;

public class FreeRecallOrder
extends Phase {
    Map<String, String> currentLocationObject = new HashMap<String, String>();
    String holdingObject;

    public FreeRecallOrder(WorldInterface worldIface, Scene scene, String playerStartPosition, String playerFacingLocation, String gui, int freedom) {
        super(worldIface, scene, playerStartPosition, playerFacingLocation, gui, freedom);
    }

    public void initialize(Results results) {
        super.initialize(results);
        results.setCorrectOrder(this.scene.getObjectNames());
        String[] objects = this.shuffleArray(this.scene.getObjectNames());
        this.scene.resetLocationIterator();
        String loc = "none";
        for (String o : objects) {
            if (!this.scene.hasNextLocation()) break;
            loc = this.scene.getNextLocation().getName();
            while (!this.scene.isLocationTable(loc)) {
                loc = this.scene.getNextLocation().getName();
            }
            this.world.showObject(o, loc);
            this.world.setObjectPickable(o, true);
            this.currentLocationObject.put(loc, o);
        }
    }

    public void locationSelected(String locationName) {
        String object = this.currentLocationObject.get(locationName);
        if (this.holdingObject == null) {
            if (object != null) {
                this.world.hideObject(object);
                this.holdingObject = object;
                this.world.showObjectInHud(this.holdingObject);
                this.currentLocationObject.put(locationName, null);
            }
        } else {
            this.world.hideObject(object);
            this.world.showObject(this.holdingObject, locationName);
            this.currentLocationObject.put(locationName, this.holdingObject);
            this.holdingObject = object;
            this.world.showObjectInHud(this.holdingObject);
        }
    }

    public void mouseOverLocation(String locationName) {
        this.gui.showFocus(true);
    }

    public void userFinish() {
        String[] order = new String[this.scene.getNumberOfObjects()];
        this.scene.resetLocationIterator();
        int i = 0;
        while (this.scene.hasNextLocation()) {
            String l = this.scene.getNextLocation().getName();
            if (!this.scene.isLocationTable(l)) continue;
            order[i] = this.currentLocationObject.get(l);
            ++i;
        }
        this.results.setUserOrder(order);
        this.finished = true;
    }
}

