/*
 * Decompiled with CFR 0.152.
 */
package org.em3d.phases;

import java.util.HashMap;
import java.util.Map;
import org.em3d.core.Scene;
import org.em3d.phases.Phase;
import org.em3d.phases.WorldInterface;
import org.em3d.results.Results;

public class FreeRecallPositions
extends Phase {
    Map<String, String> currentLocationObject = new HashMap<String, String>();
    Map<String, String> currentObjectLocation = new HashMap<String, String>();
    String holdingObject;

    public FreeRecallPositions(WorldInterface worldIface, Scene scene, String playerStartPosition, String playerFacingLocation, String gui, int freedom) {
        super(worldIface, scene, playerStartPosition, playerFacingLocation, gui, freedom);
    }

    public void initialize(Results results) {
        super.initialize(results);
        this.scene.resetObjectIterator();
        String[] locations = new String[this.scene.getObjectNames().length];
        int i = 0;
        while (this.scene.hasNextObject()) {
            locations[i] = this.scene.getNextObject().getFirstLocationName();
            ++i;
        }
        results.setCorrectLocations(locations);
        results.setCorrectOrder(this.scene.getObjectNames());
        String[] objects = this.shuffleArray(this.scene.getObjectNames());
        this.scene.resetLocationIterator();
        String loc = "none";
        for (String o : objects) {
            if (!this.scene.hasNextLocation()) break;
            loc = this.scene.getNextLocation().getName();
            while (!this.scene.isLocationTable(loc)) {
                loc = this.scene.getNextLocation().getName();
            }
            this.world.showObject(o, loc);
            this.world.setObjectPickable(o, true);
            this.currentLocationObject.put(loc, o);
            this.currentObjectLocation.put(o, loc);
        }
    }

    public void locationSelected(String locationName) {
        String object = this.currentLocationObject.get(locationName);
        if (this.holdingObject == null) {
            if (object != null) {
                this.world.hideObject(object);
                this.holdingObject = object;
                this.world.showObjectInHud(this.holdingObject);
                this.currentLocationObject.put(locationName, null);
                this.currentObjectLocation.put(object, null);
            }
        } else if (this.scene.isLocationSocket(locationName)) {
            this.world.hideObject(object);
            this.world.showObject(this.holdingObject, locationName);
            this.currentLocationObject.put(locationName, this.holdingObject);
            this.currentObjectLocation.put(this.holdingObject, locationName);
            this.holdingObject = object;
            this.world.showObjectInHud(this.holdingObject);
        }
    }

    public void mouseOverLocation(String locationName) {
        if (this.scene.isLocationSocket(locationName)) {
            this.gui.showFocus(true);
        }
        if (this.scene.isLocationTable(locationName) && this.holdingObject == null && this.currentLocationObject.get(locationName) != null) {
            this.gui.showFocus(true);
        }
    }

    public void userFinish() {
        String[] objects = this.scene.getObjectNames();
        for (int i = 0; i < objects.length; ++i) {
            objects[i] = this.currentObjectLocation.get(objects[i]);
        }
        this.results.setUserLocations(objects);
        this.finished = true;
    }
}

