/*
 * Decompiled with CFR 0.152.
 */
package org.em3d.phases;

import org.em3d.core.Scene;
import org.em3d.gui.GUI;
import org.em3d.phases.WorldInterface;
import org.em3d.results.Results;

public class Phase {
    public static final int PLAYER_MOVEMENT_FREE = 0;
    public static final int PLAYER_MOVEMENT_STRAFE = 1;
    public static final int PLAYER_MOVEMENT_NONE = 2;
    protected String playerStart;
    protected String playerFacing;
    GUI gui;
    int freedom;
    boolean finished = false;
    long zeroTime = -1L;
    long currentTime = -1L;
    WorldInterface world;
    Scene scene;
    Results results;

    public Phase(WorldInterface worldIface, Scene scene, String playerStartPosition, String playerFacingLocation, String gui, int freedom) {
        this.world = worldIface;
        this.scene = scene;
        this.freedom = freedom;
        this.playerStart = playerStartPosition;
        this.playerFacing = playerFacingLocation;
        this.gui = new GUI(this.world, this, gui);
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void initialize(Results results) {
        this.results = results;
        this.world.changeGUI(this.gui);
        this.world.setPlayerPosition(this.playerStart, this.playerFacing);
        if (this.freedom == 2) {
            this.world.setPlayerMovement(false, false, true);
        }
        if (this.freedom == 0) {
            this.world.setPlayerMovement(true, true, true);
        }
        if (this.freedom == 1) {
            this.world.setPlayerMovement(false, true, false);
        }
    }

    public void update(long gameTime) {
        if (this.zeroTime == -1L) {
            this.zeroTime = gameTime;
        }
        this.currentTime = (gameTime - this.zeroTime) / 1000L;
    }

    public void locationSelected(String locationName) {
    }

    public void objectSelected(String objectName) {
    }

    public void collision(String object1, String object2) {
    }

    public void mouseOverLocation(String locationName) {
    }

    public void mouseOverObject(String objectName) {
    }

    public void mouseOverNothing() {
        this.gui.showFocus(false);
    }

    public void restartPlayerPosition() {
        this.world.setPlayerPosition(this.playerStart, this.playerFacing);
    }

    public void setWorldInterface(WorldInterface iface) {
        this.world = iface;
    }

    public void userFinish() {
        this.finished = true;
    }

    public void userNextConfiguration() {
    }

    public void userPreviousConfiguration() {
    }

    public void userCollision() {
    }

    public void countdownFinished() {
    }

    public boolean switchInterposition() {
        return true;
    }

    public boolean switchProjection() {
        return true;
    }

    public boolean switchShading() {
        return true;
    }

    public boolean switchShadows() {
        return true;
    }

    public boolean switchFog() {
        return false;
    }

    protected String[] shuffleArray(String[] a) {
        String[] result = (String[])a.clone();
        int pos = (int)(Math.random() * (double)result.length) + 1;
        for (int i = 0; i < pos; ++i) {
            int j = (int)(Math.random() * (double)result.length);
            while (i == j) {
                j = (int)(Math.random() * (double)result.length);
            }
            String s = result[i];
            result[i] = result[j];
            result[j] = s;
        }
        return result;
    }
}

