/*
 * Decompiled with CFR 0.152.
 */
package org.em3d.results;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.em3d.results.PhaseResults;

public class CollisionsResults
extends PhaseResults {
    private static final float TIME_WINDOW = 2.0f;
    Long[] correctTimes;
    Long[] userTimes;
    List<Event> events = new LinkedList<Event>();
    float overallPrecission;
    int falseAlarms = 0;

    public void setCorrectCollisionTimes(Long[] times) {
        this.correctTimes = times;
    }

    public void setUserCollisionTimes(Long[] times) {
        this.userTimes = times;
    }

    private void process() {
        float sumPrecission = 0.0f;
        int count = 0;
        for (Long c : this.correctTimes) {
            Collision col = new Collision(c);
            for (Long u : this.userTimes) {
                boolean nearest = true;
                for (Long o : this.correctTimes) {
                    if (Math.abs(c - u) <= Math.abs(o - u)) continue;
                    nearest = false;
                    break;
                }
                if (!nearest) continue;
                col.addGuess(u);
            }
            this.falseAlarms += col.excludeFalseAlarms();
            this.events.add(col);
            if (col.getPrecision() == -1.0f) continue;
            sumPrecission += col.getPrecision();
            ++count;
        }
        this.overallPrecission = sumPrecission / (float)count;
    }

    public String printResults() {
        this.process();
        String res = "\n--- " + this.text.getText("results.collisions.title." + this.lang, "???") + " ----";
        res = res + "\n " + this.correctTimes.length + " " + this.text.getText("results.collisions.nof_collisions." + this.lang, "???") + "";
        res = res + "\n " + (this.userTimes.length - this.falseAlarms) + " " + this.text.getText("results.collisions.nof_guesses." + this.lang, "???") + "";
        res = res + "\n " + this.falseAlarms + " " + this.text.getText("results.collisions.nof_falarms." + this.lang, "???") + "";
        res = res + "\n " + this.text.getText("results.collisions.breakdown." + this.lang, "???") + ":";
        Iterator<Event> cit = this.events.iterator();
        int i = 1;
        while (cit.hasNext()) {
            res = res + "\n----";
            res = res + "\n" + i + cit.next();
            ++i;
        }
        res = res + "\n\n " + this.text.getText("results.collisions.overall." + this.lang, "???") + ": " + this.overallPrecission;
        return res;
    }

    public void saveResults(PrintWriter pw, String separator) {
        pw.println("--- Phase: Collisions ----");
        pw.println("type" + separator + "time" + separator + "worst guess" + separator + "precision");
        Iterator<Event> cit = this.events.iterator();
        boolean i = true;
        while (cit.hasNext()) {
            pw.println(cit.next().println(separator));
        }
    }

    private class FalseAlarm
    extends Event {
        float time;

        FalseAlarm(float cTime) {
            this.time = cTime;
        }

        public String toString() {
            String str = " - " + CollisionsResults.this.text.getText("results.collisions.event.falarm." + CollisionsResults.this.lang, "???") + " ";
            str = str + "\n" + CollisionsResults.this.text.getText("results.collisions.event.ftime." + CollisionsResults.this.lang, "???") + ": " + this.time;
            return str;
        }

        public String println(String separator) {
            return "false alarm" + separator + this.time + separator + separator;
        }

        public int excludeFalseAlarms() {
            return 0;
        }
    }

    private class Collision
    extends Event {
        float time;
        List<Float> guesses;

        Collision(Long cTime) {
            this.time = (float)cTime.longValue() / 1000.0f;
            this.guesses = new LinkedList<Float>();
        }

        public void addGuess(Long guess) {
            this.guesses.add(Float.valueOf((float)guess.longValue() / 1000.0f));
        }

        public float getWorstGuess() {
            if (this.guesses.size() == 0) {
                return Float.NaN;
            }
            float worst = this.time;
            for (float current : this.guesses) {
                if (!(Math.abs(current - this.time) > Math.abs(worst - this.time))) continue;
                worst = current;
            }
            return worst;
        }

        public float getPrecision() {
            if (this.guesses.size() == 0) {
                return -1.0f;
            }
            return Math.abs(this.time - this.getWorstGuess());
        }

        public int excludeFalseAlarms() {
            int count = 0;
            Iterator<Float> git = this.guesses.iterator();
            while (git.hasNext()) {
                Float guess = git.next();
                if (!(Math.abs(guess.floatValue() - this.time) > 2.0f)) continue;
                git.remove();
                CollisionsResults.this.events.add(new FalseAlarm(guess.floatValue()));
                ++count;
            }
            return count;
        }

        public String toString() {
            String str = " - " + CollisionsResults.this.text.getText("results.collisions.event.collision." + CollisionsResults.this.lang, "???") + " ";
            str = str + "\n" + CollisionsResults.this.text.getText("results.collisions.event.realtime." + CollisionsResults.this.lang, "???") + ": " + this.time;
            str = str + "\n" + CollisionsResults.this.text.getText("results.collisions.event.guesses." + CollisionsResults.this.lang, "???") + ": " + this.guesses.size();
            Iterator<Float> git = this.guesses.iterator();
            int c = 1;
            while (git.hasNext()) {
                str = str + "\n" + CollisionsResults.this.text.getText("results.collisions.event.guess." + CollisionsResults.this.lang, "???") + " " + c + ": " + git.next();
                ++c;
            }
            if (!String.valueOf(this.getWorstGuess()).equals("NaN")) {
                str = str + "\n" + CollisionsResults.this.text.getText("results.collisions.event.worst." + CollisionsResults.this.lang, "???") + ": " + this.getWorstGuess();
            }
            if (this.getPrecision() != -1.0f) {
                str = str + "\n" + CollisionsResults.this.text.getText("results.collisions.event.precision." + CollisionsResults.this.lang, "???") + ": " + this.getPrecision();
            }
            return str;
        }

        public String println(String separator) {
            String wg = String.valueOf(this.getWorstGuess()).equals("NaN") ? "" : String.valueOf(this.getWorstGuess());
            String p = this.getPrecision() == -1.0f ? "" : String.valueOf(this.getPrecision());
            return "collision" + separator + this.time + separator + wg + separator + p;
        }
    }

    private abstract class Event {
        private Event() {
        }

        public abstract int excludeFalseAlarms();

        public abstract String println(String var1);
    }
}

