/*
 * Decompiled with CFR 0.152.
 */
package org.em3d.results;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.em3d.phases.PhaseTypes;
import org.em3d.results.CollisionsResults;
import org.em3d.results.FreeRecallOrderResults;
import org.em3d.results.FreeRecallPositionsResults;
import org.em3d.results.PhaseResults;
import org.em3d.results.RecallWithHintResults;
import org.em3d.results.RecognitionOfOrderResults;
import org.em3d.results.RecognitionOfPositionsResults;
import org.em3d.xml.XML;

public class Results {
    boolean memory;
    List<PhaseResults> timeline;
    PhaseResults current;
    XML text;
    String language;
    String title;

    public Results(int type, String language) {
        this.memory = type == 1;
        this.timeline = new LinkedList<PhaseResults>();
        this.language = language;
        this.text = new XML("scripts/GUI/results_text.xml");
        this.title = this.text.getText("results.title." + language, "no title");
    }

    public Results newPhase(PhaseTypes type) {
        System.out.println("NEW PHASE: " + (Object)((Object)type));
        this.current = null;
        switch (type) {
            case MOVE: {
                break;
            }
            case FREE_RECALL_ORDER: {
                this.current = new FreeRecallOrderResults();
                break;
            }
            case FREE_RECALL_POSITIONS: {
                this.current = new FreeRecallPositionsResults();
                break;
            }
            case RECALL_WITH_HINT: {
                this.current = new RecallWithHintResults();
                break;
            }
            case RECOGNITION_OF_ORDER: {
                this.current = new RecognitionOfOrderResults();
                break;
            }
            case RECOGNITION_OF_POSITIONS: {
                this.current = new RecognitionOfPositionsResults();
                break;
            }
            case COLLISIONS: {
                this.current = new CollisionsResults();
                break;
            }
        }
        if (this.current != null) {
            this.current.setText(this.text, this.language);
            this.timeline.add(this.current);
        }
        return this;
    }

    public void setCorrectOrder(String[] objects) {
        this.current.setCorrectOrder(objects);
    }

    public void setCorrectLocations(String[] locations) {
        this.current.setCorrectLocations(locations);
    }

    public void setUserOrder(String[] objects) {
        this.current.setUserOrder(objects);
    }

    public void setUserLocations(String[] locations) {
        this.current.setUserLocations(locations);
    }

    public void setCorrectCollisionTimes(Long[] times) {
        this.current.setCorrectCollisionTimes(times);
    }

    public void setUserCollisionTimes(Long[] times) {
        this.current.setUserCollisionTimes(times);
    }

    private void printStrings(String prefix, String[] strings) {
        System.out.print(prefix);
        for (int i = 0; i < strings.length; ++i) {
            System.out.print(strings[i] + ", ");
        }
        System.out.println();
    }

    public String returnResults() {
        String res = this.title + ": \n";
        Iterator<PhaseResults> resIt = this.timeline.iterator();
        while (resIt.hasNext()) {
            res = res + resIt.next().printResults();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveResults(String filename) {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new FileWriter(new File(filename)));
            Iterator<PhaseResults> resIt = this.timeline.iterator();
            while (resIt.hasNext()) {
                resIt.next().saveResults(pw, ",");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            pw.close();
        }
    }
}

