/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.launcher;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.jagatoo.commandline.ArgumentsRegistry;
import org.jagatoo.commandline.CommandlineParser;
import org.jagatoo.commandline.CommandlineParsingException;
import org.xith3d.loop.InputAdapterRenderLoop;
import org.xith3d.loop.RenderLoop;
import org.xith3d.render.config.CanvasConstructionInfo;
import org.xith3d.render.config.DisplayMode;
import org.xith3d.render.config.DisplayModeSelector;
import org.xith3d.render.config.OpenGLLayer;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.commandline.XithArgumentsHandler;
import org.xith3d.utility.commandline.XithArgumentsRegistry;

public abstract class Xith3DTest
extends InputAdapterRenderLoop {
    private static final OpenGLLayer FALLBACK_DEFAULT_OGLLAYER = OpenGLLayer.JOGL_AWT;
    public static OpenGLLayer DEFAULT_OGL_LAYER = OpenGLLayer.getDefault();
    public static final DisplayMode DEFAULT_DISPLAY_MODE;
    public static final DisplayMode.FullscreenMode DEFAULT_FULLSCREEN;
    public static final boolean DEFAULT_VSYNC;
    private FinishListener finishListener = null;

    protected static final CanvasConstructionInfo createCCI(OpenGLLayer oglLayer, DisplayMode displayMode, DisplayMode.FullscreenMode fullscreen, boolean vsyncEnabled, String title) {
        if (oglLayer != null && !oglLayer.equals(DEFAULT_OGL_LAYER)) {
            displayMode = DisplayModeSelector.getImplementation(oglLayer).getBestMode(displayMode.getWidth(), displayMode.getHeight(), displayMode.getBPP(), displayMode.getFrequency());
        }
        if (oglLayer == null) {
            oglLayer = OpenGLLayer.getDefault();
        }
        return new CanvasConstructionInfo(oglLayer, displayMode, fullscreen, vsyncEnabled, title);
    }

    protected static final CanvasConstructionInfo createCCI(DisplayMode displayMode, DisplayMode.FullscreenMode fullscreen, boolean vsyncEnabled, String title) {
        return Xith3DTest.createCCI(null, displayMode, fullscreen, vsyncEnabled, title);
    }

    protected static final CanvasConstructionInfo createCCI(DisplayMode displayMode, boolean vsyncEnabled, String title) {
        return Xith3DTest.createCCI(displayMode, DEFAULT_FULLSCREEN, vsyncEnabled, title);
    }

    protected static final CanvasConstructionInfo createCCI(boolean vsyncEnabled, String title) {
        return Xith3DTest.createCCI(DEFAULT_DISPLAY_MODE, vsyncEnabled, title);
    }

    protected static final CanvasConstructionInfo createCCI(OpenGLLayer oglLayer, boolean vsyncEnabled, String title) {
        return Xith3DTest.createCCI(oglLayer, DEFAULT_DISPLAY_MODE, DEFAULT_FULLSCREEN, vsyncEnabled, title);
    }

    protected static final CanvasConstructionInfo createCCI(OpenGLLayer oglLayer, String title) {
        return Xith3DTest.createCCI(oglLayer, DEFAULT_DISPLAY_MODE, DEFAULT_FULLSCREEN, DEFAULT_VSYNC, title);
    }

    protected static final CanvasConstructionInfo createCCI(String title) {
        return Xith3DTest.createCCI(DEFAULT_VSYNC, title);
    }

    public static final BasicApplicationArguments parseCommandLine(String[] args) throws CommandlineParsingException {
        XithArgumentsHandler handler = new XithArgumentsHandler();
        ArgumentsRegistry argReg = XithArgumentsRegistry.createStandardArgumentsRegistry();
        CommandlineParser parser = new CommandlineParser(argReg, handler);
        parser.parseCommandline(args);
        if (handler.helpRequested()) {
            argReg.dump();
            System.exit(0);
        }
        return handler.getArguments();
    }

    protected void exit() {
        if (this.finishListener != null) {
            super.end();
            this.finishListener.onTestFinished();
        } else {
            super.exit();
        }
    }

    public void begin(FinishListener finishListener) {
        this.finishListener = finishListener;
        this.begin(RenderLoop.RunMode.RUN_IN_SAME_THREAD);
    }

    public void begin(FinishListener finishListener, RenderLoop.RunMode runMode) {
        this.finishListener = finishListener;
        this.begin(runMode);
    }

    protected Xith3DTest(Float maxFPS) {
        super(maxFPS == null ? Float.MAX_VALUE : maxFPS.floatValue());
    }

    static {
        try {
            String defaultOGLLayer = System.getProperty("org.xith3d.test.OpenGLLayer.default", FALLBACK_DEFAULT_OGLLAYER.name());
            DEFAULT_OGL_LAYER = OpenGLLayer.valueOf(defaultOGLLayer);
            if (DEFAULT_OGL_LAYER != null) {
                DEFAULT_OGL_LAYER = FALLBACK_DEFAULT_OGLLAYER;
            }
        }
        catch (Throwable t) {
            DEFAULT_OGL_LAYER = FALLBACK_DEFAULT_OGLLAYER;
        }
        DEFAULT_DISPLAY_MODE = DisplayModeSelector.getImplementation(DEFAULT_OGL_LAYER).getBestMode(800, 600);
        DEFAULT_FULLSCREEN = DisplayMode.WINDOWED;
        DEFAULT_VSYNC = DisplayMode.VSYNC_ENABLED;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Description {
        public String[] fulltext();

        public String[] authors();
    }

    public static interface FinishListener {
        public void onTestFinished();
    }
}

