/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.curves;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.openmali.FastMath;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple2f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CubicBezierSpline {
    private final float defaultErrorTolerance = 1.0E-4f;
    private final LinkedList<Point3f> points = new LinkedList();
    private final ArrayList<SUMapEntry> suMapping;
    private Point3f[] basePoints;
    private Point3f[] controlPoints;
    private float length;

    public float getLength() {
        return this.length;
    }

    public final Point3f[] getBasePoints() {
        return this.basePoints;
    }

    public Point3f getBasePoint(int n) {
        return this.basePoints[n];
    }

    public void addBasePoint(Tuple3f point) {
        this.addBasePoint(this.closestSubcurve(point) + 1, point);
    }

    public void addBasePoint(int index, Tuple3f point) {
        if (index < 0 || index > this.basePoints.length) {
            throw new ArrayIndexOutOfBoundsException("The index " + index + " is out of 0 < index < " + this.basePoints.length + "!");
        }
        if (point == null) {
            throw new IllegalArgumentException("Parameter point may not be null!");
        }
        Point3f[] tmp = new Point3f[this.basePoints.length + 1];
        if (index > 0) {
            System.arraycopy(this.basePoints, 0, tmp, 0, index);
        }
        if (index < this.basePoints.length) {
            System.arraycopy(this.basePoints, index, tmp, index + 1, this.basePoints.length - index);
        }
        tmp[index] = new Point3f(point);
        this.basePoints = tmp;
        tmp = new Point3f[(this.basePoints.length - 1) * 2];
        if (index > 0) {
            System.arraycopy(this.controlPoints, 0, tmp, 0, index * 2 - 1);
        }
        if (index < this.basePoints.length) {
            System.arraycopy(this.controlPoints, index * 2 - 1, tmp, index * 2 + 1, this.controlPoints.length - index * 2 + 1);
        }
        this.controlPoints = tmp;
        this.generateControlPoints(index, index + 1);
    }

    public final Point3f[] getControlPoints() {
        return this.controlPoints;
    }

    public Point3f getControlPoint(int n) {
        return this.controlPoints[n];
    }

    public List<Point3f> getPoints() {
        return this.points;
    }

    public static <P extends Tuple3f> P evalPoint(Tuple3f p0, Tuple3f p1, Tuple3f p2, Tuple3f p3, float t, P p) {
        p.setX(FastMath.pow3(1.0f - t) * p0.getX() + 3.0f * t * FastMath.pow2(1.0f - t) * p1.getX() + 3.0f * FastMath.pow2(t) * (1.0f - t) * p2.getX() + FastMath.pow3(t) * p3.getX());
        p.setY(FastMath.pow3(1.0f - t) * p0.getY() + 3.0f * t * FastMath.pow2(1.0f - t) * p1.getY() + 3.0f * FastMath.pow2(t) * (1.0f - t) * p2.getY() + FastMath.pow3(t) * p3.getY());
        p.setZ(FastMath.pow3(1.0f - t) * p0.getZ() + 3.0f * t * FastMath.pow2(1.0f - t) * p1.getZ() + 3.0f * FastMath.pow2(t) * (1.0f - t) * p2.getZ() + FastMath.pow3(t) * p3.getZ());
        return p;
    }

    public static Point3f evalPoint(Tuple3f p0, Tuple3f p1, Tuple3f p2, Tuple3f p3, float t) {
        return CubicBezierSpline.evalPoint(p0, p1, p2, p3, t, new Point3f());
    }

    public static Tuple3f[] evalPoints(Tuple3f p0, Tuple3f p1, Tuple3f p2, Tuple3f p3, Tuple3f[] result) {
        int i = 0;
        while (i < result.length) {
            if (result[i] == null) {
                result[i] = new Point3f();
            }
            CubicBezierSpline.evalPoint(p0, p1, p2, p3, (float)i / (float)(result.length - 1), result[i]);
            ++i;
        }
        return result;
    }

    public static final Point3f[] evalPoints(Tuple3f p0, Tuple3f p1, Tuple3f p2, Tuple3f p3, Point3f[] result) {
        return (Point3f[])CubicBezierSpline.evalPoints(p0, p1, p2, p3, (Tuple3f[])result);
    }

    public static Point3f[] evalPoints(Tuple3f p0, Tuple3f p1, Tuple3f p2, Tuple3f p3, int numPoints) {
        return CubicBezierSpline.evalPoints(p0, p1, p2, p3, new Point3f[numPoints]);
    }

    public <P extends Tuple3f> P samplePoint(float s, P p) {
        float u;
        int subcurve;
        block4: {
            if (s < 0.0f) {
                s = 0.0f;
            }
            if (s > 1.0f) {
                s = 1.0f;
            }
            subcurve = 0;
            u = 0.0f;
            SUMapEntry min = this.suMapping.get(0);
            int i = 1;
            while (i < this.suMapping.size()) {
                SUMapEntry max = this.suMapping.get(i);
                if (max.s > s && s >= min.s) {
                    subcurve = min.subcurve;
                    u = (max.s - s) / (max.s - min.s) * min.u + (s - min.s) / (max.s - min.s) * max.u;
                    break block4;
                }
                min = max;
                ++i;
            }
            subcurve = this.basePoints.length - 2;
            u = 1.0f;
        }
        P result = CubicBezierSpline.evalPoint(this.basePoints[subcurve], this.controlPoints[subcurve * 2], this.controlPoints[subcurve * 2 + 1], this.basePoints[subcurve + 1], u, p);
        return result;
    }

    public final Point3f samplePoint(float t) {
        return this.samplePoint(t, new Point3f());
    }

    public Tuple3f[] samplePoints(Tuple3f[] result) {
        int i = 0;
        while (i < result.length) {
            if (result[i] == null) {
                result[i] = new Point3f();
            }
            this.samplePoint((float)i / (float)(result.length - 1), result[i]);
            ++i;
        }
        return result;
    }

    public final Point3f[] samplePoints(Point3f[] result) {
        return (Point3f[])this.samplePoints((Tuple3f[])result);
    }

    public Point3f[] samplePoints(int numPoints) {
        Point3f[] points = new Point3f[numPoints];
        this.samplePoints(points);
        return points;
    }

    public void update() {
        int subcurves = this.basePoints.length - 1;
        this.points.clear();
        this.length = 0.0f;
        int i = 0;
        while (i < subcurves) {
            this.points.add(this.basePoints[i]);
            this.points.add(this.controlPoints[i * 2]);
            this.points.add(this.controlPoints[i * 2 + 1]);
            ++i;
        }
        this.points.add(this.basePoints[subcurves]);
        ListIterator<Point3f> iter = this.points.listIterator();
        this.suMapping.clear();
        float[] runlength = new float[]{0.0f};
        int i2 = 0;
        while (i2 < subcurves) {
            this.subdivideLength(i2, 0.0f, 1.0f, iter, this.suMapping, runlength, 1.0E-4f);
            ++i2;
        }
        this.length = runlength[0];
        i2 = 0;
        while (i2 < this.suMapping.size()) {
            this.suMapping.get((int)i2).s /= this.length;
            ++i2;
        }
    }

    public void generateControlPoints(int start, int end) {
        int maxI = this.basePoints.length - 1;
        Tuple3f p0m1 = Tuple3f.fromPool();
        p0m1.set((TupleNf)this.basePoints[0]);
        p0m1.sub(this.basePoints[1]);
        p0m1.add(this.basePoints[0]);
        Tuple3f pnp1 = Tuple3f.fromPool();
        pnp1.set((TupleNf)this.basePoints[this.basePoints.length - 1]);
        pnp1.sub(this.basePoints[this.basePoints.length - 2]);
        pnp1.add(this.basePoints[this.basePoints.length - 1]);
        Tuple3f tmp = Tuple3f.fromPool();
        int j = (start - 1) * 2;
        Point3f cp = null;
        float tl = 0.2f;
        int i = start - 1;
        while (i < end) {
            Tuple3f pip2;
            Tuple3f pim1 = i < 1 ? p0m1 : this.basePoints[i - 1];
            Tuple3f pi = i < 0 ? p0m1 : this.basePoints[i];
            Tuple3f pip1 = i + 1 > maxI ? pnp1 : this.basePoints[i + 1];
            Tuple3f tuple3f = pip2 = i + 2 > maxI ? pnp1 : this.basePoints[i + 2];
            if (j >= 0 && i < maxI && i >= start) {
                cp = new Point3f(pip1);
                cp.sub(pim1);
                cp.mul(tl);
                cp.add(pi);
                this.controlPoints[j++] = cp;
            } else {
                ++j;
            }
            if (j > 0 && i < maxI && i < end - 1) {
                cp = new Point3f(pi);
                cp.sub(pip2);
                cp.mul(tl);
                cp.add(pip1);
                this.controlPoints[j++] = cp;
            } else {
                ++j;
            }
            ++i;
        }
        Tuple3f.toPool(p0m1);
        Tuple3f.toPool(pnp1);
        Tuple3f.toPool(tmp);
        this.update();
    }

    public int closestPoint(float x, float y, float z, Tuple3f resultPoint, Tuple2f resultParams) {
        float closestDistance = Float.MAX_VALUE;
        float closestParameter = 0.0f;
        int closestSubcurve = 0;
        Vector3f p0 = Vector3f.fromPool();
        Vector3f p1 = Vector3f.fromPool();
        Vector3f p = Vector3f.fromPool();
        Vector3f v = Vector3f.fromPool();
        Vector3f w = Vector3f.fromPool();
        Vector3f tmp = Vector3f.fromPool();
        int i = 0;
        while (i < this.suMapping.size() - 1) {
            float d;
            SUMapEntry entry0 = this.suMapping.get(i);
            SUMapEntry entry1 = this.suMapping.get(i + 1);
            CubicBezierSpline.evalPoint(this.basePoints[entry0.subcurve], this.controlPoints[entry0.subcurve * 2], this.controlPoints[entry0.subcurve * 2 + 1], this.basePoints[entry0.subcurve + 1], entry0.u, p0);
            CubicBezierSpline.evalPoint(this.basePoints[entry1.subcurve], this.controlPoints[entry1.subcurve * 2], this.controlPoints[entry1.subcurve * 2 + 1], this.basePoints[entry1.subcurve + 1], entry1.u, p1);
            ((Tuple3f)v.set((TupleNf)p1)).sub(p0);
            w.set(x, y, z).sub(p0);
            float proj = w.dot(v);
            if (proj <= 0.0f) {
                d = w.lengthSquared();
                if (d < closestDistance) {
                    if (resultPoint != null) {
                        resultPoint.set((TupleNf)p0);
                    }
                    closestDistance = d;
                    closestParameter = entry0.s;
                    closestSubcurve = entry0.subcurve;
                }
            } else {
                float v2 = v.dot(v);
                if (proj >= v2) {
                    tmp.set(x, y, z).sub(p1);
                    d = tmp.lengthSquared();
                    if (d < closestDistance) {
                        if (resultPoint != null) {
                            resultPoint.set((TupleNf)p1);
                        }
                        closestDistance = d;
                        closestParameter = entry1.s;
                        closestSubcurve = entry0.subcurve;
                    }
                } else {
                    float u = entry0.u + proj / v2 * (entry1.u - entry0.u);
                    CubicBezierSpline.evalPoint(this.basePoints[entry0.subcurve], this.controlPoints[entry0.subcurve * 2], this.controlPoints[entry0.subcurve * 2 + 1], this.basePoints[entry0.subcurve + 1], u, p);
                    tmp.set(x, y, z).sub(p);
                    d = tmp.lengthSquared();
                    if (d < closestDistance) {
                        if (resultPoint != null) {
                            resultPoint.set((TupleNf)p);
                        }
                        closestDistance = d;
                        closestParameter = entry0.s + proj / v2 * (entry1.s - entry0.s);
                        closestSubcurve = entry0.subcurve;
                    }
                }
            }
            ++i;
        }
        Vector3f.toPool(tmp);
        Vector3f.toPool(w);
        Vector3f.toPool(v);
        Vector3f.toPool(p);
        Vector3f.toPool(p0);
        Vector3f.toPool(p1);
        if (resultParams != null) {
            resultParams.setX(closestParameter);
            resultParams.setY(closestDistance);
        }
        return closestSubcurve;
    }

    public int closestPoint(Tuple3f point, Tuple3f resultPoint, Tuple2f resultParams) {
        return this.closestPoint(point.getX(), point.getY(), point.getZ(), resultPoint, resultParams);
    }

    public int closestPoint(float x, float y, float z, Tuple3f resultPoint) {
        return this.closestPoint(x, y, z, resultPoint, null);
    }

    public int closestPoint(Tuple3f point, Tuple3f resultPoint) {
        return this.closestPoint(point.getX(), point.getY(), point.getZ(), resultPoint, null);
    }

    public int closestSubcurve(float x, float y, float z) {
        return this.closestPoint(x, y, z, null, null);
    }

    public int closestSubcurve(Tuple3f point) {
        return this.closestPoint(point.getX(), point.getY(), point.getZ(), null, null);
    }

    public float closestParameter(float x, float y, float z) {
        Tuple2f tmp = Tuple2f.fromPool();
        this.closestPoint(x, y, z, null, tmp);
        float param = tmp.getX();
        Tuple2f.toPool(tmp);
        return param;
    }

    public float closestParameter(Tuple3f p) {
        return this.closestParameter(p.getX(), p.getY(), p.getZ());
    }

    public float squaredDistanceTo(float x, float y, float z) {
        Tuple2f tmp = Tuple2f.fromPool();
        this.closestPoint(x, y, z, null, tmp);
        float dist = tmp.getY();
        Tuple2f.toPool(tmp);
        return dist;
    }

    public float squaredDistanceTo(Tuple3f p) {
        return this.squaredDistanceTo(p.getX(), p.getY(), p.getZ());
    }

    private void subdivideLength(int subcurve, float u1, float u2, ListIterator<Point3f> points, List<SUMapEntry> suMapping, float[] runlength, float errorTolerance) {
        Point3f p0 = points.next();
        Point3f p1 = points.next();
        Point3f p2 = points.next();
        Point3f p3 = points.next();
        points.previous();
        points.previous();
        points.remove();
        points.previous();
        points.remove();
        float lineLenght = ((Vector3f)new Vector3f(p3).sub(p0)).length();
        float pathLength = ((Vector3f)new Vector3f(p1).sub(p0)).length() + ((Vector3f)new Vector3f(p2).sub(p1)).length() + ((Vector3f)new Vector3f(p3).sub(p2)).length();
        float avgLength = 0.5f * (pathLength + lineLenght);
        float dl = pathLength - lineLenght;
        if (dl * dl / avgLength < errorTolerance) {
            suMapping.add(new SUMapEntry(runlength[0], subcurve, u1));
            runlength[0] = runlength[0] + avgLength;
            if (u2 == 1.0f) {
                suMapping.add(new SUMapEntry(runlength[0], subcurve, u2));
            }
            return;
        }
        Point3f h = (Point3f)((Tuple3f)new Point3f(p1).add(p2)).div(2.0f);
        Point3f l1 = (Point3f)((Tuple3f)new Point3f(p0).add(p1)).div(2.0f);
        Point3f l2 = (Point3f)((Tuple3f)new Point3f(l1).add(h)).div(2.0f);
        Point3f r2 = (Point3f)((Tuple3f)new Point3f(p2).add(p3)).div(2.0f);
        Point3f r1 = (Point3f)((Tuple3f)new Point3f(h).add(r2)).div(2.0f);
        Point3f m = (Point3f)((Tuple3f)new Point3f(l2).add(r1)).div(2.0f);
        points.add(l1);
        points.add(l2);
        points.add(m);
        points.add(r1);
        points.add(r2);
        int i = 0;
        while (i < 6) {
            points.previous();
            ++i;
        }
        this.subdivideLength(subcurve, u1, (u1 + u2) / 2.0f, points, suMapping, runlength, errorTolerance);
        this.subdivideLength(subcurve, (u1 + u2) / 2.0f, u2, points, suMapping, runlength, errorTolerance);
    }

    public CubicBezierSpline(Tuple3f[] points) {
        this(points, null);
    }

    public CubicBezierSpline(Tuple3f[] basePoints, Tuple3f[] controlPoints) {
        if (basePoints == null || basePoints.length < 2) {
            throw new IllegalArgumentException("Argument 'basePoints' needs to be non null and at least of length 2");
        }
        if (controlPoints != null && controlPoints.length < (basePoints.length - 1) * 2) {
            throw new IllegalArgumentException("Argument 'controlPoints' needs to be non null and has to contain at least two control points per patch.");
        }
        this.basePoints = new Point3f[basePoints.length];
        this.controlPoints = new Point3f[(basePoints.length - 1) * 2];
        this.suMapping = new ArrayList((basePoints.length - 1) * 16);
        int i = 0;
        while (i < basePoints.length) {
            this.basePoints[i] = new Point3f(basePoints[i]);
            ++i;
        }
        if (controlPoints != null) {
            i = 0;
            while (i < controlPoints.length) {
                this.controlPoints[i] = new Point3f(controlPoints[i]);
                ++i;
            }
            this.update();
        } else {
            this.generateControlPoints(0, basePoints.length);
        }
    }

    private static class SUMapEntry {
        public float s;
        public int subcurve;
        public final float u;

        public SUMapEntry(float s, int subcurve, float u) {
            this.s = s;
            this.subcurve = subcurve;
            this.u = u;
        }
    }
}

