/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.decomposition;

import org.openmali.FastMath;
import org.openmali.vecmath2.MatrixMxNf;

public class CholeskyDecomposition {
    private final MatrixMxNf L;
    private final int n;
    private boolean isSPD;

    public CholeskyDecomposition(MatrixMxNf M) {
        this.n = M.getNumRows();
        this.L = new MatrixMxNf(this.n, this.n);
        this.isSPD = M.getNumCols() == this.n;
        int j = 0;
        while (j < this.n) {
            float d = 0.0f;
            int k = 0;
            while (k < j) {
                float s = 0.0f;
                int i = 0;
                while (i < k) {
                    s += this.L.get(k, i) * this.L.get(j, i);
                    ++i;
                }
                s = (M.get(j, k) - s) / this.L.get(k, k);
                this.L.set(j, k, s);
                d += s * s;
                this.isSPD &= M.get(k, j) == M.get(j, k);
                ++k;
            }
            d = M.get(j, j) - d;
            this.isSPD &= d > 0.0f;
            this.L.set(j, j, FastMath.sqrt(Math.max(d, 0.0f)));
            k = j + 1;
            while (k < this.n) {
                this.L.set(j, k, 0.0f);
                ++k;
            }
            ++j;
        }
    }

    public final boolean isSPD() {
        return this.isSPD;
    }

    public MatrixMxNf getL() {
        return this.L;
    }

    public final void solve(MatrixMxNf B, MatrixMxNf result) {
        int i;
        int j;
        if (B.getNumRows() != this.n) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isSPD) {
            throw new RuntimeException("Matrix is not symmetric positive definite.");
        }
        int nx = B.getNumCols();
        if (result.getNumRows() != this.n || result.getNumCols() != nx) {
            throw new IllegalArgumentException("Result Matrix does not match required dimensions (" + this.n + " x " + nx + ").");
        }
        result.set(B);
        int k = 0;
        while (k < this.n) {
            j = 0;
            while (j < nx) {
                i = 0;
                while (i < k) {
                    result.sub(k, j, result.get(i, j) * this.L.get(k, i));
                    ++i;
                }
                result.div(k, j, this.L.get(k, k));
                ++j;
            }
            ++k;
        }
        k = this.n - 1;
        while (k >= 0) {
            j = 0;
            while (j < nx) {
                i = k + 1;
                while (i < this.n) {
                    result.sub(k, j, result.get(i, j) * this.L.get(i, k));
                    ++i;
                }
                result.div(k, j, this.L.get(k, k));
                ++j;
            }
            --k;
        }
    }
}

