/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.decomposition;

import org.openmali.vecmath2.MatrixMxNf;

public class LUDecomposition {
    private final MatrixMxNf LU;
    private int m;
    private int n;
    private int pivsign;
    private final int[] piv;

    public LUDecomposition(MatrixMxNf A) {
        this.LU = new MatrixMxNf(A);
        this.m = A.getNumRows();
        this.n = A.getNumCols();
        this.piv = new int[this.m];
        int i = 0;
        while (i < this.m) {
            this.piv[i] = i;
            ++i;
        }
        this.pivsign = 1;
        float[] LUrowi = new float[this.n];
        float[] LUcolj = new float[this.m];
        int j = 0;
        while (j < this.n) {
            this.LU.getColumn(j, LUcolj);
            int i2 = 0;
            while (i2 < this.m) {
                this.LU.getRow(i2, LUrowi);
                int kmax = Math.min(i2, j);
                float s = 0.0f;
                int k = 0;
                while (k < kmax) {
                    s += LUrowi[k] * LUcolj[k];
                    ++k;
                }
                int n = i2++;
                float f = LUcolj[n] - s;
                LUcolj[n] = f;
                LUrowi[j] = f;
            }
            int p = j;
            int i3 = j + 1;
            while (i3 < this.m) {
                if (Math.abs(LUcolj[i3]) > Math.abs(LUcolj[p])) {
                    p = i3;
                }
                ++i3;
            }
            if (p != j) {
                int k = 0;
                while (k < this.n) {
                    float t = this.LU.get(p, k);
                    this.LU.set(p, k, this.LU.get(j, k));
                    this.LU.set(j, k, t);
                    ++k;
                }
                k = this.piv[p];
                this.piv[p] = this.piv[j];
                this.piv[j] = k;
                this.pivsign = -this.pivsign;
            }
            if (j < this.m & this.LU.get(j, j) != 0.0f) {
                i3 = j + 1;
                while (i3 < this.m) {
                    this.LU.div(i3, j, this.LU.get(j, j));
                    ++i3;
                }
            }
            ++j;
        }
    }

    public final boolean isNonsingular() {
        int j = 0;
        while (j < this.n) {
            if (this.LU.get(j, j) == 0.0f) {
                return false;
            }
            ++j;
        }
        return true;
    }

    public MatrixMxNf getL() {
        MatrixMxNf L = new MatrixMxNf(this.m, this.n);
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                if (i > j) {
                    L.set(i, j, this.LU.get(i, j));
                } else if (i == j) {
                    L.set(i, j, 1.0f);
                } else {
                    L.set(i, j, 0.0f);
                }
                ++j;
            }
            ++i;
        }
        return L;
    }

    public MatrixMxNf getU() {
        MatrixMxNf U = new MatrixMxNf(this.n, this.n);
        int i = 0;
        while (i < this.n) {
            int j = 0;
            while (j < this.n) {
                if (i <= j) {
                    U.set(i, j, this.LU.get(i, j));
                } else {
                    U.set(i, j, 0.0f);
                }
                ++j;
            }
            ++i;
        }
        return U;
    }

    public final int[] getPivot() {
        int[] p = new int[this.m];
        System.arraycopy(this.piv, 0, p, 0, this.m);
        return p;
    }

    public final float det() {
        if (this.m != this.n) {
            throw new IllegalArgumentException("Matrix must be square.");
        }
        float d = this.pivsign;
        int j = 0;
        while (j < this.n) {
            d *= this.LU.get(j, j);
            ++j;
        }
        return d;
    }

    private static MatrixMxNf copySubMatrix(MatrixMxNf A, int[] rows, int c0, int c1) {
        MatrixMxNf B = new MatrixMxNf(rows.length, c1 - c0 + 1);
        try {
            int i = 0;
            while (i < rows.length) {
                int j = c0;
                while (j <= c1) {
                    B.set(i, j - c0, A.get(rows[i], j));
                    ++j;
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return B;
    }

    public final MatrixMxNf solve(MatrixMxNf B) {
        int j;
        int i;
        if (B.getNumRows() != this.m) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isNonsingular()) {
            throw new RuntimeException("Matrix is singular.");
        }
        int nx = B.getNumCols();
        MatrixMxNf X = LUDecomposition.copySubMatrix(B, this.piv, 0, nx - 1);
        int k = 0;
        while (k < this.n) {
            i = k + 1;
            while (i < this.n) {
                j = 0;
                while (j < nx) {
                    X.sub(i, j, X.get(k, j) * this.LU.get(i, k));
                    ++j;
                }
                ++i;
            }
            ++k;
        }
        k = this.n - 1;
        while (k >= 0) {
            int j2 = 0;
            while (j2 < nx) {
                X.div(k, j2, this.LU.get(k, k));
                ++j2;
            }
            i = 0;
            while (i < k) {
                j = 0;
                while (j < nx) {
                    X.sub(i, j, X.get(k, j) * this.LU.get(i, k));
                    ++j;
                }
                ++i;
            }
            --k;
        }
        return X;
    }
}

