/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.number;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimeFactorization {
    private static List<List<Integer>> precomutedFactorization = new ArrayList<List<Integer>>();

    static {
        precomutedFactorization.add(null);
        int i = 1;
        while (i < 1000) {
            precomutedFactorization.add(PrimeFactorization.getPrimeFactorization(i, new ArrayList<Integer>()));
            ++i;
        }
    }

    public static List<Integer> getPrimeFactorization(int integer, List<Integer> passback) {
        assert (integer > 0);
        if (integer == 1) {
            passback.add(1);
            return passback;
        }
        if (precomutedFactorization.size() < integer) {
            passback.addAll((Collection<Integer>)precomutedFactorization.get(integer));
            return passback;
        }
        PrimeFactorization.recursiveFactor(integer, passback);
        Collections.sort(passback);
        return passback;
    }

    private static void recursiveFactor(int integer, List<Integer> passback) {
        if (integer < precomutedFactorization.size()) {
            passback.addAll((Collection<Integer>)precomutedFactorization.get(integer));
            return;
        }
        int smallFactor = 1;
        int largeFactor = integer;
        int i = 2;
        while ((double)i <= Math.sqrt(integer)) {
            if (integer % i == 0) {
                smallFactor = i;
                largeFactor = integer / i;
            }
            ++i;
        }
        if (largeFactor == integer) {
            passback.add(largeFactor);
        } else {
            PrimeFactorization.recursiveFactor(largeFactor, passback);
            PrimeFactorization.recursiveFactor(smallFactor, passback);
        }
    }

    public static boolean isPrime(int number) {
        ArrayList<Integer> tmp = new ArrayList<Integer>();
        PrimeFactorization.getPrimeFactorization(number, tmp);
        return tmp.size() == 1;
    }

    public static void main(String[] args) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(2);
        list.add(2);
        list.add(3);
        ArrayList<Integer> tst = new ArrayList<Integer>();
        PrimeFactorization.getPrimeFactorization(12, tst);
        System.out.println("tst = " + tst);
        assert (tst.equals(list));
        int i = 1;
        while (i < 20) {
            if (PrimeFactorization.isPrime(i)) {
                System.out.println(String.valueOf(i) + " is prime");
            } else {
                System.out.println(String.valueOf(i) + " is not prime");
            }
            ++i;
        }
        i = 1;
        while (i < 20) {
            tst.clear();
            System.out.println(String.valueOf(i) + " = " + PrimeFactorization.getPrimeFactorization(i, tst));
            ++i;
        }
    }
}

