/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.number;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import org.openmali.number.Parser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rational
implements Comparable<Rational>,
Serializable {
    private static final long serialVersionUID = -9092546606834628521L;
    public static boolean AUTO_SIMPLIFY = true;
    public static int APPROXIMATION_THRESHOLD = (int)Math.floor(Math.sqrt(1.0737418235E9));
    private int whole;
    private int num;
    private int den;
    public static final Rational ZERO = new Rational(0, 0, 1);
    public static final Rational ONE = new Rational(1, 0, 1);
    private static final Rational tmp = new Rational(1, 0, 1);

    public final Rational set(int whole, int num, int den) {
        this.whole = whole;
        this.num = num;
        this.den = den;
        this.check();
        this.autoSimplify();
        return this;
    }

    public final void set(float value) {
        float denf = APPROXIMATION_THRESHOLD;
        this.num = (int)(value * denf);
        this.den = APPROXIMATION_THRESHOLD;
        this.check();
        this.autoSimplify();
    }

    public final void set(Rational radical) {
        this.num = radical.num;
        this.den = radical.den;
        this.whole = radical.whole;
    }

    public final void negate() {
        this.whole = -this.whole;
        this.num = -this.num;
    }

    public final float floatValue() {
        return (float)this.whole + (float)this.num / (float)this.den;
    }

    public final int getDenominator() {
        return this.den;
    }

    public final int getWhole() {
        return this.whole;
    }

    public final int getNumerator() {
        return this.num;
    }

    public void simplify() {
        int gcd = Rational.gcd(this.num, this.den);
        this.num /= gcd;
        this.den /= gcd;
        if (this.den < 0) {
            this.den = -this.den;
            this.num = -this.num;
        }
        if (this.whole > 0 && this.num < 0) {
            this.num = this.den + this.num;
            --this.whole;
        }
        if (this.whole < 0 && this.num > 0) {
            this.num = -(this.den - this.num);
            ++this.whole;
        }
        if (this.num > this.den) {
            this.whole += this.num / this.den;
            this.num %= this.den;
        }
        this.check();
    }

    private void autoSimplify() {
        if (AUTO_SIMPLIFY) {
            this.simplify();
        }
        if (this.den > APPROXIMATION_THRESHOLD) {
            System.err.print(this + " had to be simplified to ");
            this.simplify();
            this.approx();
            System.err.println(this + " consider using floating point instead");
        }
    }

    private void approx() {
        while (this.den > APPROXIMATION_THRESHOLD) {
            boolean bIsEven;
            int a = Math.abs(this.num);
            int b = this.den;
            boolean aIsEven = a % 2 == 0;
            boolean bl = bIsEven = b % 2 == 0;
            if (aIsEven ^ bIsEven) {
                boolean option1DamIsLessThanOption3;
                boolean bl2 = option1DamIsLessThanOption3 = 1 < a / (b + 1);
                if (option1DamIsLessThanOption3) {
                    ++this.num;
                } else {
                    --this.den;
                }
                float option1Dam = Math.abs(1.0f / (float)a);
                float option3Dam = Math.abs((float)a / ((float)b * ((float)b + 1.0f)));
                assert (option1DamIsLessThanOption3 == option1Dam < option3Dam);
            } else {
                ++this.den;
                ++this.num;
            }
            this.check();
            this.simplify();
        }
    }

    public static Rational add(Rational a, Rational b, Rational passback) {
        long al = a.num;
        long bl = a.den;
        long cl = b.num;
        long dl = b.den;
        assert (Math.abs(al) <= (long)APPROXIMATION_THRESHOLD);
        assert (Math.abs(bl) <= (long)APPROXIMATION_THRESHOLD);
        assert (Math.abs(cl) <= (long)APPROXIMATION_THRESHOLD);
        assert (Math.abs(dl) <= (long)APPROXIMATION_THRESHOLD);
        assert (Math.abs(al * dl) <= 0x3FFFFFFFL);
        assert (Math.abs(cl * bl) <= 0x3FFFFFFFL);
        assert (Math.abs(al * dl + cl * bl) <= Integer.MAX_VALUE);
        passback.num = a.num * b.den + b.num * a.den;
        passback.den = a.den * b.den;
        passback.whole = a.whole + b.whole;
        passback.check();
        passback.autoSimplify();
        return passback;
    }

    public static Rational sub(Rational a, Rational b, Rational passback) {
        passback.num = a.num * b.den - b.num * a.den;
        passback.den = a.den * b.den;
        passback.whole = a.whole - b.whole;
        passback.check();
        passback.autoSimplify();
        return passback;
    }

    private void check() {
        if (this.den < 0) {
            this.den = -this.den;
            this.num = -this.num;
        }
        if (Math.abs(this.num) >= this.den) {
            this.whole += this.num / this.den;
            this.num %= this.den;
        }
        assert (this.den > 0);
        assert (this.num < this.den);
    }

    public static Rational mul(Rational a, Rational b, Rational passback) {
        if (passback == a) {
            tmp.set(a);
            a = tmp;
        }
        if (passback == b) {
            tmp.set(b);
            b = tmp;
        }
        passback.num = a.num * b.num;
        passback.den = a.den * b.den;
        passback.whole = a.whole * b.whole;
        passback.check();
        passback.autoSimplify();
        Rational term = new Rational(a.whole * b.num, b.den);
        Rational.add(passback, term, passback);
        term.set(0, b.whole * a.num, a.den);
        Rational.add(passback, term, passback);
        return passback;
    }

    public static Rational div(Rational a, Rational b, Rational passback) {
        int n1 = a.whole * a.den + a.num;
        int n2 = b.den;
        int d1 = a.den;
        int d2 = b.whole * b.den + b.num;
        assert ((long)a.num + (long)a.whole * (long)a.den <= Integer.MAX_VALUE);
        assert ((long)b.num + (long)b.whole * (long)b.den <= Integer.MAX_VALUE);
        Rational bigNumbers = new Rational(n1, d2);
        Rational smallNumbersInv = new Rational(n2, d1);
        Rational.mul(bigNumbers, smallNumbersInv, passback);
        return passback;
    }

    public static int gcd(int a, int b) {
        while (b != 0) {
            int c = a % b;
            a = b;
            b = c;
        }
        return a;
    }

    public Rational clone() {
        return new Rational(this);
    }

    public String toString() {
        if (this.num == 0) {
            return String.valueOf(this.whole);
        }
        if (this.den == 1) {
            return String.valueOf(this.whole + this.num);
        }
        if (this.whole == 0) {
            return String.valueOf(this.num) + "/" + this.den;
        }
        return "(" + this.whole + (this.num > 0 ? "+" : "") + this.num + "/" + this.den + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rational rational = (Rational)o;
        if (this.den != rational.den) {
            return false;
        }
        if (this.num != rational.num) {
            return false;
        }
        return this.whole == rational.whole;
    }

    public int hashCode() {
        int result = this.whole;
        result = 31 * result + this.num;
        result = 31 * result + this.den;
        return result;
    }

    @Override
    public int compareTo(Rational o) {
        int b = this.den;
        long c = o.num + o.whole * o.den;
        long a = this.num + this.whole * this.den;
        int d = o.den;
        if ((long)b * c == a * (long)d) {
            return 0;
        }
        if (b * d > 0 && a * (long)d < (long)b * c || b * d < 0 && a * (long)d > (long)b * c) {
            return -1;
        }
        return 1;
    }

    public Rational(int num, int den) {
        this.set(0, num, den);
    }

    public Rational() {
        this.den = 1;
    }

    public Rational(int whole, int num, int den) {
        this.set(whole, num, den);
    }

    public Rational(float val) {
        this.set(val);
    }

    public Rational(int val) {
        this.den = 1;
        this.num = 0;
        this.whole = val;
    }

    public Rational(Rational val) {
        this.whole = val.whole;
        this.den = val.den;
        this.num = val.num;
    }

    public static Rational parseRational(String string) {
        try {
            StringReader in = new StringReader(string);
            Rational result = new Parser(in).rational();
            in.close();
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

