/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.spatial.octree;

import org.openmali.spatial.bounds.BoundingBox;
import org.openmali.spatial.bounds.BoundingSphere;
import org.openmali.spatial.bounds.Bounds;
import org.openmali.spatial.bounds.BoundsType;

class BoundsHelper {
    BoundsHelper() {
    }

    public static final float getMinX(Bounds bounds, BoundsType type) {
        if (type == BoundsType.AABB) {
            return ((BoundingBox)bounds).getLowerX();
        }
        if (type == BoundsType.SPHERE) {
            return ((BoundingSphere)bounds).getCenterX() - ((BoundingSphere)bounds).getRadius();
        }
        return 0.0f;
    }

    public static final float getMinY(Bounds bounds, BoundsType type) {
        if (type == BoundsType.AABB) {
            return ((BoundingBox)bounds).getLowerY();
        }
        if (type == BoundsType.SPHERE) {
            return ((BoundingSphere)bounds).getCenterY() - ((BoundingSphere)bounds).getRadius();
        }
        return 0.0f;
    }

    public static final float getMinZ(Bounds bounds, BoundsType type) {
        if (type == BoundsType.AABB) {
            return ((BoundingBox)bounds).getLowerZ();
        }
        if (type == BoundsType.SPHERE) {
            return ((BoundingSphere)bounds).getCenterZ() - ((BoundingSphere)bounds).getRadius();
        }
        return 0.0f;
    }

    public static final float getMaxX(Bounds bounds, BoundsType type) {
        if (type == BoundsType.AABB) {
            return ((BoundingBox)bounds).getUpperX();
        }
        if (type == BoundsType.SPHERE) {
            return ((BoundingSphere)bounds).getCenterX() + ((BoundingSphere)bounds).getRadius();
        }
        return 0.0f;
    }

    public static final float getMaxY(Bounds bounds, BoundsType type) {
        if (type == BoundsType.AABB) {
            return ((BoundingBox)bounds).getUpperY();
        }
        if (type == BoundsType.SPHERE) {
            return ((BoundingSphere)bounds).getCenterY() + ((BoundingSphere)bounds).getRadius();
        }
        return 0.0f;
    }

    public static final float getMaxZ(Bounds bounds, BoundsType type) {
        if (type == BoundsType.AABB) {
            return ((BoundingBox)bounds).getUpperZ();
        }
        if (type == BoundsType.SPHERE) {
            return ((BoundingSphere)bounds).getCenterZ() + ((BoundingSphere)bounds).getRadius();
        }
        return 0.0f;
    }
}

