/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.spatial.polygons;

public abstract class Polygon {
    private int features;
    private int texCoordsSize = 0;

    public void setFeatures(int features) {
        this.features = features;
    }

    public final int getFeatures() {
        return this.features;
    }

    public void addFeature(int feature) {
        this.features |= feature;
    }

    public void removeFeature(int feature) {
        this.features &= ~feature;
    }

    public boolean hasFeature(int feature) {
        return (this.features & feature) != 0;
    }

    public final void setTexCoordsSize(int size) {
        this.texCoordsSize = size;
    }

    public final int getTexCoordsSize() {
        return this.texCoordsSize;
    }

    public Polygon(int features, int texCoordsSize) {
        this.features = features;
        this.texCoordsSize = texCoordsSize;
    }
}

