/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.spatial.quadtree;

import java.io.PrintStream;
import org.openmali.spatial.AxisIndicator;
import org.openmali.spatial.PlaneIndicator;
import org.openmali.spatial.SpatialNode;
import org.openmali.spatial.bodies.Box;
import org.openmali.spatial.bounds.Bounds;
import org.openmali.spatial.bounds.BoundsType;
import org.openmali.spatial.quadtree.BoundsHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuadCell<T extends SpatialNode>
extends Box {
    private static final long serialVersionUID = 3514614577953214775L;
    private final PlaneIndicator plane;
    private final AxisIndicator upAxis;
    private final int level;
    private final float centerW;
    private final float centerD;
    private final float width;
    private final float depth;
    private final float height;
    private final float halfWidth;
    private final float halfDepth;
    private QuadCell<T> quFrontLeft = null;
    private QuadCell<T> quFrontRight = null;
    private QuadCell<T> quBackLeft = null;
    private QuadCell<T> quBackRight = null;
    private QuadCell<T> hLeft = null;
    private QuadCell<T> hRight = null;
    private QuadCell<T> hBack = null;
    private QuadCell<T> hFront = null;
    private final boolean useExtendedCells;
    private Object[] nodes = this.newTArray(8);
    private int numNodes = 0;
    private boolean hasChildCells = false;

    public final PlaneIndicator getPlane() {
        return this.plane;
    }

    public final AxisIndicator getUpAxis() {
        return this.upAxis;
    }

    private final Object[] newTArray(int length) {
        return new Object[length];
    }

    public final boolean usesExtendedCells() {
        return this.useExtendedCells;
    }

    public final int getLevel() {
        return this.level;
    }

    public final float getWidth() {
        return this.width;
    }

    public final float getDepth() {
        return this.depth;
    }

    public final float getHeight() {
        return this.height;
    }

    public final float getHalfWidth() {
        return this.halfWidth;
    }

    public final float getHalfDepth() {
        return this.halfDepth;
    }

    public final QuadCell<T> getCellQuFrontLeft() {
        return this.quFrontLeft;
    }

    public final QuadCell<T> getCellQuFrontRight() {
        return this.quFrontRight;
    }

    public final QuadCell<T> getCellQuBackLeft() {
        return this.quBackLeft;
    }

    public final QuadCell<T> getCellQuBackRight() {
        return this.quBackRight;
    }

    public final int getNumNodes() {
        return this.numNodes;
    }

    public final QuadCell<T> getCellHLeft() {
        return this.hLeft;
    }

    public final QuadCell<T> getCellHRight() {
        return this.hRight;
    }

    public final QuadCell<T> getCellHBack() {
        return this.hBack;
    }

    public final QuadCell<T> getCellHFront() {
        return this.hFront;
    }

    public final T getNode(int index) {
        return (T)((SpatialNode)this.nodes[index]);
    }

    public final boolean hasChildCells() {
        return this.hasChildCells;
    }

    private void reinsertNodes(int minNodesBeforeSplit, int maxLevelForExtendedCells) {
        int pushedNodes = 0;
        int i = 0;
        while (i < this.getNumNodes()) {
            QuadCell<T> cell = this.findChildCell(this.getNode(i).getWorldBounds(), this.getNode(i).getWorldBounds().getType(), minNodesBeforeSplit, maxLevelForExtendedCells, true);
            if (cell != this) {
                super.insertNode_(this.getNode(i));
                this.nodes[i] = null;
                ++pushedNodes;
            }
            ++i;
        }
        if (pushedNodes > 0) {
            Object[] temp = this.newTArray(this.getNumNodes() - pushedNodes);
            int j = 0;
            int i2 = 0;
            while (i2 < this.getNumNodes()) {
                if (this.getNode(i2) != null) {
                    temp[j++] = this.getNode(i2);
                }
                ++i2;
            }
            this.nodes = temp;
            this.numNodes -= pushedNodes;
        }
    }

    private QuadCell<T> createFrontLeftQuadrant(int maxLevelForExtendedCells) {
        float childCenterX = this.plane == PlaneIndicator.X_Z_PLANE || this.plane == PlaneIndicator.X_Y_PLANE ? this.centerX - this.width / 4.0f : this.centerX;
        float childCenterY = this.plane == PlaneIndicator.X_Z_PLANE ? this.centerY : this.centerY - this.depth / 4.0f;
        float childCenterZ = this.plane == PlaneIndicator.X_Z_PLANE ? this.centerZ + this.depth / 4.0f : (this.plane == PlaneIndicator.X_Y_PLANE ? this.centerZ : this.centerZ - this.width / 4.0f);
        return new QuadCell<T>(this.getLevel() + 1, childCenterX, childCenterY, childCenterZ, this.plane, this.halfWidth, this.halfDepth, this.height, this.useExtendedCells && this.level < maxLevelForExtendedCells);
    }

    private QuadCell<T> createFrontRightQuadrant(int maxLevelForExtendedCells) {
        float childCenterX = this.plane == PlaneIndicator.X_Z_PLANE || this.plane == PlaneIndicator.X_Y_PLANE ? this.centerX + this.width / 4.0f : this.centerX;
        float childCenterY = this.plane == PlaneIndicator.X_Z_PLANE ? this.centerY : this.centerY - this.depth / 4.0f;
        float childCenterZ = this.plane == PlaneIndicator.X_Z_PLANE ? this.centerZ + this.depth / 4.0f : (this.plane == PlaneIndicator.X_Y_PLANE ? this.centerZ : this.centerZ + this.width / 4.0f);
        return new QuadCell<T>(this.getLevel() + 1, childCenterX, childCenterY, childCenterZ, this.plane, this.halfWidth, this.halfDepth, this.height, this.useExtendedCells && this.level < maxLevelForExtendedCells);
    }

    private QuadCell<T> createBackLeftQuadrant(int maxLevelForExtendedCells) {
        float childCenterX = this.plane == PlaneIndicator.X_Z_PLANE || this.plane == PlaneIndicator.X_Y_PLANE ? this.centerX - this.width / 4.0f : this.centerX;
        float childCenterY = this.plane == PlaneIndicator.X_Z_PLANE ? this.centerY : this.centerY + this.depth / 4.0f;
        float childCenterZ = this.plane == PlaneIndicator.X_Z_PLANE ? this.centerZ - this.depth / 4.0f : (this.plane == PlaneIndicator.X_Y_PLANE ? this.centerZ : this.centerZ - this.width / 4.0f);
        return new QuadCell<T>(this.getLevel() + 1, childCenterX, childCenterY, childCenterZ, this.plane, this.halfWidth, this.halfDepth, this.height, this.useExtendedCells && this.level < maxLevelForExtendedCells);
    }

    private QuadCell<T> createBackRightQuadrant(int maxLevelForExtendedCells) {
        float childCenterX = this.plane == PlaneIndicator.X_Z_PLANE || this.plane == PlaneIndicator.X_Y_PLANE ? this.centerX + this.width / 4.0f : this.centerX;
        float childCenterY = this.plane == PlaneIndicator.X_Z_PLANE ? this.centerY : this.centerY + this.depth / 4.0f;
        float childCenterZ = this.plane == PlaneIndicator.X_Z_PLANE ? this.centerZ - this.depth / 4.0f : (this.plane == PlaneIndicator.X_Y_PLANE ? this.centerZ : this.centerZ + this.width / 4.0f);
        return new QuadCell<T>(this.getLevel() + 1, childCenterX, childCenterY, childCenterZ, this.plane, this.halfWidth, this.halfDepth, this.height, this.useExtendedCells && this.level < maxLevelForExtendedCells);
    }

    private QuadCell<T> createLeftHalf() {
        float childCenterX = this.plane == PlaneIndicator.X_Z_PLANE || this.plane == PlaneIndicator.X_Y_PLANE ? this.centerX - this.width / 4.0f : this.centerX;
        float childCenterY = this.centerY;
        float childCenterZ = this.plane == PlaneIndicator.X_Z_PLANE || this.plane == PlaneIndicator.X_Y_PLANE ? this.centerZ : this.centerZ - this.width / 4.0f;
        return new QuadCell<T>(this.getLevel() + 1, childCenterX, childCenterY, childCenterZ, this.plane, this.halfWidth, this.depth, this.height, false);
    }

    private QuadCell<T> createRightHalf() {
        float childCenterX = this.plane == PlaneIndicator.X_Z_PLANE || this.plane == PlaneIndicator.X_Y_PLANE ? this.centerX + this.width / 4.0f : this.centerX;
        float childCenterY = this.centerY;
        float childCenterZ = this.plane == PlaneIndicator.X_Z_PLANE || this.plane == PlaneIndicator.X_Y_PLANE ? this.centerZ : this.centerZ + this.width / 4.0f;
        return new QuadCell<T>(this.getLevel() + 1, childCenterX, childCenterY, childCenterZ, this.plane, this.halfWidth, this.depth, this.height, false);
    }

    private QuadCell<T> createFrontHalf() {
        float childCenterX = this.centerX;
        float childCenterY = this.plane == PlaneIndicator.X_Z_PLANE ? this.centerY : this.centerY - this.depth / 4.0f;
        float childCenterZ = this.plane == PlaneIndicator.X_Z_PLANE ? this.centerZ + this.depth / 4.0f : this.centerZ;
        return new QuadCell<T>(this.getLevel() + 1, childCenterX, childCenterY, childCenterZ, this.plane, this.width, this.halfDepth, this.height, false);
    }

    private QuadCell<T> createBackHalf() {
        float childCenterX = this.centerX;
        float childCenterY = this.plane == PlaneIndicator.X_Z_PLANE ? this.centerY : this.centerY + this.depth / 4.0f;
        float childCenterZ = this.plane == PlaneIndicator.X_Z_PLANE ? this.centerZ - this.depth / 4.0f : this.centerZ;
        return new QuadCell<T>(this.getLevel() + 1, childCenterX, childCenterY, childCenterZ, this.plane, this.width, this.halfDepth, this.height, false);
    }

    protected QuadCell<T> findChildCell(Bounds bounds, BoundsType type, int minNodesBeforeSplit, int maxLevelForExtendedCells, boolean ignoreReinserting) {
        if (!ignoreReinserting) {
            if (this.getNumNodes() < minNodesBeforeSplit) {
                return this;
            }
            if (this.getNumNodes() == minNodesBeforeSplit) {
                this.reinsertNodes(minNodesBeforeSplit, maxLevelForExtendedCells);
            }
        }
        if (BoundsHelper.getMaxX(this.plane, bounds, type) <= this.centerW) {
            if (BoundsHelper.getMinDepth(this.plane, bounds, type) >= this.centerD) {
                if (this.quFrontLeft == null) {
                    this.quFrontLeft = this.createFrontLeftQuadrant(maxLevelForExtendedCells);
                    this.hasChildCells = true;
                }
                return this.quFrontLeft.findChildCell(bounds, minNodesBeforeSplit, maxLevelForExtendedCells);
            }
            if (BoundsHelper.getMaxDepth(this.plane, bounds, type) <= this.centerD) {
                if (this.quBackLeft == null) {
                    this.quBackLeft = this.createBackLeftQuadrant(maxLevelForExtendedCells);
                    this.hasChildCells = true;
                }
                return this.quBackLeft.findChildCell(bounds, minNodesBeforeSplit, maxLevelForExtendedCells);
            }
            if (this.useExtendedCells) {
                if (this.hLeft == null) {
                    this.hLeft = this.createLeftHalf();
                    this.hasChildCells = true;
                }
                return this.hLeft;
            }
            return this;
        }
        if (BoundsHelper.getMinX(this.plane, bounds, type) >= this.centerW) {
            if (BoundsHelper.getMinDepth(this.plane, bounds, type) >= this.centerD) {
                if (this.quFrontRight == null) {
                    this.quFrontRight = this.createFrontRightQuadrant(maxLevelForExtendedCells);
                    this.hasChildCells = true;
                }
                return this.quFrontRight.findChildCell(bounds, minNodesBeforeSplit, maxLevelForExtendedCells);
            }
            if (BoundsHelper.getMaxDepth(this.plane, bounds, type) <= this.centerD) {
                if (this.quBackRight == null) {
                    this.quBackRight = this.createBackRightQuadrant(maxLevelForExtendedCells);
                    this.hasChildCells = true;
                }
                return this.quBackRight.findChildCell(bounds, minNodesBeforeSplit, maxLevelForExtendedCells);
            }
            if (this.useExtendedCells) {
                if (this.hRight == null) {
                    this.hRight = this.createRightHalf();
                    this.hasChildCells = true;
                }
                return this.hRight;
            }
            return this;
        }
        if (this.useExtendedCells) {
            if (BoundsHelper.getMinDepth(this.plane, bounds, type) >= this.centerD) {
                if (this.hFront == null) {
                    this.hFront = this.createFrontHalf();
                    this.hasChildCells = true;
                }
                return this.hFront;
            }
            if (BoundsHelper.getMaxDepth(this.plane, bounds, type) <= this.centerD) {
                if (this.hBack == null) {
                    this.hBack = this.createBackHalf();
                    this.hasChildCells = true;
                }
                return this.hBack;
            }
        }
        return this;
    }

    protected QuadCell<T> findChildCell(Bounds bounds, int minNodesBeforeSplit, int maxLevelForExtendedCells) {
        return this.findChildCell(bounds, bounds.getType(), minNodesBeforeSplit, maxLevelForExtendedCells, false);
    }

    protected QuadCell<T> findChildCell(T node, int minNodesBeforeSplit, int maxLevelForExtendedCells) {
        return this.findChildCell((T)node.getWorldBounds(), minNodesBeforeSplit, maxLevelForExtendedCells);
    }

    private final void insertNode_(T node) {
        double growFactor = 1.0;
        if (this.numNodes == this.nodes.length) {
            Object[] nodes2 = this.newTArray((int)((double)(this.numNodes + 1) * 1.0));
            System.arraycopy(this.nodes, 0, nodes2, 0, this.numNodes);
            this.nodes = nodes2;
        }
        this.nodes[this.numNodes++] = node;
        node.setTreeCell(this);
    }

    public int insertNode(T node, int minNodesBeforeSplit, int maxLevelForExtendedCells) {
        QuadCell<T> cell = this.findChildCell(node, minNodesBeforeSplit, maxLevelForExtendedCells);
        super.insertNode_(node);
        return cell.getLevel();
    }

    private final void removeNode_(T node) {
        int index = -1;
        int i = 0;
        while (i < this.numNodes) {
            if (this.nodes[i] == node) {
                index = i;
                break;
            }
            ++i;
        }
        System.arraycopy(this.nodes, index + 1, this.nodes, index, this.numNodes - index - 1);
        --this.numNodes;
        node.setTreeCell(null);
    }

    public boolean removeNode(T node) {
        Object treeCellObj = node.getTreeCell();
        if (treeCellObj == null) {
            return false;
        }
        QuadCell treeCell = (QuadCell)treeCellObj;
        treeCell.removeNode_(node);
        return true;
    }

    public void clear() {
        int i = 0;
        while (i < this.nodes.length) {
            this.nodes[i] = null;
            ++i;
        }
        this.numNodes = 0;
        this.quBackLeft = null;
        this.quBackRight = null;
        this.quFrontLeft = null;
        this.quFrontRight = null;
        this.hLeft = null;
        this.hRight = null;
        this.hBack = null;
        this.hFront = null;
    }

    private static final void printIndentation(int indentation, PrintStream ps) {
        int i = 0;
        while (i < indentation) {
            ps.print("  ");
            ++i;
        }
    }

    private void dumpCellSize(PrintStream ps) {
        if (this.width == this.depth) {
            ps.print(this.width);
        } else {
            ps.print(String.valueOf(this.width) + ", " + this.depth);
        }
        ps.print(", (" + this.height + ")");
    }

    void dump(String cellName, int indentation, PrintStream ps) {
        QuadCell.printIndentation(indentation, ps);
        ps.print(String.valueOf(this.getClass().getSimpleName()) + " \"" + cellName + "\" ( level: " + this.getLevel() + ", center: [ " + this.centerX + ", " + this.centerY + ", " + this.centerZ + "], size: ");
        this.dumpCellSize(ps);
        ps.println(" )");
        QuadCell.printIndentation(indentation, ps);
        ps.println("{");
        QuadCell.printIndentation(indentation + 1, ps);
        if (this.numNodes == 0) {
            ps.println("Nodes:");
            QuadCell.printIndentation(indentation + 1, ps);
            ps.println("[No nodes]");
        } else {
            ps.println("Nodes (" + this.numNodes + "):");
            int i = 0;
            while (i < this.numNodes) {
                QuadCell.printIndentation(indentation + 1, ps);
                ps.println(this.nodes[i] + ", " + ((SpatialNode)this.nodes[i]).getWorldBounds());
                ++i;
            }
        }
        if (this.hasChildCells()) {
            QuadCell.printIndentation(indentation + 1, ps);
            ps.println("");
            QuadCell.dump(this.hLeft, "hLeft", indentation + 1, ps);
            QuadCell.dump(this.hRight, "hRight", indentation + 1, ps);
            QuadCell.dump(this.hBack, "hBack", indentation + 1, ps);
            QuadCell.dump(this.hFront, "hFront", indentation + 1, ps);
            QuadCell.dump(this.quBackLeft, "quBackLeft", indentation + 1, ps);
            QuadCell.dump(this.quBackRight, "quBackRight", indentation + 1, ps);
            QuadCell.dump(this.quFrontLeft, "quFrontLeft", indentation + 1, ps);
            QuadCell.dump(this.quFrontRight, "quFrontRight", indentation + 1, ps);
        }
        QuadCell.printIndentation(indentation, ps);
        ps.println("}");
    }

    static final void dump(QuadCell<?> cell, String cellName, int indentation, PrintStream ps) {
        if (cell == null) {
            return;
        }
        cell.dump(cellName, indentation, ps);
    }

    public void dump() {
        QuadCell.dump(this, "root", 0, System.out);
    }

    private static final float getLowerX(float centerX, PlaneIndicator plane, float width, float height) {
        switch (plane) {
            case X_Y_PLANE: 
            case X_Z_PLANE: {
                return centerX - width / 2.0f;
            }
            case Z_Y_PLANE: {
                return centerX - height / 2.0f;
            }
        }
        throw new Error("Should not happen!");
    }

    private static final float getLowerY(float centerY, PlaneIndicator plane, float depth, float height) {
        switch (plane) {
            case X_Z_PLANE: {
                return centerY - height / 2.0f;
            }
            case X_Y_PLANE: 
            case Z_Y_PLANE: {
                return centerY - depth / 2.0f;
            }
        }
        throw new Error("Should not happen!");
    }

    private static final float getLowerZ(float centerZ, PlaneIndicator plane, float width, float depth, float height) {
        switch (plane) {
            case X_Z_PLANE: {
                return centerZ - depth / 2.0f;
            }
            case X_Y_PLANE: {
                return centerZ - height / 2.0f;
            }
            case Z_Y_PLANE: {
                return centerZ - width / 2.0f;
            }
        }
        throw new Error("Should not happen!");
    }

    private static final float getUpperX(float centerX, PlaneIndicator plane, float width, float height) {
        switch (plane) {
            case X_Y_PLANE: 
            case X_Z_PLANE: {
                return centerX + width / 2.0f;
            }
            case Z_Y_PLANE: {
                return centerX + height / 2.0f;
            }
        }
        throw new Error("Should not happen!");
    }

    private static final float getUpperY(float centerY, PlaneIndicator plane, float depth, float height) {
        switch (plane) {
            case X_Z_PLANE: {
                return centerY + height / 2.0f;
            }
            case X_Y_PLANE: 
            case Z_Y_PLANE: {
                return centerY + depth / 2.0f;
            }
        }
        throw new Error("Should not happen!");
    }

    private static final float getUpperZ(float centerZ, PlaneIndicator plane, float width, float depth, float height) {
        switch (plane) {
            case X_Z_PLANE: {
                return centerZ + depth / 2.0f;
            }
            case X_Y_PLANE: {
                return centerZ + height / 2.0f;
            }
            case Z_Y_PLANE: {
                return centerZ + width / 2.0f;
            }
        }
        throw new Error("Should not happen!");
    }

    protected QuadCell(int level, float centerX, float centerY, float centerZ, PlaneIndicator plane, float width, float depth, float height, boolean useExtendedCells) {
        super(QuadCell.getLowerX(centerX, plane, width, height), QuadCell.getLowerY(centerY, plane, depth, height), QuadCell.getLowerZ(centerZ, plane, width, depth, height), QuadCell.getUpperX(centerX, plane, width, height), QuadCell.getUpperY(centerY, plane, depth, height), QuadCell.getUpperZ(centerZ, plane, width, depth, height));
        this.level = level;
        this.centerX = centerX;
        this.centerY = centerY;
        this.centerZ = centerZ;
        this.plane = plane;
        this.upAxis = plane.getNormalAxis();
        if (plane == PlaneIndicator.X_Z_PLANE || plane == PlaneIndicator.X_Y_PLANE) {
            this.centerW = centerX;
        } else if (plane == PlaneIndicator.Z_Y_PLANE) {
            this.centerW = centerZ;
        } else {
            throw new Error("Should not happen!");
        }
        if (plane == PlaneIndicator.X_Z_PLANE) {
            this.centerD = centerZ;
        } else if (plane == PlaneIndicator.X_Y_PLANE || plane == PlaneIndicator.Z_Y_PLANE) {
            this.centerD = centerY;
        } else {
            throw new Error("Should not happen!");
        }
        this.width = width;
        this.depth = depth;
        this.height = height;
        this.halfWidth = width / 2.0f;
        this.halfDepth = depth / 2.0f;
        this.useExtendedCells = useExtendedCells;
        this.nodes = new Object[4];
    }

    public QuadCell(int level, float centerX, float centerY, float centerZ, PlaneIndicator plane, float width, float depth, float height) {
        this(level, centerX, centerY, centerZ, plane, width, depth, height, true);
    }

    public QuadCell(int level, float centerX, float centerY, float centerZ, PlaneIndicator plane, float size, float height, boolean useExtendedCells) {
        this(level, centerX, centerY, centerZ, plane, size, size, height, useExtendedCells);
    }

    public QuadCell(int level, float centerX, float centerY, float centerZ, PlaneIndicator plane, float size, float height) {
        this(level, centerX, centerY, centerZ, plane, size, size, height, false);
    }
}

