/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.types.primitives;

import sun.misc.FloatingDecimal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutableFloat
extends Number
implements Comparable<MutableFloat> {
    private static final long serialVersionUID = -1901001518826913935L;
    private float value;

    public final void setValue(float value) {
        this.value = value;
    }

    public final boolean isNaN() {
        return Float.isNaN(this.value);
    }

    public final boolean isInfinite() {
        return Float.isInfinite(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public final byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public final short shortValue() {
        return (short)this.value;
    }

    @Override
    public final int intValue() {
        return (int)this.value;
    }

    @Override
    public final long longValue() {
        return (long)this.value;
    }

    @Override
    public final float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.value);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MutableFloat && Float.floatToIntBits(((MutableFloat)obj).value) == Float.floatToIntBits(this.value)) {
            return true;
        }
        return obj instanceof Float && Float.floatToIntBits(((Float)obj).floatValue()) == Float.floatToIntBits(this.value);
    }

    @Override
    public int compareTo(MutableFloat anotherFloat) {
        return Float.compare(this.value, anotherFloat.value);
    }

    public MutableFloat(float value) {
        this.value = value;
    }

    public MutableFloat(double value) {
        this.value = (float)value;
    }

    public MutableFloat(String s) throws NumberFormatException {
        this(MutableFloat.valueOf(s).floatValue());
    }

    public static MutableFloat valueOf(String s) throws NumberFormatException {
        return new MutableFloat(FloatingDecimal.readJavaFormatString((String)s).floatValue());
    }

    public static MutableFloat valueOf(float f) {
        return new MutableFloat(f);
    }
}

