/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.types.primitives;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutableLong
extends Number
implements Comparable<MutableLong> {
    private static final long serialVersionUID = -9049404274126384264L;
    private long value;

    public final void setValue(long value) {
        this.value = value;
    }

    @Override
    public final byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public final short shortValue() {
        return (short)this.value;
    }

    @Override
    public final int intValue() {
        return (int)this.value;
    }

    @Override
    public final long longValue() {
        return this.value;
    }

    @Override
    public final float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MutableLong) {
            return this.value == ((MutableLong)obj).longValue();
        }
        if (obj instanceof Long) {
            return this.value == (Long)obj;
        }
        return false;
    }

    @Override
    public int compareTo(MutableLong anotherLong) {
        long thisVal = this.value;
        long anotherVal = anotherLong.value;
        return thisVal < anotherVal ? -1 : (thisVal == anotherVal ? 0 : 1);
    }

    public MutableLong(long value) {
        this.value = value;
    }

    public MutableLong(String s) throws NumberFormatException {
        this.value = Long.parseLong(s, 10);
    }

    public static MutableLong valueOf(String s, int radix) throws NumberFormatException {
        return new MutableLong(Long.parseLong(s, radix));
    }

    public static MutableLong valueOf(String s) throws NumberFormatException {
        return new MutableLong(Long.parseLong(s, 10));
    }

    public static MutableLong valueOf(long l) {
        return new MutableLong(l);
    }
}

