/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.types.twodee;

import java.util.ArrayList;
import org.openmali.types.twodee.ExtPositioned2i;
import org.openmali.types.twodee.ExtSized2i;
import org.openmali.types.twodee.Rect2i;
import org.openmali.types.twodee.util.RepositionListener2i;
import org.openmali.types.twodee.util.ResizeListener2i;

public class ExtRect2i
extends Rect2i
implements ExtPositioned2i,
ExtSized2i {
    private final ArrayList<RepositionListener2i> repositionListeners = new ArrayList();
    private final ArrayList<ResizeListener2i> resizeListeners = new ArrayList();

    public void addRepositionListener(RepositionListener2i listener) {
        this.repositionListeners.add(listener);
    }

    public void removeRepositionListener(RepositionListener2i listener) {
        this.repositionListeners.remove(listener);
    }

    protected void fireRepositionEvent(int oldLeft, int oldTop, int newLeft, int newTop) {
        int i = 0;
        while (i < this.repositionListeners.size()) {
            this.repositionListeners.get(i).onObjectRepositioned(this, oldLeft, oldTop, newLeft, newTop);
            ++i;
        }
    }

    public void addResizeListener(ResizeListener2i listener) {
        this.resizeListeners.add(listener);
    }

    public void removeResizeListener(ResizeListener2i listener) {
        this.resizeListeners.remove(listener);
    }

    protected void fireResizeEvent(int oldWidth, int oldHeight, int newWidth, int newHeight) {
        int i = 0;
        while (i < this.resizeListeners.size()) {
            this.resizeListeners.get(i).onObjectResized(this, oldWidth, oldHeight, newWidth, newHeight);
            ++i;
        }
    }

    public ExtRect2i setLocation(int left, int top) {
        int oldLeft = this.getLeft();
        int oldTop = this.getTop();
        if (oldLeft != left || oldTop != top) {
            super.setLocation(left, top);
            this.fireRepositionEvent(oldLeft, oldTop, left, top);
        }
        return this;
    }

    public ExtRect2i setSize(int width, int height) {
        int oldWidth = this.getWidth();
        int oldHeight = this.getHeight();
        if (oldWidth != width || oldHeight != height) {
            super.setSize(width, height);
            this.fireResizeEvent(oldWidth, oldHeight, width, height);
        }
        return this;
    }

    public ExtRect2i(int left, int top, int width, int height) {
        super(left, top, width, height);
    }

    public ExtRect2i(ExtRect2i template) {
        this(template.getLeft(), template.getTop(), template.getWidth(), template.getHeight());
    }

    public ExtRect2i() {
        this(0, 0, 0, 0);
    }
}

