/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.vecmath2;

import java.awt.Color;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.DoubleBuffer;
import org.openmali.vecmath2.pools.ColordPool;
import org.openmali.vecmath2.util.ColorUtils;
import org.openmali.vecmath2.util.SerializationUtils;

public class Colord
implements Externalizable {
    private static final long serialVersionUID = -818575512943622856L;
    private static final ThreadLocal<ColordPool> POOL = new ThreadLocal<ColordPool>(){

        @Override
        protected ColordPool initialValue() {
            return new ColordPool(128);
        }
    };
    protected static final int N = 4;
    protected final double[] values;
    protected boolean hasAlpha;
    protected final int roTrick;
    protected final boolean[] isDirty;
    private Colord readOnlyInstance = null;
    public static final Colord WHITE = new Colord(true, Color.WHITE);
    public static final Colord LIGHT_GRAY = new Colord(true, Color.GRAY);
    public static final Colord GRAY10 = new Colord(true, 0.9);
    public static final Colord GRAY20 = new Colord(true, 0.8);
    public static final Colord GRAY25 = new Colord(true, 0.75);
    public static final Colord GRAY30 = new Colord(true, 0.7);
    public static final Colord GRAY40 = new Colord(true, 0.6);
    public static final Colord GRAY50 = new Colord(true, 0.5);
    public static final Colord GRAY60 = new Colord(true, 0.4);
    public static final Colord GRAY70 = new Colord(true, 0.3);
    public static final Colord GRAY75 = new Colord(true, 0.25);
    public static final Colord GRAY80 = new Colord(true, 0.2);
    public static final Colord GRAY90 = new Colord(true, 0.1);
    public static final Colord GRAY = new Colord(true, Color.GRAY);
    public static final Colord DARK_GRAY = new Colord(true, Color.DARK_GRAY);
    public static final Colord BLACK = new Colord(true, Color.BLACK);
    public static final Colord BROWN = Colord.parseReadOnlyColor("#6D493B");
    public static final Colord LIGHT_BROWN = Colord.parseReadOnlyColor("#91624F");
    public static final Colord DARK_BROWN = Colord.parseReadOnlyColor("#583B30");
    public static final Colord RED = new Colord(true, Color.RED);
    public static final Colord PINK = new Colord(true, Color.PINK);
    public static final Colord ORANGE = new Colord(true, Color.ORANGE);
    public static final Colord YELLOW = new Colord(true, Color.YELLOW);
    public static final Colord GREEN = new Colord(true, Color.GREEN);
    public static final Colord MAGENTA = new Colord(true, Color.MAGENTA);
    public static final Colord CYAN = new Colord(true, Color.CYAN);
    public static final Colord BLUE = new Colord(true, Color.BLUE);

    public final boolean isReadOnly() {
        return this.roTrick != 0;
    }

    public final boolean setClean() {
        if (this.isReadOnly()) {
            throw new Error("This instance is read-only.");
        }
        boolean oldValue = this.isDirty[0];
        this.isDirty[0] = false;
        return oldValue;
    }

    public final boolean isDirty() {
        return this.isDirty[0];
    }

    public static Colord createGray(double intensity) {
        return new Colord(intensity, intensity, intensity);
    }

    public final int getSize() {
        return 4;
    }

    public final boolean hasAlpha() {
        return this.hasAlpha;
    }

    public final void set(Color color) {
        this.setRed((double)color.getRed() / 255.0);
        this.setGreen((double)color.getGreen() / 255.0);
        this.setBlue((double)color.getBlue() / 255.0);
        boolean bl = this.hasAlpha = color.getAlpha() < 255;
        if (this.hasAlpha) {
            this.setAlpha((double)(255 - color.getAlpha()) / 255.0);
        }
        this.isDirty[0] = true;
    }

    public final void set(double[] values) {
        if (values.length > 3) {
            System.arraycopy(values, 0, this.values, this.roTrick + 0, 4);
            this.hasAlpha = values[3] > 0.0;
        } else {
            System.arraycopy(values, 0, this.values, this.roTrick + 0, 3);
            this.hasAlpha = false;
        }
        this.isDirty[0] = true;
    }

    public final void setBytes(byte[] values) {
        if (values.length > 3) {
            this.setRedByte(values[0]);
            this.setGreenByte(values[1]);
            this.setBlueByte(values[2]);
            this.setAlphaByte(values[3]);
        } else {
            this.setRedByte(values[0]);
            this.setGreenByte(values[1]);
            this.setBlueByte(values[2]);
            this.hasAlpha = false;
        }
        this.isDirty[0] = true;
    }

    public final void setInts(int[] values) {
        if (values.length > 3) {
            this.setRedInt(values[0]);
            this.setGreenInt(values[1]);
            this.setBlueInt(values[2]);
            this.setAlphaInt(values[3]);
        } else {
            this.setRedInt(values[0]);
            this.setGreenInt(values[1]);
            this.setBlueInt(values[2]);
            this.hasAlpha = false;
        }
        this.isDirty[0] = true;
    }

    public final void set(Colord color) {
        System.arraycopy(color.values, 0, this.values, this.roTrick + 0, 4);
        this.hasAlpha = color.hasAlpha;
        this.isDirty[0] = true;
    }

    public final void set(double r, double g, double b, double a) {
        this.setRed(r);
        this.setGreen(g);
        this.setBlue(b);
        this.setAlpha(a);
        this.hasAlpha = a >= 0.0;
        this.isDirty[0] = true;
    }

    public final void set(double r, double g, double b) {
        this.setRed(r);
        this.setGreen(g);
        this.setBlue(b);
        this.hasAlpha = false;
        this.isDirty[0] = true;
    }

    public final Color getAWTColor() {
        if (this.hasAlpha()) {
            return new Color((float)this.getRed(), (float)this.getGreen(), (float)this.getBlue(), (float)(1.0 - this.getAlpha()));
        }
        return new Color((float)this.getRed(), (float)this.getGreen(), (float)this.getBlue());
    }

    public final void get(double[] buffer) {
        int n = this.hasAlpha() ? 4 : 3;
        System.arraycopy(this.values, 0, buffer, 0, n);
    }

    public final void getBytes(byte[] buffer) {
        buffer[0] = this.getRedByte();
        buffer[1] = this.getGreenByte();
        buffer[2] = this.getBlueByte();
        if (this.hasAlpha() && buffer.length >= 4) {
            buffer[3] = this.getAlphaByte();
        }
    }

    public final void getInts(int[] buffer) {
        buffer[0] = this.getRedInt();
        buffer[1] = this.getGreenInt();
        buffer[2] = this.getBlueInt();
        if (this.hasAlpha() && buffer.length >= 4) {
            buffer[3] = this.getAlphaInt();
        }
    }

    public final void get(Colord buffer) {
        System.arraycopy(this.values, 0, buffer.values, 0, 4);
        buffer.hasAlpha = this.hasAlpha;
    }

    public final DoubleBuffer writeToBuffer(DoubleBuffer buffer, boolean forceAlpha) {
        buffer.clear();
        if (this.hasAlpha()) {
            buffer.put(this.values);
        } else if (forceAlpha) {
            buffer.put(this.values[0]).put(this.values[1]).put(this.values[2]).put(0.0);
        } else {
            buffer.put(this.values[0]).put(this.values[1]).put(this.values[2]);
        }
        buffer.flip();
        return buffer;
    }

    public final DoubleBuffer writeToBuffer(DoubleBuffer buffer) {
        return this.writeToBuffer(buffer, false);
    }

    public static final DoubleBuffer writeToBuffer(Colord[] colors, DoubleBuffer buffer, boolean forceAlpha) {
        buffer.clear();
        int i = 0;
        while (i < colors.length) {
            Colord color = colors[i];
            if (color.hasAlpha()) {
                buffer.put(color.values);
            } else if (forceAlpha) {
                buffer.put(color.values[0]).put(color.values[1]).put(color.values[2]).put(0.0);
            } else {
                buffer.put(color.values[0]).put(color.values[1]).put(color.values[2]);
            }
            ++i;
        }
        buffer.flip();
        return buffer;
    }

    public static final DoubleBuffer writeToBuffer(Colord[] colors, DoubleBuffer buffer) {
        return Colord.writeToBuffer(colors, buffer, false);
    }

    public final void setRed(double red) {
        this.values[this.roTrick + 0] = red;
        this.isDirty[0] = true;
    }

    public final double getRed() {
        return this.values[0];
    }

    public final void r(double red) {
        this.values[this.roTrick + 0] = red;
        this.isDirty[0] = true;
    }

    public final double r() {
        return this.values[0];
    }

    public final void setRedByte(byte red) {
        this.values[this.roTrick + 0] = (double)(red & 0xFF) / 255.0;
        this.isDirty[0] = true;
    }

    public final byte getRedByte() {
        return (byte)(this.values[0] * 255.0);
    }

    public final void setRedInt(int red) {
        this.values[this.roTrick + 0] = (double)red / 255.0;
        this.isDirty[0] = true;
    }

    public final int getRedInt() {
        return (int)(this.values[0] * 255.0);
    }

    public final void setGreen(double green) {
        this.values[this.roTrick + 1] = green;
        this.isDirty[0] = true;
    }

    public final double getGreen() {
        return this.values[1];
    }

    public final void g(double green) {
        this.values[this.roTrick + 1] = green;
        this.isDirty[0] = true;
    }

    public final double g() {
        return this.values[1];
    }

    public final void setGreenByte(byte green) {
        this.values[this.roTrick + 1] = (double)(green & 0xFF) / 255.0;
        this.isDirty[0] = true;
    }

    public final byte getGreenByte() {
        return (byte)(this.values[1] * 255.0);
    }

    public final void setGreenInt(int green) {
        this.values[this.roTrick + 1] = (double)green / 255.0;
        this.isDirty[0] = true;
    }

    public final int getGreenInt() {
        return (int)(this.values[1] * 255.0);
    }

    public final void setBlue(double blue) {
        this.values[this.roTrick + 2] = blue;
        this.isDirty[0] = true;
    }

    public final double getBlue() {
        return this.values[2];
    }

    public final void b(double blue) {
        this.values[this.roTrick + 2] = blue;
        this.isDirty[0] = true;
    }

    public final double b() {
        return this.values[2];
    }

    public final void setBlueByte(byte blue) {
        this.values[this.roTrick + 2] = (double)(blue & 0xFF) / 255.0;
        this.isDirty[0] = true;
    }

    public final byte getBlueByte() {
        return (byte)(this.values[2] * 255.0);
    }

    public final void setBlueInt(int blue) {
        this.values[this.roTrick + 2] = (double)blue / 255.0;
        this.isDirty[0] = true;
    }

    public final int getBlueInt() {
        return (int)(this.values[2] * 255.0);
    }

    public final void setAlpha(double alpha) {
        this.values[this.roTrick + 3] = alpha;
        this.hasAlpha = alpha >= 0.0;
        this.isDirty[0] = true;
    }

    public final double getAlpha() {
        if (this.hasAlpha()) {
            return this.values[3];
        }
        return 0.0;
    }

    public final void a(double alpha) {
        this.values[this.roTrick + 3] = alpha;
        this.hasAlpha = alpha >= 0.0;
        this.isDirty[0] = true;
    }

    public final double a() {
        if (this.hasAlpha()) {
            return this.values[3];
        }
        return 0.0;
    }

    public final void setAlphaByte(byte alpha) {
        this.values[this.roTrick + 3] = (double)(alpha & 0xFF) / 255.0;
        this.hasAlpha = this.values[this.roTrick + 3] >= 0.0;
        this.isDirty[0] = true;
    }

    public final byte getAlphaByte() {
        if (this.hasAlpha()) {
            return (byte)(this.values[3] * 255.0);
        }
        return 0;
    }

    public final void setAlphaInt(int alpha) {
        this.values[this.roTrick + 3] = (double)alpha / 255.0;
        this.hasAlpha = this.values[this.roTrick + 3] >= 0.0;
        this.isDirty[0] = true;
    }

    public final int getAlphaInt() {
        if (this.hasAlpha()) {
            return (int)(this.values[3] * 255.0);
        }
        return 0;
    }

    public final Colord setZero() {
        int i = 0;
        while (i < 3) {
            this.values[this.roTrick + i] = 0.0;
            ++i;
        }
        if (this.hasAlpha()) {
            this.values[this.roTrick + 3] = 0.0;
        }
        this.isDirty[0] = true;
        return this;
    }

    public final Colord addRed(double v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] + v;
        this.isDirty[0] = true;
        return this;
    }

    public final Colord addGreen(double v) {
        int n = this.roTrick + 1;
        this.values[n] = this.values[n] + v;
        this.isDirty[0] = true;
        return this;
    }

    public final Colord addBlue(double v) {
        int n = this.roTrick + 2;
        this.values[n] = this.values[n] + v;
        this.isDirty[0] = true;
        return this;
    }

    public final Colord addAlpha(double v) {
        if (!this.hasAlpha()) {
            throw new UnsupportedOperationException("no alpha channel");
        }
        int n = this.roTrick + 3;
        this.values[n] = this.values[n] + v;
        this.isDirty[0] = true;
        return this;
    }

    public final Colord subRed(double v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] - v;
        this.isDirty[0] = true;
        return this;
    }

    public final Colord subGreen(double v) {
        int n = this.roTrick + 1;
        this.values[n] = this.values[n] - v;
        this.isDirty[0] = true;
        return this;
    }

    public final Colord subBlue(double v) {
        int n = this.roTrick + 2;
        this.values[n] = this.values[n] - v;
        this.isDirty[0] = true;
        return this;
    }

    public final Colord subAlpha(double v) {
        if (!this.hasAlpha()) {
            throw new UnsupportedOperationException("no alpha channel");
        }
        int n = this.roTrick + 3;
        this.values[n] = this.values[n] - v;
        this.isDirty[0] = true;
        return this;
    }

    public final Colord mulRed(double v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] * v;
        this.isDirty[0] = true;
        return this;
    }

    public final Colord mulGreen(double v) {
        int n = this.roTrick + 1;
        this.values[n] = this.values[n] * v;
        this.isDirty[0] = true;
        return this;
    }

    public final Colord mulBlue(double v) {
        int n = this.roTrick + 2;
        this.values[n] = this.values[n] * v;
        this.isDirty[0] = true;
        return this;
    }

    public final Colord mulAlpha(double v) {
        if (!this.hasAlpha()) {
            throw new UnsupportedOperationException("no alpha channel");
        }
        int n = this.roTrick + 3;
        this.values[n] = this.values[n] * v;
        this.isDirty[0] = true;
        return this;
    }

    public final Colord mul(double vr, double vg, double vb, double va) {
        if (!this.hasAlpha()) {
            throw new UnsupportedOperationException("no alpha channel");
        }
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] * vr;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] * vg;
        int n3 = this.roTrick + 2;
        this.values[n3] = this.values[n3] * vb;
        int n4 = this.roTrick + 3;
        this.values[n4] = this.values[n4] * va;
        this.isDirty[0] = true;
        return this;
    }

    public final Colord mul(double vr, double vg, double vb) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] * vr;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] * vg;
        int n3 = this.roTrick + 2;
        this.values[n3] = this.values[n3] * vb;
        this.isDirty[0] = true;
        return this;
    }

    public final Colord mul(double factor) {
        int n = this.hasAlpha() ? 4 : 3;
        int i = 0;
        while (i < n) {
            int n2 = this.roTrick + i;
            this.values[n2] = this.values[n2] * factor;
            ++i;
        }
        this.isDirty[0] = true;
        return this;
    }

    public final Colord divRed(double v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] / v;
        this.isDirty[0] = true;
        return this;
    }

    public final Colord divGreen(double v) {
        int n = this.roTrick + 1;
        this.values[n] = this.values[n] / v;
        this.isDirty[0] = true;
        return this;
    }

    public final Colord divBlue(double v) {
        int n = this.roTrick + 2;
        this.values[n] = this.values[n] / v;
        this.isDirty[0] = true;
        return this;
    }

    public final Colord divAlpha(double v) {
        if (!this.hasAlpha()) {
            throw new UnsupportedOperationException("no alpha channel");
        }
        int n = this.roTrick + 3;
        this.values[n] = this.values[n] / v;
        this.isDirty[0] = true;
        return this;
    }

    public final Colord div(double vr, double vg, double vb, double va) {
        if (!this.hasAlpha()) {
            throw new UnsupportedOperationException("no alpha channel");
        }
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] / vr;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] / vg;
        int n3 = this.roTrick + 2;
        this.values[n3] = this.values[n3] / vb;
        int n4 = this.roTrick + 3;
        this.values[n4] = this.values[n4] / va;
        this.isDirty[0] = true;
        return this;
    }

    public final Colord div(double vr, double vg, double vb) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] / vr;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] / vg;
        int n3 = this.roTrick + 2;
        this.values[n3] = this.values[n3] / vb;
        this.isDirty[0] = true;
        return this;
    }

    public final Colord add(Colord color1, Colord color2) {
        int n = this.hasAlpha() ? 4 : 3;
        int i = 0;
        while (i < n) {
            this.values[this.roTrick + i] = color1.values[i] + color2.values[i];
            ++i;
        }
        this.isDirty[0] = true;
        return this;
    }

    public final Colord add(Colord color2) {
        int n = this.hasAlpha() ? 4 : 3;
        int i = 0;
        while (i < n) {
            int n2 = this.roTrick + i;
            this.values[n2] = this.values[n2] + color2.values[i];
            ++i;
        }
        this.isDirty[0] = true;
        return this;
    }

    public final Colord add(double r, double g, double b, double a) {
        if (!this.hasAlpha()) {
            throw new UnsupportedOperationException("no alpha channel");
        }
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] + r;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] + g;
        int n3 = this.roTrick + 2;
        this.values[n3] = this.values[n3] + b;
        int n4 = this.roTrick + 3;
        this.values[n4] = this.values[n4] + a;
        this.isDirty[0] = true;
        return this;
    }

    public final Colord add(double r, double g, double b) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] + r;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] + g;
        int n3 = this.roTrick + 2;
        this.values[n3] = this.values[n3] + b;
        this.isDirty[0] = true;
        return this;
    }

    public final Colord sub(Colord color1, Colord color2) {
        int n = this.hasAlpha() ? 4 : 3;
        int i = 0;
        while (i < n) {
            this.values[this.roTrick + i] = color1.values[i] - color2.values[i];
            ++i;
        }
        this.isDirty[0] = true;
        return this;
    }

    public final Colord sub(Colord color2) {
        int n = this.hasAlpha() ? 4 : 3;
        int i = 0;
        while (i < n) {
            int n2 = this.roTrick + i;
            this.values[n2] = this.values[n2] - color2.values[i];
            ++i;
        }
        this.isDirty[0] = true;
        return this;
    }

    public final Colord sub(double r, double g, double b, double a) {
        if (!this.hasAlpha()) {
            throw new UnsupportedOperationException("no alpha channel");
        }
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] - r;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] - g;
        int n3 = this.roTrick + 2;
        this.values[n3] = this.values[n3] - b;
        int n4 = this.roTrick + 3;
        this.values[n4] = this.values[n4] - a;
        this.isDirty[0] = true;
        return this;
    }

    public final Colord sub(double r, double g, double b) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] - r;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] - g;
        int n3 = this.roTrick + 2;
        this.values[n3] = this.values[n3] - b;
        this.isDirty[0] = true;
        return this;
    }

    public final Colord clampMin(double min) {
        int n = this.hasAlpha() ? 4 : 3;
        int i = 0;
        while (i < n) {
            if (this.values[i] < min) {
                this.values[this.roTrick + i] = min;
            }
            ++i;
        }
        this.isDirty[0] = true;
        return this;
    }

    public final Colord clampMax(double max) {
        int n = this.hasAlpha() ? 4 : 3;
        int i = 0;
        while (i < n) {
            if (this.values[i] > max) {
                this.values[this.roTrick + i] = max;
            }
            ++i;
        }
        this.isDirty[0] = true;
        return this;
    }

    public final Colord clamp(double min, double max) {
        this.clampMin(min);
        this.clampMax(max);
        this.isDirty[0] = true;
        return this;
    }

    public final Colord clamp(double min, double max, Colord vec) {
        this.set(vec);
        this.clamp(min, max);
        this.isDirty[0] = true;
        return this;
    }

    public final Colord clampMin(double min, Colord vec) {
        this.set(vec);
        this.clampMin(min);
        this.isDirty[0] = true;
        return this;
    }

    public final Colord clampMax(double max, Colord vec) {
        this.set(vec);
        this.clampMax(max);
        this.isDirty[0] = true;
        return this;
    }

    public final Colord interpolate(Colord color2, double val) {
        double beta = 1.0 - val;
        int n = this.hasAlpha() ? 4 : 3;
        int i = 0;
        while (i < n) {
            this.values[this.roTrick + i] = beta * this.values[i] + val * color2.values[i];
            ++i;
        }
        this.isDirty[0] = true;
        return this;
    }

    public final Colord interpolate(Colord color1, Colord color2, double val) {
        double beta = 1.0 - val;
        int n = this.hasAlpha() ? 4 : 3;
        int i = 0;
        while (i < n) {
            this.values[this.roTrick + i] = beta * color1.values[i] + val * color2.values[i];
            ++i;
        }
        this.isDirty[0] = true;
        return this;
    }

    private static long doubleToLongBits(double f) {
        return f == 0.0 ? 0L : Double.doubleToLongBits(f);
    }

    public Colord asReadOnly() {
        return new Colord(true, this.values, this.isDirty, false);
    }

    public Colord getReadOnly() {
        if (this.readOnlyInstance == null) {
            this.readOnlyInstance = this.asReadOnly();
        }
        return this.readOnlyInstance;
    }

    public int hashCode() {
        long rbits = Colord.doubleToLongBits(this.values[0]);
        long gbits = Colord.doubleToLongBits(this.values[1]);
        long bbits = Colord.doubleToLongBits(this.values[2]);
        if (this.hasAlpha()) {
            return (int)(rbits ^ gbits ^ bbits ^ Colord.doubleToLongBits(this.values[3]));
        }
        return (int)(rbits ^ gbits ^ bbits);
    }

    public boolean equals(Colord color2) {
        if (this.hasAlpha() != color2.hasAlpha()) {
            return false;
        }
        int n = this.hasAlpha() ? 4 : 3;
        int i = 0;
        while (i < n) {
            if (color2.values[i] != this.values[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(Object o) {
        return o != null && o instanceof Colord && this.equals((Colord)o);
    }

    public boolean epsilonEquals(Colord color2, double epsilon) {
        if (this.hasAlpha() != color2.hasAlpha()) {
            return false;
        }
        int n = this.hasAlpha() ? 4 : 3;
        int i = 0;
        while (i < n) {
            if (Math.abs(color2.values[i] - this.values[i]) > epsilon) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public final String toHexString() {
        return ColorUtils.colorToHex(this);
    }

    public String toString() {
        String str = "Color ( red = " + this.getRed() + ", green = " + this.getGreen() + ", blue = " + this.getBlue();
        if (this.hasAlpha()) {
            return String.valueOf(str) + ", alpha = " + this.getAlpha() + " )";
        }
        return String.valueOf(str) + " )";
    }

    public Colord clone() {
        try {
            return (Colord)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    public int serialize(int pos, byte[] buffer) {
        int i = 0;
        while (i < this.values.length) {
            SerializationUtils.writeToBuffer(this.values[i], pos, buffer);
            pos += 4;
            ++i;
        }
        SerializationUtils.writeToBuffer(this.hasAlpha, pos, buffer);
        SerializationUtils.writeToBuffer(this.isDirty[0], ++pos, buffer);
        return ++pos;
    }

    public int deserialize(int pos, byte[] buffer) {
        int i = 0;
        while (i < this.values.length) {
            this.values[i] = SerializationUtils.readDoubleFromBuffer(pos, buffer);
            pos += 4;
            ++i;
        }
        this.hasAlpha = SerializationUtils.readBoolFromBuffer(pos, buffer);
        this.isDirty[0] = SerializationUtils.readBoolFromBuffer(++pos, buffer);
        return ++pos;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        byte[] buffer = new byte[18];
        this.serialize(0, buffer);
        out.write(buffer);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte[] buffer = new byte[18];
        in.read(buffer);
        this.deserialize(0, buffer);
    }

    protected Colord(boolean readOnly, double r, double g, double b, double a) {
        this.values = new double[]{r, g, b, a};
        this.hasAlpha = a >= 0.0;
        this.roTrick = readOnly ? -2147483647 + this.values.length : 0;
        this.isDirty = new boolean[1];
    }

    protected Colord(boolean readOnly, double r, double g, double b) {
        this(readOnly, r, g, b, -1.0);
    }

    protected Colord(boolean readOnly, double intensity) {
        this(readOnly, intensity, intensity, intensity);
    }

    protected Colord(boolean readOnly, double[] values, boolean[] isDirty, boolean copy) {
        if (copy) {
            this.values = new double[4];
            if (values.length >= 4) {
                System.arraycopy(values, 0, this.values, 0, 4);
            } else {
                System.arraycopy(values, 0, this.values, 0, 3);
                this.values[3] = -1.0;
            }
            this.isDirty = new boolean[1];
        } else {
            this.values = values;
            this.isDirty = isDirty;
        }
        this.hasAlpha = values.length > 3 && values[3] >= 0.0;
        this.roTrick = readOnly ? -2147483647 + values.length : 0;
    }

    protected Colord(boolean readOnly, Colord color) {
        this(readOnly, color.values, null, true);
        this.hasAlpha = color.hasAlpha;
    }

    protected Colord(boolean readOnly) {
        this(readOnly, 0.0, 0.0, 0.0, -1.0);
    }

    protected Colord(boolean readOnly, Color color) {
        this.values = new double[]{0.0, 0.0, 0.0, 0.0};
        this.values[0] = (double)color.getRed() / 255.0;
        this.values[1] = (double)color.getGreen() / 255.0;
        this.values[2] = (double)color.getBlue() / 255.0;
        boolean bl = this.hasAlpha = color.getAlpha() < 255;
        if (this.hasAlpha) {
            this.values[3] = (double)(255 - color.getAlpha()) / 255.0;
        }
        this.roTrick = readOnly ? -2147483647 + this.values.length : 0;
        this.isDirty = new boolean[1];
    }

    public Colord(double r, double g, double b, double a) {
        this(false, r, g, b, a);
    }

    public Colord(double r, double g, double b) {
        this(false, r, g, b);
    }

    public Colord(double intensity) {
        this(false, intensity);
    }

    public Colord(double[] values) {
        this(false, values, null, true);
    }

    public Colord(Colord color) {
        this(false, color);
    }

    public Colord() {
        this(false);
    }

    public Colord(Color color) {
        this(false, color);
    }

    public static Colord parseColor(String hexString, Colord buffer) {
        ColorUtils.hexToColor(hexString, buffer);
        return buffer;
    }

    public static Colord parseColor(String hexString) {
        return Colord.parseColor(hexString, new Colord());
    }

    public static Colord parseReadOnlyColor(String hexString) {
        double[] values = new double[4];
        ColorUtils.hexToColor(hexString, values);
        return new Colord(true, values, null, true);
    }

    public static Colord fromPool() {
        return POOL.get().alloc();
    }

    public static Colord fromPool(double r, double g, double b, double a) {
        return POOL.get().alloc(r, g, b, a);
    }

    public static Colord fromPool(double r, double g, double b) {
        return POOL.get().alloc(r, g, b);
    }

    public static Colord fromPool(Colord color) {
        if (color.hasAlpha()) {
            return Colord.fromPool(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        }
        return Colord.fromPool(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static void toPool(Colord o) {
        POOL.get().free(o);
    }
}

