/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.vecmath2;

import java.awt.Color;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.FloatBuffer;
import org.openmali.vecmath2.pools.ColorfPool;
import org.openmali.vecmath2.util.ColorUtils;
import org.openmali.vecmath2.util.SerializationUtils;

public class Colorf
implements Externalizable {
    private static final long serialVersionUID = -818575512943622856L;
    private static final ThreadLocal<ColorfPool> POOL = new ThreadLocal<ColorfPool>(){

        @Override
        protected ColorfPool initialValue() {
            return new ColorfPool(128);
        }
    };
    protected static final int N = 4;
    protected final float[] values;
    protected boolean hasAlpha;
    protected final int roTrick;
    protected final boolean[] isDirty;
    private Colorf readOnlyInstance = null;
    public static final Colorf WHITE = Colorf.newReadOnly(Color.WHITE);
    public static final Colorf WHITE_TRANSPARENT = Colorf.newReadOnly(WHITE, 1.0f);
    public static final Colorf LIGHT_GRAY = Colorf.newReadOnly(Color.GRAY);
    public static final Colorf GRAY10 = Colorf.newReadOnly(0.9f);
    public static final Colorf GRAY20 = Colorf.newReadOnly(0.8f);
    public static final Colorf GRAY25 = Colorf.newReadOnly(0.75f);
    public static final Colorf GRAY30 = Colorf.newReadOnly(0.7f);
    public static final Colorf GRAY40 = Colorf.newReadOnly(0.6f);
    public static final Colorf GRAY50 = Colorf.newReadOnly(0.5f);
    public static final Colorf GRAY60 = Colorf.newReadOnly(0.4f);
    public static final Colorf GRAY70 = Colorf.newReadOnly(0.3f);
    public static final Colorf GRAY75 = Colorf.newReadOnly(0.25f);
    public static final Colorf GRAY80 = Colorf.newReadOnly(0.2f);
    public static final Colorf GRAY90 = Colorf.newReadOnly(0.1f);
    public static final Colorf GRAY = Colorf.newReadOnly(Color.GRAY);
    public static final Colorf DARK_GRAY = Colorf.newReadOnly(Color.DARK_GRAY);
    public static final Colorf BLACK = Colorf.newReadOnly(Color.BLACK);
    public static final Colorf BLACK_TRANSPARENT = Colorf.newReadOnly(BLACK, 1.0f);
    public static final Colorf BROWN = Colorf.parseReadOnlyColor("#6D493B");
    public static final Colorf LIGHT_BROWN = Colorf.parseReadOnlyColor("#91624F");
    public static final Colorf DARK_BROWN = Colorf.parseReadOnlyColor("#583B30");
    public static final Colorf RED = Colorf.newReadOnly(Color.RED);
    public static final Colorf PINK = Colorf.newReadOnly(Color.PINK);
    public static final Colorf ORANGE = Colorf.newReadOnly(Color.ORANGE);
    public static final Colorf YELLOW = Colorf.newReadOnly(Color.YELLOW);
    public static final Colorf GREEN = Colorf.newReadOnly(Color.GREEN);
    public static final Colorf MAGENTA = Colorf.newReadOnly(Color.MAGENTA);
    public static final Colorf CYAN = Colorf.newReadOnly(Color.CYAN);
    public static final Colorf BLUE = Colorf.newReadOnly(Color.BLUE);

    public final boolean isReadOnly() {
        return this.roTrick != 0;
    }

    public final boolean setClean() {
        if (this.isReadOnly()) {
            throw new Error("This instance is read-only.");
        }
        boolean oldValue = this.isDirty[0];
        this.isDirty[0] = false;
        return oldValue;
    }

    public final boolean isDirty() {
        return this.isDirty[0];
    }

    public static Colorf createGray(float intensity) {
        return new Colorf(intensity, intensity, intensity);
    }

    public final int getSize() {
        return 4;
    }

    public final boolean hasAlpha() {
        return this.hasAlpha;
    }

    public final void set(Color color) {
        this.setRed((float)color.getRed() / 255.0f);
        this.setGreen((float)color.getGreen() / 255.0f);
        this.setBlue((float)color.getBlue() / 255.0f);
        boolean bl = this.hasAlpha = color.getAlpha() < 255;
        if (this.hasAlpha) {
            this.setAlpha((float)(255 - color.getAlpha()) / 255.0f);
        }
        this.isDirty[0] = true;
    }

    public final void set(float[] values, int offset, boolean alpha) {
        if (alpha) {
            System.arraycopy(values, 0, this.values, this.roTrick + 0, 4);
            this.hasAlpha = true;
        } else {
            System.arraycopy(values, 0, this.values, this.roTrick + 0, 3);
            this.hasAlpha = false;
        }
        this.isDirty[0] = true;
    }

    public final void set(float[] values, boolean alpha) {
        this.set(values, 0, alpha);
    }

    public final void set(float[] values) {
        this.set(values, 0, values.length > 3 && values[3] > 0.0f);
    }

    public final void setBytes(byte[] values) {
        if (values.length > 3) {
            this.setRedByte(values[0]);
            this.setGreenByte(values[1]);
            this.setBlueByte(values[2]);
            this.setAlphaByte(values[3]);
        } else {
            this.setRedByte(values[0]);
            this.setGreenByte(values[1]);
            this.setBlueByte(values[2]);
            this.hasAlpha = false;
        }
        this.isDirty[0] = true;
    }

    public final void setInts(int[] values) {
        if (values.length > 3) {
            this.setRedInt(values[0]);
            this.setGreenInt(values[1]);
            this.setBlueInt(values[2]);
            this.setAlphaInt(values[3]);
        } else {
            this.setRedInt(values[0]);
            this.setGreenInt(values[1]);
            this.setBlueInt(values[2]);
            this.hasAlpha = false;
        }
        this.isDirty[0] = true;
    }

    public final void set(Colorf color) {
        System.arraycopy(color.values, 0, this.values, this.roTrick + 0, 4);
        this.hasAlpha = color.hasAlpha;
        this.isDirty[0] = true;
    }

    public final void set(float r, float g, float b, float a) {
        this.setRed(r);
        this.setGreen(g);
        this.setBlue(b);
        this.setAlpha(a);
        this.hasAlpha = a >= 0.0f;
        this.isDirty[0] = true;
    }

    public final void set(float r, float g, float b) {
        this.setRed(r);
        this.setGreen(g);
        this.setBlue(b);
        this.hasAlpha = false;
        this.isDirty[0] = true;
    }

    public final Color getAWTColor() {
        if (this.hasAlpha()) {
            return new Color(this.getRed(), this.getGreen(), this.getBlue(), 1.0f - this.getAlpha());
        }
        return new Color(this.getRed(), this.getGreen(), this.getBlue());
    }

    public final void get(float[] buffer, int offset) {
        int n = this.hasAlpha() ? 4 : 3;
        System.arraycopy(this.values, 0, buffer, offset, n);
    }

    public final void get(float[] buffer) {
        this.get(buffer, 0);
    }

    public final void getBytes(byte[] buffer) {
        buffer[0] = this.getRedByte();
        buffer[1] = this.getGreenByte();
        buffer[2] = this.getBlueByte();
        if (this.hasAlpha() && buffer.length >= 4) {
            buffer[3] = this.getAlphaByte();
        }
    }

    public final void getInts(int[] buffer) {
        buffer[0] = this.getRedInt();
        buffer[1] = this.getGreenInt();
        buffer[2] = this.getBlueInt();
        if (this.hasAlpha() && buffer.length >= 4) {
            buffer[3] = this.getAlphaInt();
        }
    }

    public final void get(Colorf buffer) {
        System.arraycopy(this.values, 0, buffer.values, 0, 4);
        buffer.hasAlpha = this.hasAlpha;
    }

    public final FloatBuffer writeToBuffer(boolean forceAlpha, FloatBuffer buffer, boolean clear, boolean flip) {
        if (clear) {
            buffer.clear();
        }
        if (this.hasAlpha()) {
            buffer.put(this.values);
        } else if (forceAlpha) {
            buffer.put(this.values[0]).put(this.values[1]).put(this.values[2]).put(0.0f);
        } else {
            buffer.put(this.values[0]).put(this.values[1]).put(this.values[2]);
        }
        if (flip) {
            buffer.flip();
        }
        return buffer;
    }

    public final FloatBuffer writeToBuffer(boolean forceAlpha, FloatBuffer buffer, int position, boolean clear, boolean flip) {
        if (clear) {
            buffer.clear();
        }
        buffer.position(position);
        return this.writeToBuffer(forceAlpha, buffer, false, flip);
    }

    public final FloatBuffer writeToBuffer(FloatBuffer buffer, boolean clear, boolean flip) {
        return this.writeToBuffer(false, buffer, clear, flip);
    }

    public final FloatBuffer writeToBuffer(FloatBuffer buffer, int position, boolean clear, boolean flip) {
        if (clear) {
            buffer.clear();
        }
        buffer.position(position);
        return this.writeToBuffer(false, buffer, false, flip);
    }

    public static final FloatBuffer writeToBuffer(Colorf[] colors, boolean forceAlpha, FloatBuffer buffer, boolean clear, boolean flip) {
        if (clear) {
            buffer.clear();
        }
        int i = 0;
        while (i < colors.length) {
            colors[i].writeToBuffer(forceAlpha, buffer, false, false);
            ++i;
        }
        if (flip) {
            buffer.flip();
        }
        return buffer;
    }

    public static final FloatBuffer writeToBuffer(Colorf[] colors, boolean forceAlpha, FloatBuffer buffer, int position, boolean clear, boolean flip) {
        if (clear) {
            buffer.clear();
        }
        buffer.position(position);
        return Colorf.writeToBuffer(colors, forceAlpha, buffer, false, flip);
    }

    public static final FloatBuffer writeToBuffer(Colorf[] colors, FloatBuffer buffer, boolean clear, boolean flip) {
        return Colorf.writeToBuffer(colors, false, buffer, clear, flip);
    }

    public static final FloatBuffer writeToBuffer(Colorf[] colors, FloatBuffer buffer, int position, boolean clear, boolean flip) {
        if (clear) {
            buffer.clear();
        }
        buffer.position(position);
        return Colorf.writeToBuffer(colors, false, buffer, false, flip);
    }

    public final FloatBuffer readFromBuffer(boolean forceAlpha, FloatBuffer buffer) {
        if (this.hasAlpha() || forceAlpha) {
            buffer.get(this.values);
        } else {
            buffer.get(this.values, 0, 3);
        }
        return buffer;
    }

    public final FloatBuffer readFromBuffer(boolean forceAlpha, FloatBuffer buffer, int position) {
        buffer.position(position);
        if (this.hasAlpha() || forceAlpha) {
            buffer.get(this.values);
        } else {
            buffer.get(this.values, 0, 3);
        }
        return buffer;
    }

    public final FloatBuffer readFromBuffer(FloatBuffer buffer) {
        return this.readFromBuffer(false, buffer);
    }

    public final FloatBuffer readFromBuffer(FloatBuffer buffer, int position) {
        return this.readFromBuffer(false, buffer, position);
    }

    public static final FloatBuffer readFromBuffer(Colorf[] colors, boolean forceAlpha, FloatBuffer buffer) {
        int i = 0;
        while (i < colors.length) {
            colors[i].readFromBuffer(forceAlpha, buffer);
            ++i;
        }
        return buffer;
    }

    public static final FloatBuffer readFromBuffer(Colorf[] colors, boolean forceAlpha, FloatBuffer buffer, int position) {
        buffer.position(position);
        return Colorf.readFromBuffer(colors, forceAlpha, buffer);
    }

    public static final FloatBuffer readFromBuffer(Colorf[] colors, FloatBuffer buffer) {
        return Colorf.readFromBuffer(colors, false, buffer);
    }

    public static final FloatBuffer readFromBuffer(Colorf[] colors, FloatBuffer buffer, int position) {
        buffer.position(position);
        return Colorf.readFromBuffer(colors, false, buffer);
    }

    public final void setRed(float red) {
        this.values[this.roTrick + 0] = red;
        this.isDirty[0] = true;
    }

    public final float getRed() {
        return this.values[0];
    }

    public final void r(float red) {
        this.values[this.roTrick + 0] = red;
        this.isDirty[0] = true;
    }

    public final float r() {
        return this.values[0];
    }

    public final void setRedByte(byte red) {
        this.values[this.roTrick + 0] = (float)(red & 0xFF) / 255.0f;
        this.isDirty[0] = true;
    }

    public final byte getRedByte() {
        return (byte)(this.values[0] * 255.0f);
    }

    public final void setRedInt(int red) {
        this.values[this.roTrick + 0] = (float)red / 255.0f;
        this.isDirty[0] = true;
    }

    public final int getRedInt() {
        return (int)(this.values[0] * 255.0f);
    }

    public final void setGreen(float green) {
        this.values[this.roTrick + 1] = green;
        this.isDirty[0] = true;
    }

    public final float getGreen() {
        return this.values[1];
    }

    public final void g(float green) {
        this.values[this.roTrick + 1] = green;
        this.isDirty[0] = true;
    }

    public final float g() {
        return this.values[1];
    }

    public final void setGreenByte(byte green) {
        this.values[this.roTrick + 1] = (float)(green & 0xFF) / 255.0f;
        this.isDirty[0] = true;
    }

    public final byte getGreenByte() {
        return (byte)(this.values[1] * 255.0f);
    }

    public final void setGreenInt(int green) {
        this.values[this.roTrick + 1] = (float)green / 255.0f;
        this.isDirty[0] = true;
    }

    public final int getGreenInt() {
        return (int)(this.values[1] * 255.0f);
    }

    public final void setBlue(float blue) {
        this.values[this.roTrick + 2] = blue;
        this.isDirty[0] = true;
    }

    public final float getBlue() {
        return this.values[2];
    }

    public final void b(float blue) {
        this.values[this.roTrick + 2] = blue;
        this.isDirty[0] = true;
    }

    public final float b() {
        return this.values[2];
    }

    public final void setBlueByte(byte blue) {
        this.values[this.roTrick + 2] = (float)(blue & 0xFF) / 255.0f;
        this.isDirty[0] = true;
    }

    public final byte getBlueByte() {
        return (byte)(this.values[2] * 255.0f);
    }

    public final void setBlueInt(int blue) {
        this.values[this.roTrick + 2] = (float)blue / 255.0f;
        this.isDirty[0] = true;
    }

    public final int getBlueInt() {
        return (int)(this.values[2] * 255.0f);
    }

    public final void setAlpha(float alpha) {
        this.values[this.roTrick + 3] = alpha;
        this.hasAlpha = alpha >= 0.0f;
        this.isDirty[0] = true;
    }

    public final float getAlpha() {
        if (this.hasAlpha()) {
            return this.values[3];
        }
        return 0.0f;
    }

    public final void a(float alpha) {
        this.values[this.roTrick + 3] = alpha;
        this.hasAlpha = alpha >= 0.0f;
        this.isDirty[0] = true;
    }

    public final float a() {
        if (this.hasAlpha()) {
            return this.values[3];
        }
        return 0.0f;
    }

    public final void setAlphaByte(byte alpha) {
        this.values[this.roTrick + 3] = (float)(alpha & 0xFF) / 255.0f;
        this.hasAlpha = this.values[this.roTrick + 3] >= 0.0f;
        this.isDirty[0] = true;
    }

    public final byte getAlphaByte() {
        if (this.hasAlpha()) {
            return (byte)(this.values[3] * 255.0f);
        }
        return 0;
    }

    public final void setAlphaInt(int alpha) {
        this.values[this.roTrick + 3] = (float)alpha / 255.0f;
        this.hasAlpha = this.values[this.roTrick + 3] >= 0.0f;
        this.isDirty[0] = true;
    }

    public final int getAlphaInt() {
        if (this.hasAlpha()) {
            return (int)(this.values[3] * 255.0f);
        }
        return 0;
    }

    public final Colorf setZero() {
        int i = 0;
        while (i < 3) {
            this.values[this.roTrick + i] = 0.0f;
            ++i;
        }
        if (this.hasAlpha()) {
            this.values[this.roTrick + 3] = 0.0f;
        }
        this.isDirty[0] = true;
        return this;
    }

    public final Colorf addRed(float v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] + v;
        this.isDirty[0] = true;
        return this;
    }

    public final Colorf addGreen(float v) {
        int n = this.roTrick + 1;
        this.values[n] = this.values[n] + v;
        this.isDirty[0] = true;
        return this;
    }

    public final Colorf addBlue(float v) {
        int n = this.roTrick + 2;
        this.values[n] = this.values[n] + v;
        this.isDirty[0] = true;
        return this;
    }

    public final Colorf addAlpha(float v) {
        if (!this.hasAlpha()) {
            throw new UnsupportedOperationException("no alpha channel");
        }
        int n = this.roTrick + 3;
        this.values[n] = this.values[n] + v;
        this.isDirty[0] = true;
        return this;
    }

    public final Colorf subRed(float v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] - v;
        this.isDirty[0] = true;
        return this;
    }

    public final Colorf subGreen(float v) {
        int n = this.roTrick + 1;
        this.values[n] = this.values[n] - v;
        this.isDirty[0] = true;
        return this;
    }

    public final Colorf subBlue(float v) {
        int n = this.roTrick + 2;
        this.values[n] = this.values[n] - v;
        this.isDirty[0] = true;
        return this;
    }

    public final Colorf subAlpha(float v) {
        if (!this.hasAlpha()) {
            throw new UnsupportedOperationException("no alpha channel");
        }
        int n = this.roTrick + 3;
        this.values[n] = this.values[n] - v;
        this.isDirty[0] = true;
        return this;
    }

    public final Colorf mulRed(float v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] * v;
        this.isDirty[0] = true;
        return this;
    }

    public final Colorf mulGreen(float v) {
        int n = this.roTrick + 1;
        this.values[n] = this.values[n] * v;
        this.isDirty[0] = true;
        return this;
    }

    public final Colorf mulBlue(float v) {
        int n = this.roTrick + 2;
        this.values[n] = this.values[n] * v;
        this.isDirty[0] = true;
        return this;
    }

    public final Colorf mulAlpha(float v) {
        if (!this.hasAlpha()) {
            throw new UnsupportedOperationException("no alpha channel");
        }
        int n = this.roTrick + 3;
        this.values[n] = this.values[n] * v;
        this.isDirty[0] = true;
        return this;
    }

    public final Colorf mul(float vr, float vg, float vb, float va) {
        if (!this.hasAlpha()) {
            throw new UnsupportedOperationException("no alpha channel");
        }
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] * vr;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] * vg;
        int n3 = this.roTrick + 2;
        this.values[n3] = this.values[n3] * vb;
        int n4 = this.roTrick + 3;
        this.values[n4] = this.values[n4] * va;
        this.isDirty[0] = true;
        return this;
    }

    public final Colorf mul(float vr, float vg, float vb) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] * vr;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] * vg;
        int n3 = this.roTrick + 2;
        this.values[n3] = this.values[n3] * vb;
        this.isDirty[0] = true;
        return this;
    }

    public final Colorf mul(float factor) {
        int n = this.hasAlpha() ? 4 : 3;
        int i = 0;
        while (i < n) {
            int n2 = this.roTrick + i;
            this.values[n2] = this.values[n2] * factor;
            ++i;
        }
        this.isDirty[0] = true;
        return this;
    }

    public final Colorf divRed(float v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] / v;
        this.isDirty[0] = true;
        return this;
    }

    public final Colorf divGreen(float v) {
        int n = this.roTrick + 1;
        this.values[n] = this.values[n] / v;
        this.isDirty[0] = true;
        return this;
    }

    public final Colorf divBlue(float v) {
        int n = this.roTrick + 2;
        this.values[n] = this.values[n] / v;
        this.isDirty[0] = true;
        return this;
    }

    public final Colorf divAlpha(float v) {
        if (!this.hasAlpha()) {
            throw new UnsupportedOperationException("no alpha channel");
        }
        int n = this.roTrick + 3;
        this.values[n] = this.values[n] / v;
        this.isDirty[0] = true;
        return this;
    }

    public final Colorf div(float vr, float vg, float vb, float va) {
        if (!this.hasAlpha()) {
            throw new UnsupportedOperationException("no alpha channel");
        }
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] / vr;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] / vg;
        int n3 = this.roTrick + 2;
        this.values[n3] = this.values[n3] / vb;
        int n4 = this.roTrick + 3;
        this.values[n4] = this.values[n4] / va;
        this.isDirty[0] = true;
        return this;
    }

    public final Colorf div(float vr, float vg, float vb) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] / vr;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] / vg;
        int n3 = this.roTrick + 2;
        this.values[n3] = this.values[n3] / vb;
        this.isDirty[0] = true;
        return this;
    }

    public final Colorf add(Colorf color1, Colorf color2) {
        int n = this.hasAlpha() ? 4 : 3;
        int i = 0;
        while (i < n) {
            this.values[this.roTrick + i] = color1.values[i] + color2.values[i];
            ++i;
        }
        this.isDirty[0] = true;
        return this;
    }

    public final Colorf add(Colorf color2) {
        int n = this.hasAlpha() ? 4 : 3;
        int i = 0;
        while (i < n) {
            int n2 = this.roTrick + i;
            this.values[n2] = this.values[n2] + color2.values[i];
            ++i;
        }
        this.isDirty[0] = true;
        return this;
    }

    public final Colorf add(float r, float g, float b, float a) {
        if (!this.hasAlpha()) {
            throw new UnsupportedOperationException("no alpha channel");
        }
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] + r;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] + g;
        int n3 = this.roTrick + 2;
        this.values[n3] = this.values[n3] + b;
        int n4 = this.roTrick + 3;
        this.values[n4] = this.values[n4] + a;
        this.isDirty[0] = true;
        return this;
    }

    public final Colorf add(float r, float g, float b) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] + r;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] + g;
        int n3 = this.roTrick + 2;
        this.values[n3] = this.values[n3] + b;
        this.isDirty[0] = true;
        return this;
    }

    public final Colorf sub(Colorf color1, Colorf color2) {
        int n = this.hasAlpha() ? 4 : 3;
        int i = 0;
        while (i < n) {
            this.values[this.roTrick + i] = color1.values[i] - color2.values[i];
            ++i;
        }
        this.isDirty[0] = true;
        return this;
    }

    public final Colorf sub(Colorf color2) {
        int n = this.hasAlpha() ? 4 : 3;
        int i = 0;
        while (i < n) {
            int n2 = this.roTrick + i;
            this.values[n2] = this.values[n2] - color2.values[i];
            ++i;
        }
        this.isDirty[0] = true;
        return this;
    }

    public final Colorf sub(float r, float g, float b, float a) {
        if (!this.hasAlpha()) {
            throw new UnsupportedOperationException("no alpha channel");
        }
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] - r;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] - g;
        int n3 = this.roTrick + 2;
        this.values[n3] = this.values[n3] - b;
        int n4 = this.roTrick + 3;
        this.values[n4] = this.values[n4] - a;
        this.isDirty[0] = true;
        return this;
    }

    public final Colorf sub(float r, float g, float b) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] - r;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] - g;
        int n3 = this.roTrick + 2;
        this.values[n3] = this.values[n3] - b;
        this.isDirty[0] = true;
        return this;
    }

    public final Colorf clampMin(float min) {
        int n = this.hasAlpha() ? 4 : 3;
        int i = 0;
        while (i < n) {
            if (this.values[i] < min) {
                this.values[this.roTrick + i] = min;
            }
            ++i;
        }
        this.isDirty[0] = true;
        return this;
    }

    public final Colorf clampMax(float max) {
        int n = this.hasAlpha() ? 4 : 3;
        int i = 0;
        while (i < n) {
            if (this.values[i] > max) {
                this.values[this.roTrick + i] = max;
            }
            ++i;
        }
        this.isDirty[0] = true;
        return this;
    }

    public final Colorf clamp(float min, float max) {
        this.clampMin(min);
        this.clampMax(max);
        this.isDirty[0] = true;
        return this;
    }

    public final Colorf clamp(float min, float max, Colorf vec) {
        this.set(vec);
        this.clamp(min, max);
        this.isDirty[0] = true;
        return this;
    }

    public final Colorf clampMin(float min, Colorf vec) {
        this.set(vec);
        this.clampMin(min);
        this.isDirty[0] = true;
        return this;
    }

    public final Colorf clampMax(float max, Colorf vec) {
        this.set(vec);
        this.clampMax(max);
        this.isDirty[0] = true;
        return this;
    }

    public final Colorf interpolate(Colorf color2, float val) {
        float beta = 1.0f - val;
        int n = this.hasAlpha() ? 4 : 3;
        int i = 0;
        while (i < n) {
            this.values[this.roTrick + i] = beta * this.values[i] + val * color2.values[i];
            ++i;
        }
        this.isDirty[0] = true;
        return this;
    }

    public final Colorf interpolate(Colorf color1, Colorf color2, float val) {
        float beta = 1.0f - val;
        int n = this.hasAlpha() ? 4 : 3;
        int i = 0;
        while (i < n) {
            this.values[this.roTrick + i] = beta * color1.values[i] + val * color2.values[i];
            ++i;
        }
        this.isDirty[0] = true;
        return this;
    }

    private static int floatToIntBits(float f) {
        return f == 0.0f ? 0 : Float.floatToIntBits(f);
    }

    public Colorf asReadOnly() {
        return new Colorf(true, this.values, this.isDirty, false);
    }

    public Colorf getReadOnly() {
        if (this.readOnlyInstance == null) {
            this.readOnlyInstance = this.asReadOnly();
        }
        return this.readOnlyInstance;
    }

    public int hashCode() {
        int rbits = Colorf.floatToIntBits(this.values[0]);
        int gbits = Colorf.floatToIntBits(this.values[1]);
        int bbits = Colorf.floatToIntBits(this.values[2]);
        if (this.hasAlpha()) {
            return rbits ^ gbits ^ bbits ^ Colorf.floatToIntBits(this.values[3]);
        }
        return rbits ^ gbits ^ bbits;
    }

    public boolean equals(Colorf color2) {
        if (this.hasAlpha() != color2.hasAlpha()) {
            return false;
        }
        int n = this.hasAlpha() ? 4 : 3;
        int i = 0;
        while (i < n) {
            if (color2.values[i] != this.values[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(Object o) {
        return o != null && o instanceof Colorf && this.equals((Colorf)o);
    }

    public boolean epsilonEquals(Colorf color2, float epsilon) {
        if (this.hasAlpha() != color2.hasAlpha()) {
            return false;
        }
        int n = this.hasAlpha() ? 4 : 3;
        int i = 0;
        while (i < n) {
            if (Math.abs(color2.values[i] - this.values[i]) > epsilon) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public final String toHexString() {
        return ColorUtils.colorToHex(this);
    }

    public String toString() {
        String str = "Color ( red = " + this.getRed() + ", green = " + this.getGreen() + ", blue = " + this.getBlue();
        if (this.hasAlpha()) {
            return String.valueOf(str) + ", alpha = " + this.getAlpha() + " )";
        }
        return String.valueOf(str) + " )";
    }

    public Colorf clone() {
        return new Colorf(this);
    }

    public int serialize(int pos, byte[] buffer) {
        int i = 0;
        while (i < this.values.length) {
            SerializationUtils.writeToBuffer(this.values[i], pos, buffer);
            pos += 4;
            ++i;
        }
        SerializationUtils.writeToBuffer(this.hasAlpha, pos, buffer);
        SerializationUtils.writeToBuffer(this.isDirty[0], ++pos, buffer);
        return ++pos;
    }

    public int deserialize(int pos, byte[] buffer) {
        int i = 0;
        while (i < this.values.length) {
            this.values[i] = SerializationUtils.readFloatFromBuffer(pos, buffer);
            pos += 4;
            ++i;
        }
        this.hasAlpha = SerializationUtils.readBoolFromBuffer(pos, buffer);
        this.isDirty[0] = SerializationUtils.readBoolFromBuffer(++pos, buffer);
        return ++pos;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        byte[] buffer = new byte[18];
        this.serialize(0, buffer);
        out.write(buffer);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte[] buffer = new byte[18];
        in.read(buffer);
        this.deserialize(0, buffer);
    }

    protected Colorf(boolean readOnly, float r, float g, float b, float a) {
        this.values = new float[]{r, g, b, a};
        this.hasAlpha = a >= 0.0f;
        this.roTrick = readOnly ? -2147483647 + this.values.length : 0;
        this.isDirty = new boolean[1];
    }

    protected Colorf(boolean readOnly, float r, float g, float b) {
        this(readOnly, r, g, b, -1.0f);
    }

    protected Colorf(boolean readOnly, float intensity) {
        this(readOnly, intensity, intensity, intensity);
    }

    protected Colorf(boolean readOnly, float[] values, boolean[] isDirty, boolean copy) {
        if (copy) {
            this.values = new float[4];
            if (values.length >= 4) {
                System.arraycopy(values, 0, this.values, 0, 4);
            } else {
                System.arraycopy(values, 0, this.values, 0, 3);
                this.values[3] = -1.0f;
            }
            this.isDirty = new boolean[1];
        } else {
            this.values = values;
            this.isDirty = isDirty;
        }
        this.hasAlpha = values.length > 3 && values[3] >= 0.0f;
        this.roTrick = readOnly ? -2147483647 + values.length : 0;
    }

    protected Colorf(boolean readOnly, Colorf color) {
        this(readOnly, color.values, null, true);
        this.hasAlpha = color.hasAlpha;
    }

    protected Colorf(boolean readOnly) {
        this(readOnly, 0.0f, 0.0f, 0.0f, -1.0f);
    }

    protected Colorf(boolean readOnly, Color color) {
        this.values = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        this.values[0] = (float)color.getRed() / 255.0f;
        this.values[1] = (float)color.getGreen() / 255.0f;
        this.values[2] = (float)color.getBlue() / 255.0f;
        boolean bl = this.hasAlpha = color.getAlpha() < 255;
        if (this.hasAlpha) {
            this.values[3] = (float)(255 - color.getAlpha()) / 255.0f;
        }
        this.roTrick = readOnly ? -2147483647 + this.values.length : 0;
        this.isDirty = new boolean[1];
    }

    public Colorf(float r, float g, float b, float a) {
        this(false, r, g, b, a);
    }

    public Colorf(float r, float g, float b) {
        this(false, r, g, b);
    }

    public Colorf(float intensity) {
        this(false, intensity);
    }

    public Colorf(float[] values) {
        this(false, values, null, true);
    }

    public Colorf(Colorf color) {
        this(false, color);
    }

    public Colorf(Colorf rgbColor, float alpha) {
        this(false, rgbColor.getRed(), rgbColor.getGreen(), rgbColor.getBlue(), alpha);
    }

    public Colorf() {
        this(false);
    }

    public Colorf(Color color) {
        this(false, color);
    }

    public static Colorf newReadOnly(float r, float g, float b, float a) {
        return new Colorf(true, r, g, b, a);
    }

    public static Colorf newReadOnly(float r, float g, float b) {
        return new Colorf(true, r, g, b);
    }

    public static Colorf newReadOnly(float intensity) {
        return new Colorf(true, intensity);
    }

    public static Colorf newReadOnly(float[] values) {
        return new Colorf(true, values, null, true);
    }

    public static Colorf newReadOnly(Colorf color) {
        return new Colorf(true, color);
    }

    public static Colorf newReadOnly(Colorf rgbColor, float alpha) {
        return new Colorf(true, rgbColor.getRed(), rgbColor.getGreen(), rgbColor.getBlue(), alpha);
    }

    public static Colorf newReadOnly() {
        return new Colorf(true);
    }

    public static Colorf newReadOnly(Color color) {
        return new Colorf(true, color);
    }

    public static Colorf parseColor(String hexString, Colorf buffer) {
        ColorUtils.hexToColor(hexString, buffer);
        return buffer;
    }

    public static Colorf parseColor(String hexString) {
        return Colorf.parseColor(hexString, new Colorf());
    }

    public static Colorf parseReadOnlyColor(String hexString) {
        float[] values = new float[4];
        ColorUtils.hexToColor(hexString, values);
        return new Colorf(true, values, null, true);
    }

    public static Colorf fromPool() {
        return POOL.get().alloc();
    }

    public static Colorf fromPool(float r, float g, float b, float a) {
        return POOL.get().alloc(r, g, b, a);
    }

    public static Colorf fromPool(float r, float g, float b) {
        return POOL.get().alloc(r, g, b);
    }

    public static Colorf fromPool(Colorf color) {
        if (color.hasAlpha()) {
            return Colorf.fromPool(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        }
        return Colorf.fromPool(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static void toPool(Colorf o) {
        POOL.get().free(o);
    }
}

