/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.vecmath2;

import java.io.Externalizable;
import org.openmali.FastMathd;
import org.openmali.vecmath2.Tuple2d;
import org.openmali.vecmath2.pools.Point2dPool;

public class Point2d
extends Tuple2d
implements Externalizable {
    private static final long serialVersionUID = -193058726611025895L;
    public static final Point2d ZERO = Point2d.newReadOnly(0.0, 0.0);
    private static final ThreadLocal<Point2dPool> POOL = new ThreadLocal<Point2dPool>(){

        @Override
        protected Point2dPool initialValue() {
            return new Point2dPool(128);
        }
    };
    private Point2d readOnlyInstance = null;

    public final double distanceSquared(Point2d point2) {
        double dx = this.getX() - point2.getX();
        double dy = this.getY() - point2.getY();
        return dx * dx + dy * dy;
    }

    public final double distance(Point2d point2) {
        return FastMathd.sqrt(this.distanceSquared(point2));
    }

    public final double distanceSquared(double p2x, double p2y) {
        double result = 0.0;
        double d = this.getX() - p2x;
        result += d * d;
        d = this.getY() - p2y;
        return result += d * d;
    }

    public final double distance(double p2x, double p2y) {
        return FastMathd.sqrt(this.distanceSquared(p2x, p2y));
    }

    public final double distanceToOriginSquared() {
        return this.distance(0.0, 0.0);
    }

    public double distanceToOrigin() {
        return FastMathd.sqrt(this.distanceToOriginSquared());
    }

    public final double distanceL1(Point2d point2) {
        return Math.abs(this.getX() - point2.getX()) + Math.abs(this.getY() - point2.getY());
    }

    public final double distanceLinf(Point2d point2) {
        return Math.max(Math.abs(this.getX() - point2.getY()), Math.abs(this.getY() - point2.getY()));
    }

    public Point2d asReadOnly() {
        return new Point2d(true, this.values, this.isDirty, false);
    }

    public Point2d getReadOnly() {
        if (this.readOnlyInstance == null) {
            this.readOnlyInstance = this.asReadOnly();
        }
        return this.readOnlyInstance;
    }

    protected Point2d(boolean readOnly, double x, double y) {
        super(readOnly, x, y);
    }

    protected Point2d(boolean readOnly, double[] values, boolean[] isDirty, boolean copy) {
        super(readOnly, values, isDirty, copy);
    }

    protected Point2d(boolean readOnly, Tuple2d tuple) {
        this(readOnly, tuple.getX(), tuple.getY());
    }

    protected Point2d(boolean readOnly) {
        this(readOnly, 0.0, 0.0);
    }

    public Point2d(double x, double y) {
        this(false, x, y);
    }

    public Point2d(double[] values) {
        this(false, values, null, true);
    }

    public Point2d(Tuple2d tuple) {
        this(false, tuple);
    }

    public Point2d() {
        this(false);
    }

    public static Point2d newReadOnly(double x, double y) {
        return new Point2d(true, x, y);
    }

    public static Point2d newReadOnly(double[] values) {
        return new Point2d(true, values, null, true);
    }

    public static Point2d newReadOnly(Tuple2d tuple) {
        return new Point2d(true, tuple);
    }

    public static Point2d newReadOnly() {
        return new Point2d(true);
    }

    public static Point2d fromPool() {
        return POOL.get().alloc();
    }

    public static Point2d fromPool(double x, double y) {
        return POOL.get().alloc(x, y);
    }

    public static Point2d fromPool(Tuple2d tuple) {
        return Point2d.fromPool(tuple.getX(), tuple.getY());
    }

    public static void toPool(Point2d o) {
        POOL.get().free(o);
    }

    public static /* bridge */ /* synthetic */ Tuple2d newReadOnly() {
        return Point2d.newReadOnly();
    }

    public static /* bridge */ /* synthetic */ Tuple2d newReadOnly(Tuple2d tuple2d) {
        return Point2d.newReadOnly(tuple2d);
    }

    public static /* bridge */ /* synthetic */ Tuple2d newReadOnly(double[] dArray) {
        return Point2d.newReadOnly(dArray);
    }

    public static /* bridge */ /* synthetic */ Tuple2d newReadOnly(double d, double d2) {
        return Point2d.newReadOnly(d, d2);
    }

    public static /* bridge */ /* synthetic */ Tuple2d fromPool(Tuple2d tuple2d) {
        return Point2d.fromPool(tuple2d);
    }

    public static /* bridge */ /* synthetic */ Tuple2d fromPool(double d, double d2) {
        return Point2d.fromPool(d, d2);
    }

    public static /* bridge */ /* synthetic */ Tuple2d fromPool() {
        return Point2d.fromPool();
    }
}

