/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.vecmath2;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;
import org.openmali.vecmath2.pools.Ray3fPool;

public class Ray3f
implements Externalizable {
    private static final long serialVersionUID = 5553385662401846014L;
    private static final ThreadLocal<Ray3fPool> POOL = new ThreadLocal<Ray3fPool>(){

        @Override
        protected Ray3fPool initialValue() {
            return new Ray3fPool(128);
        }
    };
    private final Point3f origin;
    private final Vector3f direction;

    public final boolean isReadOnly() {
        return this.direction.isReadOnly();
    }

    public final boolean setClean() {
        boolean oldValue = this.isDirty();
        this.origin.setClean();
        this.direction.setClean();
        return oldValue;
    }

    public final boolean isDirty() {
        return this.origin.isDirty() || this.direction.isDirty();
    }

    public final void setZero() {
        this.origin.setZero();
        this.direction.setZero();
    }

    public final Ray3f setOrigin(float x, float y, float z) {
        this.origin.set(x, y, z);
        return this;
    }

    public final Ray3f setOrigin(Tuple3f origin) {
        return this.setOrigin(origin.getX(), origin.getY(), origin.getZ());
    }

    public final Point3f getOrigin() {
        return this.origin;
    }

    public final Ray3f setDirection(float x, float y, float z) {
        this.direction.set(x, y, z);
        return this;
    }

    public final Ray3f setDirection(Tuple3f direction) {
        return this.setDirection(direction.getX(), direction.getY(), direction.getZ());
    }

    public final Vector3f getDirection() {
        return this.direction;
    }

    public final float getLengthSquared() {
        return this.direction.lengthSquared();
    }

    public final float lengthSquared() {
        return this.direction.lengthSquared();
    }

    public final float getLength() {
        return this.direction.length();
    }

    public final float length() {
        return this.direction.length();
    }

    public Ray3f clone() {
        return new Ray3f(this);
    }

    public final Ray3f set(float ox, float oy, float oz, float dx, float dy, float dz) {
        this.origin.set(ox, oy, oz);
        this.direction.set(dx, dy, dz);
        return this;
    }

    public final Ray3f set(Tuple3f origin, Vector3f direction) {
        this.origin.set((TupleNf)origin);
        this.direction.set((TupleNf)direction);
        return this;
    }

    public final Ray3f set(Ray3f ray) {
        return this.set(ray.getOrigin(), ray.getDirection());
    }

    public boolean equals(Ray3f ray) {
        return ((TupleNf)this.origin).equals(ray.origin) && ((TupleNf)this.direction).equals(ray.direction);
    }

    public boolean equals(Object o) {
        if (o instanceof Ray3f) {
            return this.equals((Ray3f)o);
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + ": " + "origin=(" + this.origin.getX() + ", " + this.origin.getY() + ", " + this.origin.getZ() + "), " + "direction=(" + this.direction.getX() + ", " + this.direction.getY() + ", " + this.direction.getZ() + ")";
    }

    public int serialize(int pos, byte[] buffer) {
        this.origin.serialize(pos, buffer);
        this.direction.serialize(pos += this.origin.getSerializationBufferSize(), buffer);
        return pos += this.direction.getSerializationBufferSize();
    }

    public int deserialize(int pos, byte[] buffer) {
        this.origin.deserialize(pos, buffer);
        this.direction.deserialize(pos += this.origin.getSerializationBufferSize(), buffer);
        return pos += this.direction.getSerializationBufferSize();
    }

    protected int getSerializationBufferSize() {
        return this.origin.getSerializationBufferSize() + this.direction.getSerializationBufferSize();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        byte[] buffer = new byte[this.getSerializationBufferSize()];
        this.serialize(0, buffer);
        out.write(buffer);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte[] buffer = new byte[this.getSerializationBufferSize()];
        in.read(buffer);
        this.deserialize(0, buffer);
    }

    protected Ray3f(boolean readOnly, float origX, float origY, float origZ, float direcX, float direcY, float direcZ) {
        this.origin = new Point3f(readOnly, origX, origY, origZ);
        this.direction = new Vector3f(readOnly, direcX, direcY, direcZ);
    }

    protected Ray3f(boolean readOnly, Point3f origin, Vector3f direction) {
        this(readOnly, origin.getX(), origin.getY(), origin.getZ(), direction.getX(), direction.getY(), direction.getZ());
    }

    protected Ray3f(boolean readOnly) {
        this(readOnly, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    protected Ray3f(boolean readOnly, Ray3f template) {
        this(readOnly, template.getOrigin(), template.getDirection());
    }

    public Ray3f(float origX, float origY, float origZ, float direcX, float direcY, float direcZ) {
        this(false, origX, origY, origZ, direcX, direcY, direcZ);
    }

    public Ray3f(Point3f origin, Vector3f direction) {
        this(false, origin, direction);
    }

    public Ray3f() {
        this(false);
    }

    public Ray3f(Ray3f template) {
        this(false, template);
    }

    public static Ray3f newReadOnly(float origX, float origY, float origZ, float direcX, float direcY, float direcZ) {
        return new Ray3f(true, origX, origY, origZ, direcX, direcY, direcZ);
    }

    public static Ray3f newReadOnly(Point3f origin, Vector3f direction) {
        return new Ray3f(true, origin, direction);
    }

    public static Ray3f newReadOnly() {
        return new Ray3f(true);
    }

    public static Ray3f newReadOnly(Ray3f template) {
        return new Ray3f(true, template);
    }

    public static Ray3f fromPool() {
        return POOL.get().alloc();
    }

    public static Ray3f fromPool(float ox, float oy, float oz, float dx, float dy, float dz) {
        return POOL.get().alloc(ox, oy, oz, dx, dy, dz);
    }

    public static Ray3f fromPool(Tuple3f origin, Vector3f direction) {
        return POOL.get().alloc(origin, direction);
    }

    public static Ray3f fromPool(Ray3f ray) {
        return Ray3f.fromPool(ray.getOrigin(), ray.getDirection());
    }

    public static void toPool(Ray3f o) {
        POOL.get().free(o);
    }
}

