/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.vecmath2;

import org.openmali.vecmath2.TupleNi;
import org.openmali.vecmath2.pools.Tuple2iPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tuple2i
extends TupleNi<Tuple2i> {
    private static final long serialVersionUID = 586023996166921455L;
    private static final ThreadLocal<Tuple2iPool> POOL = new ThreadLocal<Tuple2iPool>(){

        @Override
        protected Tuple2iPool initialValue() {
            return new Tuple2iPool(128);
        }
    };
    private Tuple2i readOnlyInstance = null;

    public final Tuple2i setX(int x) {
        this.setValue(0, x);
        return this;
    }

    public final Tuple2i setY(int y) {
        this.setValue(1, y);
        return this;
    }

    public final int getX() {
        return this.getValue(0);
    }

    public final int getY() {
        return this.getValue(1);
    }

    public final Tuple2i x(int x) {
        this.setValue(0, x);
        return this;
    }

    public final Tuple2i y(int y) {
        this.setValue(1, y);
        return this;
    }

    public final int x() {
        return this.getValue(0);
    }

    public final int y() {
        return this.getValue(1);
    }

    public final Tuple2i set(int x, int y) {
        this.setX(x);
        this.setY(y);
        return this;
    }

    public final Tuple2i addX(int v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] + v;
        this.isDirty[0] = true;
        return this;
    }

    public final Tuple2i addY(int v) {
        int n = this.roTrick + 1;
        this.values[n] = this.values[n] + v;
        this.isDirty[0] = true;
        return this;
    }

    @Override
    public final Tuple2i add(int x, int y) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] + x;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] + y;
        this.isDirty[0] = true;
        return this;
    }

    public final Tuple2i subX(int v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] - v;
        this.isDirty[0] = true;
        return this;
    }

    public final Tuple2i subY(int v) {
        int n = this.roTrick + 1;
        this.values[n] = this.values[n] - v;
        this.isDirty[0] = true;
        return this;
    }

    @Override
    public final Tuple2i sub(int x, int y) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] - x;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] - y;
        this.isDirty[0] = true;
        return this;
    }

    public final Tuple2i mulX(int v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] * v;
        this.isDirty[0] = true;
        return this;
    }

    public final Tuple2i mulY(int v) {
        int n = this.roTrick + 1;
        this.values[n] = this.values[n] * v;
        this.isDirty[0] = true;
        return this;
    }

    public final Tuple2i mul(int vx, int vy) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] * vx;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] * vy;
        this.isDirty[0] = true;
        return this;
    }

    public final Tuple2i divX(int v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] / v;
        this.isDirty[0] = true;
        return this;
    }

    public final Tuple2i divY(int v) {
        int n = this.roTrick + 1;
        this.values[n] = this.values[n] / v;
        this.isDirty[0] = true;
        return this;
    }

    public final Tuple2i div(int vx, int vy) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] / vx;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] / vy;
        this.isDirty[0] = true;
        return this;
    }

    @Override
    public final Tuple2i scale(int factorX, int factorY) {
        this.mul(factorX, factorY);
        return this;
    }

    @Override
    public Tuple2i asReadOnly() {
        return new Tuple2i(true, this.values, this.isDirty, false);
    }

    @Override
    public Tuple2i getReadOnly() {
        if (this.readOnlyInstance == null) {
            this.readOnlyInstance = this.asReadOnly();
        }
        return this.readOnlyInstance;
    }

    @Override
    public int hashCode() {
        return this.values[0] ^ this.values[1];
    }

    @Override
    public boolean equals(Tuple2i tuple2) {
        int i = 0;
        while (i < this.N) {
            if (tuple2.getValue(i) != this.getValue(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean equals(Object tuple2) {
        return tuple2 != null && tuple2 instanceof Tuple2i && this.equals((Tuple2i)tuple2);
    }

    @Override
    public String toString() {
        return "(" + this.getValue(0) + ", " + this.getValue(1) + ")";
    }

    public Tuple2i clone() {
        return new Tuple2i(this);
    }

    protected Tuple2i(boolean readOnly, int x, int y) {
        super(readOnly, 2);
        this.values[0] = x;
        this.values[1] = y;
    }

    protected Tuple2i(boolean readOnly, int[] values, boolean[] isDirty, boolean copy) {
        super(readOnly, values, isDirty, 2, copy);
    }

    protected Tuple2i(boolean readOnly, Tuple2i that) {
        super(readOnly, that);
    }

    protected Tuple2i(boolean readOnly) {
        this(readOnly, 0, 0);
    }

    public Tuple2i(int x, int y) {
        this(false, x, y);
    }

    public Tuple2i(int[] values) {
        this(false, values, null, true);
    }

    public Tuple2i(Tuple2i that) {
        this(false, that);
    }

    public Tuple2i() {
        this(false, 0, 0);
    }

    public static Tuple2i newReadOnly(int x, int y) {
        return new Tuple2i(true, x, y);
    }

    public static Tuple2i newReadOnly(int[] values) {
        return new Tuple2i(true, values, null, true);
    }

    public static Tuple2i newReadOnly(Tuple2i tuple) {
        return new Tuple2i(true, tuple);
    }

    public static Tuple2i newReadOnly() {
        return new Tuple2i(true);
    }

    public static Tuple2i fromPool() {
        return POOL.get().alloc();
    }

    public static Tuple2i fromPool(int x, int y) {
        return POOL.get().alloc(x, y);
    }

    public static Tuple2i fromPool(Tuple2i tuple) {
        return Tuple2i.fromPool(tuple.getX(), tuple.getY());
    }

    public static void toPool(Tuple2i o) {
        POOL.get().free(o);
    }
}

