/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.vecmath2;

import java.io.Externalizable;
import org.openmali.FastMathd;
import org.openmali.vecmath2.Tuple3d;
import org.openmali.vecmath2.pools.Vector3dPool;

public class Vector3d
extends Tuple3d
implements Externalizable {
    private static final long serialVersionUID = -8110150970595936075L;
    public static final Vector3d ZERO = Vector3d.newReadOnly(0.0, 0.0, 0.0);
    public static final Vector3d POSITIVE_X_AXIS = Vector3d.newReadOnly(1.0, 0.0, 0.0);
    public static final Vector3d NEGATIVE_X_AXIS = Vector3d.newReadOnly(-1.0, 0.0, 0.0);
    public static final Vector3d POSITIVE_Y_AXIS = Vector3d.newReadOnly(0.0, 1.0, 0.0);
    public static final Vector3d NEGATIVE_Y_AXIS = Vector3d.newReadOnly(0.0, -1.0, 0.0);
    public static final Vector3d POSITIVE_Z_AXIS = Vector3d.newReadOnly(0.0, 0.0, 1.0);
    public static final Vector3d NEGATIVE_Z_AXIS = Vector3d.newReadOnly(0.0, 0.0, -1.0);
    private static final ThreadLocal<Vector3dPool> POOL = new ThreadLocal<Vector3dPool>(){

        @Override
        protected Vector3dPool initialValue() {
            return new Vector3dPool(128);
        }
    };
    private Vector3d readOnlyInstance = null;

    public final double lengthSquared() {
        double result = 0.0;
        int i = 0;
        while (i < this.getSize()) {
            result += this.getValue(i) * this.getValue(i);
            ++i;
        }
        return result;
    }

    public final double length() {
        return FastMathd.sqrt(this.lengthSquared());
    }

    public final Vector3d normalize() {
        double l = this.length();
        this.divX(l);
        this.divY(l);
        this.divZ(l);
        return this;
    }

    public final Vector3d normalize(Vector3d vector) {
        this.set(vector);
        this.normalize();
        return this;
    }

    public final Vector3d cross(Vector3d v1, Vector3d v2) {
        this.set(v1.getY() * v2.getZ() - v1.getZ() * v2.getY(), v1.getZ() * v2.getX() - v1.getX() * v2.getZ(), v1.getX() * v2.getY() - v1.getY() * v2.getX());
        return this;
    }

    public final double dot(Vector3d v2) {
        return this.getX() * v2.getX() + this.getY() * v2.getY() + this.getZ() * v2.getZ();
    }

    public final double angle(Vector3d v2) {
        double vDot = this.dot(v2) / (this.length() * v2.length());
        if (vDot < -1.0) {
            vDot = -1.0;
        }
        if (vDot > 1.0) {
            vDot = 1.0;
        }
        return FastMathd.acos(vDot);
    }

    public Vector3d asReadOnly() {
        return new Vector3d(true, this.values, this.isDirty, false);
    }

    public Vector3d getReadOnly() {
        if (this.readOnlyInstance == null) {
            this.readOnlyInstance = this.asReadOnly();
        }
        return this.readOnlyInstance;
    }

    protected Vector3d(boolean readOnly, double x, double y, double z) {
        super(readOnly, x, y, z);
    }

    protected Vector3d(boolean readOnly, double[] values, boolean[] isDirty, boolean copy) {
        super(readOnly, values, isDirty, copy);
    }

    protected Vector3d(boolean readOnly, Tuple3d tuple) {
        this(readOnly, tuple.getX(), tuple.getY(), tuple.getZ());
    }

    protected Vector3d(boolean readOnly) {
        this(readOnly, 0.0, 0.0, 0.0);
    }

    public Vector3d(double x, double y, double z) {
        this(false, x, y, z);
    }

    public Vector3d(double[] values) {
        this(false, values, null, true);
    }

    public Vector3d(Tuple3d tuple) {
        this(false, tuple);
    }

    public Vector3d() {
        this(false);
    }

    public static Vector3d newReadOnly(double x, double y, double z) {
        return new Vector3d(true, x, y, z);
    }

    public static Vector3d newReadOnly(double[] values) {
        return new Vector3d(true, values, null, true);
    }

    public static Vector3d newReadOnly(Tuple3d tuple) {
        return new Vector3d(true, tuple);
    }

    public static Vector3d newReadOnly() {
        return new Vector3d(true);
    }

    public static Vector3d fromPool() {
        return POOL.get().alloc();
    }

    public static Vector3d fromPool(double x, double y, double z) {
        return POOL.get().alloc(x, y, z);
    }

    public static Vector3d fromPool(Tuple3d tuple) {
        return Vector3d.fromPool(tuple.getX(), tuple.getY(), tuple.getZ());
    }

    public static void toPool(Vector3d o) {
        POOL.get().free(o);
    }

    public static /* bridge */ /* synthetic */ Tuple3d newReadOnly() {
        return Vector3d.newReadOnly();
    }

    public static /* bridge */ /* synthetic */ Tuple3d newReadOnly(Tuple3d tuple3d) {
        return Vector3d.newReadOnly(tuple3d);
    }

    public static /* bridge */ /* synthetic */ Tuple3d newReadOnly(double[] dArray) {
        return Vector3d.newReadOnly(dArray);
    }

    public static /* bridge */ /* synthetic */ Tuple3d newReadOnly(double d, double d2, double d3) {
        return Vector3d.newReadOnly(d, d2, d3);
    }

    public static /* bridge */ /* synthetic */ Tuple3d fromPool(Tuple3d tuple3d) {
        return Vector3d.fromPool(tuple3d);
    }

    public static /* bridge */ /* synthetic */ Tuple3d fromPool(double d, double d2, double d3) {
        return Vector3d.fromPool(d, d2, d3);
    }

    public static /* bridge */ /* synthetic */ Tuple3d fromPool() {
        return Vector3d.fromPool();
    }
}

