/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.vecmath2;

import java.io.Externalizable;
import org.openmali.FastMath;
import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;
import org.openmali.vecmath2.VectorInterface;
import org.openmali.vecmath2.VectorNf;
import org.openmali.vecmath2.pools.Vector4fPool;
import org.openmali.vecmath2.util.VecMathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Vector4f
extends VectorNf
implements Externalizable,
VectorInterface<VectorNf, VectorNf> {
    private static final long serialVersionUID = 378659999358250332L;
    public static final Vector4f ZERO = Vector4f.newReadOnly(0.0f, 0.0f, 0.0f, 0.0f);
    private static final ThreadLocal<Vector4fPool> POOL = new ThreadLocal<Vector4fPool>(){

        @Override
        protected Vector4fPool initialValue() {
            return new Vector4fPool(128);
        }
    };
    private Vector4f readOnlyInstance = null;

    public final Vector4f setX(float x) {
        this.setValue(0, x);
        return this;
    }

    public final Vector4f setY(float y) {
        this.setValue(1, y);
        return this;
    }

    public final Vector4f setZ(float z) {
        this.setValue(2, z);
        return this;
    }

    public final Vector4f setW(float w) {
        this.setValue(3, w);
        return this;
    }

    public final float getX() {
        return this.getValue(0);
    }

    public final float getY() {
        return this.getValue(1);
    }

    public final float getZ() {
        return this.getValue(2);
    }

    public final float getW() {
        return this.getValue(3);
    }

    public final Vector4f set(float x, float y, float z, float w) {
        this.setX(x);
        this.setY(y);
        this.setZ(z);
        this.setW(w);
        return this;
    }

    public final Vector4f set(Vector3f v, float w) {
        this.setX(v.getX());
        this.setY(v.getY());
        this.setZ(v.getZ());
        this.setW(w);
        return this;
    }

    public final Vector4f addX(float v) {
        this.addValue(0, v);
        return this;
    }

    public final Vector4f addY(float v) {
        this.addValue(1, v);
        return this;
    }

    public final Vector4f addZ(float v) {
        this.addValue(2, v);
        return this;
    }

    public final Vector4f addW(float w) {
        this.addValue(3, w);
        return this;
    }

    public final Vector4f add(float x, float y, float z, float w) {
        this.addX(x);
        this.addY(y);
        this.addZ(z);
        this.addW(w);
        return this;
    }

    public final Vector4f subX(float v) {
        this.subValue(0, v);
        return this;
    }

    public final Vector4f subY(float v) {
        this.subValue(1, v);
        return this;
    }

    public final Vector4f subZ(float v) {
        this.subValue(2, v);
        return this;
    }

    public final Vector4f subW(float v) {
        this.subValue(3, v);
        return this;
    }

    public final Vector4f sub(float x, float y, float z, float w) {
        this.subX(x);
        this.subY(y);
        this.subZ(z);
        this.subW(w);
        return this;
    }

    public final Vector4f mulX(float v) {
        this.mulValue(0, v);
        return this;
    }

    public final Vector4f mulY(float v) {
        this.mulValue(1, v);
        return this;
    }

    public final Vector4f mulZ(float v) {
        this.mulValue(2, v);
        return this;
    }

    public final Vector4f mulW(float v) {
        this.mulValue(3, v);
        return this;
    }

    public final Vector4f mul(float vx, float vy, float vz, float vw) {
        this.mulValue(0, vx);
        this.mulValue(1, vy);
        this.mulValue(2, vz);
        this.mulValue(3, vw);
        return this;
    }

    public final Vector4f scale(float factorX, float factorY, float factorZ, float factorW) {
        this.mul(factorX, factorY, factorZ, factorW);
        return this;
    }

    public final Vector4f divX(float v) {
        this.divValue(0, v);
        return this;
    }

    public final Vector4f divY(float v) {
        this.divValue(1, v);
        return this;
    }

    public final Vector4f divZ(float v) {
        this.divValue(2, v);
        return this;
    }

    public final Vector4f divW(float v) {
        this.divValue(3, v);
        return this;
    }

    public final Vector4f div(float vx, float vy, float vz, float vw) {
        this.divValue(0, vx);
        this.divValue(1, vy);
        this.divValue(2, vz);
        this.divValue(3, vw);
        return this;
    }

    public final Vector4f set(Tuple3f tuple) {
        this.set(tuple.getValue(0), tuple.getValue(1), tuple.getValue(2), 0.0f);
        return this;
    }

    public final void get(Tuple3f buffer) {
        buffer.set(this.getValue(0), this.getValue(1), this.getValue(2));
    }

    @Override
    public final Vector4f sub(Tuple3f tuple1, Tuple3f tuple2) {
        int i = 0;
        while (i < tuple2.getSize()) {
            this.setValue(i, tuple1.getValue(i) - tuple2.getValue(i));
            ++i;
        }
        this.setValue(3, 0.0f);
        return this;
    }

    @Override
    public final Vector4f sub(Tuple3f tuple2) {
        int i = 0;
        while (i < tuple2.getSize()) {
            this.setValue(i, -tuple2.getValue(i));
            ++i;
        }
        return this;
    }

    public final Vector4f cross(Vector4f v1, Vector4f v2) {
        this.set(v1.getY() * v2.getZ() - v1.getZ() * v2.getY(), v1.getZ() * v2.getW() - v1.getW() * v2.getZ(), v1.getW() * v2.getX() - v1.getX() * v2.getW(), v1.getX() * v2.getY() - v1.getY() * v2.getX());
        return this;
    }

    public final float lengthSquared3() {
        float result = 0.0f;
        int i = 0;
        while (i < 3) {
            result += this.getValue(i) * this.getValue(i);
            ++i;
        }
        return result;
    }

    public final float length3() {
        return FastMath.sqrt(this.lengthSquared3());
    }

    public final float distanceL1(VectorNf v2) {
        float result = 0.0f;
        int i = 0;
        while (i < this.getSize()) {
            result += Math.abs(this.getValue(i) - v2.getValue(i));
            ++i;
        }
        return result;
    }

    public static TupleNf<?> getLinearHyperPlaneNormal(TupleNf<?> p1, TupleNf<?> p2, TupleNf<?> p3, TupleNf<?> normal) {
        Matrix3f A = Matrix3f.fromPool();
        Matrix3f Atmp = Matrix3f.fromPool();
        Vector3f B = Vector3f.fromPool();
        Vector3f tmp = Vector3f.fromPool();
        A.set(0, 0, p1.getValue(0));
        A.set(0, 1, p1.getValue(1));
        A.set(0, 2, p1.getValue(2));
        A.set(1, 0, p2.getValue(0));
        A.set(1, 1, p2.getValue(1));
        A.set(1, 2, p2.getValue(2));
        A.set(2, 0, p3.getValue(0));
        A.set(2, 1, p3.getValue(1));
        A.set(2, 2, p3.getValue(2));
        B.setValue(0, p1.getValue(3));
        B.setValue(1, p2.getValue(3));
        B.setValue(2, p3.getValue(3));
        int minus1Assumption = 3;
        int i = 0;
        while (i < 4) {
            tmp.set((TupleNf)B);
            Atmp.set(A);
            A.solve(B, normal);
            if (--minus1Assumption == -1) break;
            A.set(Atmp);
            A.getColumn(minus1Assumption, B);
            A.setColumn(minus1Assumption, tmp);
            ++i;
        }
        if (minus1Assumption == -1) {
            normal.fill(Float.NaN);
        } else {
            i = 3;
            while (i > minus1Assumption) {
                normal.setValue(i, normal.getValue(i - 1));
                --i;
            }
            normal.setValue(minus1Assumption, -1.0f);
            normal.scale(-1.0f);
            VecMathUtils.normalize(normal);
        }
        Matrix3f.toPool(A);
        Matrix3f.toPool(Atmp);
        Vector3f.toPool(B);
        Vector3f.toPool(tmp);
        return normal;
    }

    public final void getLinearHyperPlaneNormal(TupleNf<?> p1, TupleNf<?> p2, TupleNf<?> p3) {
        Vector4f.getLinearHyperPlaneNormal(p1, p2, p3, this);
    }

    public final float distanceLinf(VectorNf v2) {
        float result = 0.0f;
        int i = 0;
        while (i < this.getSize()) {
            result += Math.max(Math.abs(this.getValue(i) - v2.getValue(i)), result);
            ++i;
        }
        return result;
    }

    @Override
    public Vector4f asReadOnly() {
        return new Vector4f(true, this.values, this.isDirty, false);
    }

    @Override
    public Vector4f getReadOnly() {
        if (this.readOnlyInstance == null) {
            this.readOnlyInstance = this.asReadOnly();
        }
        return this.readOnlyInstance;
    }

    @Override
    public boolean equals(Object o) {
        return o != null && o instanceof Vector4f && ((TupleNf)this).equals((Vector4f)o);
    }

    @Override
    public Vector4f clone() {
        return new Vector4f(this);
    }

    protected Vector4f(boolean readOnly, float x, float y, float z, float w) {
        super(readOnly, 4);
        this.values[0] = x;
        this.values[1] = y;
        this.values[2] = z;
        this.values[3] = w;
    }

    protected Vector4f(boolean readOnly, float[] values, boolean[] isDirty, boolean copy) {
        super(readOnly, values, isDirty, copy);
    }

    protected Vector4f(boolean readOnly, Vector4f vec) {
        super(readOnly, vec);
    }

    protected Vector4f(boolean readOnly) {
        this(readOnly, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public Vector4f(float x, float y, float z, float w) {
        this(false, x, y, z, w);
    }

    public Vector4f(float[] values) {
        this(false, values, null, true);
    }

    public Vector4f(Vector4f vec) {
        this(false, vec);
    }

    public Vector4f() {
        this(false);
    }

    public static Vector4f newReadOnly(float x, float y, float z, float w) {
        return new Vector4f(true, x, y, z, w);
    }

    public static Vector4f newReadOnly(float[] values) {
        return new Vector4f(true, values, null, true);
    }

    public static Vector4f newReadOnly(Vector4f vec) {
        return new Vector4f(true, vec);
    }

    public static Vector4f newReadOnly() {
        return new Vector4f(true);
    }

    public static Vector4f fromPool() {
        return POOL.get().alloc();
    }

    public static Vector4f fromPool(float x, float y, float z, float w) {
        return POOL.get().alloc(x, y, z, w);
    }

    public static Vector4f fromPool(Vector4f tuple) {
        return Vector4f.fromPool(tuple.getX(), tuple.getY(), tuple.getZ(), tuple.getW());
    }

    public static void toPool(Vector4f o) {
        POOL.get().free(o);
    }

    public static /* bridge */ /* synthetic */ VectorNf newReadOnly(float[] fArray) {
        return Vector4f.newReadOnly(fArray);
    }
}

