/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.vecmath2.util;

import org.openmali.vecmath2.Colord;
import org.openmali.vecmath2.Colorf;

public final class ColorUtils {
    public static final int hexToInt(char ch) {
        if (ch >= 'A' && ch <= 'Z') {
            return ch - 55;
        }
        if (ch >= 'a' && ch <= 'z') {
            return ch - 87;
        }
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        return -1;
    }

    private static final int calcColorComp(String str, int start) {
        int h = ColorUtils.hexToInt(str.charAt(start + 0));
        int l = ColorUtils.hexToInt(str.charAt(start + 1));
        if (h == -1 || l == -1) {
            throw new IllegalArgumentException("given hex string is not valid");
        }
        return h * 16 + l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final int checkHexString(String hexStr) {
        if (hexStr == null) {
            throw new NullPointerException("hexStr");
        }
        int type = -1;
        if (hexStr.startsWith("#")) {
            if (hexStr.length() == 7) {
                return 1;
            }
            if (hexStr.length() != 9) throw new IllegalArgumentException("Illegal hex-string.");
            return 3;
        }
        if (hexStr.length() == 6) {
            return 0;
        }
        if (hexStr.length() != 8) throw new IllegalArgumentException("Illegal hex-string.");
        return 2;
    }

    public static final boolean hexToColor(String hexStr, float[] buffer) {
        int start;
        int type = ColorUtils.checkHexString(hexStr);
        int n = start = (type & 1) != 0 ? 1 : 0;
        if ((type & 2) != 0 && buffer.length < 4) {
            throw new IllegalArgumentException("buffer too small");
        }
        int j = 0;
        int i = start;
        while (i < hexStr.length()) {
            buffer[j] = (float)ColorUtils.calcColorComp(hexStr, start + j * 2) / 255.0f;
            i += 2;
            ++j;
        }
        if ((type & 2) != 0) {
            return true;
        }
        if (buffer.length >= 4) {
            buffer[3] = -1.0f;
        }
        return true;
    }

    public static final Colorf hexToColor(String hexStr, Colorf out) {
        int type = ColorUtils.checkHexString(hexStr);
        int start = (type & 1) != 0 ? 1 : 0;
        out.setRed((float)ColorUtils.calcColorComp(hexStr, start + 0) / 255.0f);
        out.setGreen((float)ColorUtils.calcColorComp(hexStr, start + 2) / 255.0f);
        out.setBlue((float)ColorUtils.calcColorComp(hexStr, start + 4) / 255.0f);
        if ((type & 2) != 0) {
            out.setAlpha((float)ColorUtils.calcColorComp(hexStr, start + 6) / 255.0f);
        } else {
            out.setAlpha(-1.0f);
        }
        return out;
    }

    public static final Colorf hexToColor(String hexStr) {
        float[] values = new float[4];
        values[3] = -1.0f;
        ColorUtils.hexToColor(hexStr, values);
        return new Colorf(values);
    }

    private static final String pad2(String s) {
        if (s.length() >= 2) {
            return s;
        }
        int i = s.length();
        while (i < 2) {
            s = "0" + s;
            ++i;
        }
        return s;
    }

    public static final String colorToHex(Colorf color) {
        if (color == null) {
            throw new NullPointerException("color");
        }
        String value = "#";
        value = String.valueOf(value) + ColorUtils.pad2(Integer.toHexString(color.getRedInt()).toUpperCase());
        value = String.valueOf(value) + ColorUtils.pad2(Integer.toHexString(color.getGreenInt()).toUpperCase());
        value = String.valueOf(value) + ColorUtils.pad2(Integer.toHexString(color.getBlueInt()).toUpperCase());
        if (color.hasAlpha()) {
            value = String.valueOf(value) + ColorUtils.pad2(Integer.toHexString(color.getAlphaInt()).toUpperCase());
        }
        return value;
    }

    public static String colorToHex(Colord color) {
        if (color == null) {
            throw new NullPointerException("color");
        }
        String value = "#";
        value = String.valueOf(value) + ColorUtils.pad2(Integer.toHexString(color.getRedInt()).toUpperCase());
        value = String.valueOf(value) + ColorUtils.pad2(Integer.toHexString(color.getGreenInt()).toUpperCase());
        value = String.valueOf(value) + ColorUtils.pad2(Integer.toHexString(color.getBlueInt()).toUpperCase());
        if (color.hasAlpha()) {
            value = String.valueOf(value) + ColorUtils.pad2(Integer.toHexString(color.getAlphaInt()).toUpperCase());
        }
        return value;
    }

    public static final boolean hexToColor(String hexStr, double[] buffer) {
        int start;
        int type = ColorUtils.checkHexString(hexStr);
        int n = start = (type & 1) != 0 ? 1 : 0;
        if ((type & 2) != 0 && buffer.length < 4) {
            throw new IllegalArgumentException("buffer too small");
        }
        int j = 0;
        int i = start;
        while (i < hexStr.length()) {
            buffer[j] = (double)ColorUtils.calcColorComp(hexStr, start + j * 2) / 255.0;
            i += 2;
            ++j;
        }
        if ((type & 2) != 0) {
            return true;
        }
        if (buffer.length >= 4) {
            buffer[3] = -1.0;
        }
        return true;
    }

    public static final Colord hexToColor(String hexStr, Colord out) {
        int type = ColorUtils.checkHexString(hexStr);
        int start = (type & 1) != 0 ? 1 : 0;
        out.setRed((double)ColorUtils.calcColorComp(hexStr, start + 0) / 255.0);
        out.setGreen((double)ColorUtils.calcColorComp(hexStr, start + 2) / 255.0);
        out.setBlue((double)ColorUtils.calcColorComp(hexStr, start + 4) / 255.0);
        if ((type & 2) != 0) {
            out.setAlpha((double)ColorUtils.calcColorComp(hexStr, start + 6) / 255.0);
        } else {
            out.setAlpha(-1.0);
        }
        return out;
    }

    public static final Colord hexToColord(String hexStr) {
        double[] values = new double[4];
        values[3] = -1.0;
        ColorUtils.hexToColor(hexStr, values);
        return new Colord(values);
    }

    private ColorUtils() {
    }
}

