/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.vecmath2.util;

import org.openmali.FastMath;
import org.openmali.vecmath2.AxisAngle3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.util.FloatUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TupleUtils {
    private TupleUtils() {
    }

    public static final <T extends Tuple3f> T normalizeVector(T vector) {
        float l = TupleUtils.vectorLength(vector);
        vector.divX(l);
        vector.divY(l);
        vector.divZ(l);
        return vector;
    }

    public static float distanceSquared(Tuple3f a, Tuple3f b) {
        float dx = a.getX() - b.getX();
        float dy = a.getY() - b.getY();
        float dz = a.getZ() - b.getZ();
        return dx * dx + dy * dy + dz * dz;
    }

    public static final float vectorLengthSquared(Tuple3f v) {
        return FloatUtils.vectorLengthSquared(v.getX(), v.getY(), v.getZ());
    }

    public static final float vectorLength(Tuple3f v) {
        return FloatUtils.vectorLength(v.getX(), v.getY(), v.getZ());
    }

    public static final <T extends Tuple3f> T cross(Tuple3f v1, Tuple3f v2, T result) {
        result.set(v1.getY() * v2.getZ() - v1.getZ() * v2.getY(), v1.getZ() * v2.getX() - v1.getX() * v2.getZ(), v1.getX() * v2.getY() - v1.getY() * v2.getX());
        return result;
    }

    public static final float dot(Tuple3f v1, Tuple3f v2) {
        return v1.getX() * v2.getX() + v1.getY() * v2.getY() + v1.getZ() * v2.getZ();
    }

    public static final float angle(Tuple3f v1, Tuple3f v2) {
        float vDot = TupleUtils.dot(v1, v2) / (TupleUtils.vectorLength(v1) * TupleUtils.vectorLength(v2));
        if (vDot < -1.0f) {
            vDot = -1.0f;
        }
        if (vDot > 1.0f) {
            vDot = 1.0f;
        }
        return FastMath.acos(vDot);
    }

    public static int compareTuple(Tuple3f ta, Tuple3f tb) {
        if (ta.getX() < tb.getX()) {
            return -1;
        }
        if (ta.getX() > tb.getX()) {
            return 1;
        }
        if (ta.getY() < tb.getY()) {
            return -1;
        }
        if (ta.getY() > tb.getY()) {
            return 1;
        }
        if (ta.getZ() < tb.getZ()) {
            return -1;
        }
        if (ta.getZ() > tb.getZ()) {
            return 1;
        }
        return 0;
    }

    public static boolean limit(Tuple3f tuple, float minx, float miny, float maxx, float maxy) {
        boolean outside = false;
        if (tuple.getX() < minx) {
            tuple.setX(minx);
            outside = true;
        } else if (tuple.getX() > maxx) {
            tuple.setX(maxx);
            outside = true;
        }
        if (tuple.getY() < miny) {
            tuple.setY(miny);
            outside = true;
        } else if (tuple.getY() > maxy) {
            tuple.setY(maxy);
            outside = true;
        }
        return outside;
    }

    public static boolean limit(Tuple3f tuple, float maxx, float maxy) {
        boolean outside = false;
        if (tuple.getX() < 0.0f) {
            tuple.setX(0.0f);
            outside = true;
        } else if (tuple.getX() > maxx) {
            tuple.setX(maxx);
            outside = true;
        }
        if (tuple.getY() < 0.0f) {
            tuple.setY(0.0f);
            outside = true;
        } else if (tuple.getY() > maxy) {
            tuple.setY(maxy);
            outside = true;
        }
        return outside;
    }

    public static final AxisAngle3f computeRotation(Tuple3f v1, Tuple3f v2, int normalize, AxisAngle3f result) {
        if ((normalize & 1) != 0) {
            TupleUtils.normalizeVector(v1);
        }
        if ((normalize & 2) != 0) {
            TupleUtils.normalizeVector(v2);
        }
        TupleUtils.cross(v2, v1, result);
        float angle = FastMath.acos(TupleUtils.dot(v2, v1));
        result.setAngle(angle);
        return result;
    }
}

