/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.collision;

import java.util.ArrayList;
import net.java.dev.joode.Body;
import net.java.dev.joode.ClonedReferences;
import net.java.dev.joode.SimState;
import net.java.dev.joode.World;
import net.java.dev.joode.collision.CollisionListener;
import net.java.dev.joode.collision.Contact;
import net.java.dev.joode.collision.SurfaceParameters;
import net.java.dev.joode.collision.collider.Colliders;
import net.java.dev.joode.force.WorldForce;
import net.java.dev.joode.geom.Geom;
import net.java.dev.joode.joint.JointContact;
import net.java.dev.joode.joint.JointGroupID;
import net.java.dev.joode.space.NearCallback;
import net.java.dev.joode.space.Space;
import net.java.dev.joode.util.JOODELog;
import net.java.dev.joode.util.Vector3;

public class CollisionManager
extends WorldForce
implements NearCallback {
    private static final long serialVersionUID = -5996179951724691638L;
    private World world;
    private Space space;
    private SurfaceParameters params;
    private int numContacts = 0;
    private Contact[] contactBuffer;
    private JointGroupID contactGroup = new JointGroupID();
    private JointContact[] jointContacts;
    private boolean ignoreStaticContacts;
    private final int MAX_CONTACTS;
    private final ArrayList<CollisionListener> listeners = new ArrayList();

    public CollisionManager(World world, Space space, SurfaceParameters defaultSurfaceParameters, boolean ignoreStaticContacts, int MAX_CONTACTS) {
        super(world);
        this.params = defaultSurfaceParameters;
        this.MAX_CONTACTS = MAX_CONTACTS;
        this.ignoreStaticContacts = ignoreStaticContacts;
        this.contactBuffer = new Contact[MAX_CONTACTS];
        this.jointContacts = new JointContact[MAX_CONTACTS];
        int i = 0;
        while (i < MAX_CONTACTS) {
            this.contactBuffer[i] = new Contact(defaultSurfaceParameters, null);
            this.jointContacts[i] = new JointContact(world, null);
            ++i;
        }
        this.setup(world, space);
    }

    public void setup(World world, Space space) {
        if (this.world != null) {
            world.removeForce(this);
        }
        this.world = world;
        this.space = space;
        world.addForce(this);
    }

    private void reset() {
        this.numContacts = 0;
        this.contactGroup.clear();
        this.world.removeJointContacts();
        int i = 0;
        while (i < this.MAX_CONTACTS) {
            this.contactBuffer[i].init();
            this.contactBuffer[i].setSurfaceParameters(this.params);
            ++i;
        }
    }

    private JointContact getFreeContact() {
        int i = 0;
        while (i < this.MAX_CONTACTS) {
            if (!this.jointContacts[i].getFlag(1)) {
                return this.jointContacts[i];
            }
            ++i;
        }
        return null;
    }

    public void call(Object userData, Geom geom1, Geom geom2) {
        if (this.numContacts < this.MAX_CONTACTS) {
            this.numContacts += Colliders.collide(geom1, geom2, this.contactBuffer, this.numContacts, this.ignoreStaticContacts);
        }
    }

    private void applyContacts() {
        int i = 0;
        while (i < this.numContacts) {
            Contact contact = this.contactBuffer[i];
            Geom geom1 = contact.getGeom1();
            Geom geom2 = contact.getGeom2();
            Body body1 = geom1.getBody();
            Body body2 = geom2.getBody();
            if (geom1 == null || geom2 == null) {
                JOODELog.error("Contact buffer corrupted");
            } else if (geom1.getType() != 5 && geom2.getType() != 5) {
                JointContact cj = this.getFreeContact();
                assert (cj != null);
                cj.setWorld(this.world);
                cj.setContact(contact);
                if (this.notifyCollision(cj)) {
                    this.world.addJoint(cj);
                    this.contactGroup.add(cj);
                    if (body1 != null || body2 != null) {
                        cj.attach(body1, body2);
                    }
                }
            }
            ++i;
        }
    }

    public int getContactCount() {
        return this.numContacts;
    }

    public Contact getContact(int i) {
        return this.contactBuffer[i];
    }

    public boolean ignoreStatic() {
        return this.ignoreStaticContacts;
    }

    private void step() {
        int j = 0;
        while (j < this.listeners.size()) {
            this.listeners.get(j).reset();
            ++j;
        }
        this.reset();
        this.space.collideAll(this.world, this);
        this.applyContacts();
    }

    private boolean notifyCollision(JointContact cj) {
        int j = 0;
        while (j < this.listeners.size()) {
            if (!this.listeners.get(j).allowCollision(cj)) {
                return false;
            }
            ++j;
        }
        return true;
    }

    public void prepare(float t) {
        this.step();
    }

    public void applyForce(Body body, float t, Vector3 faccPassback, Vector3 taccPassback) {
    }

    public void addCollisionListener(CollisionListener l) {
        this.listeners.add(l);
    }

    public void removeCollisionListener(CollisionListener l) {
        this.listeners.remove(l);
    }

    public SimState cloneState(ClonedReferences util) {
        return null;
    }

    public void setDefaultCollisionParameters(SurfaceParameters params) {
        this.params = params;
        int i = 0;
        while (i < this.MAX_CONTACTS) {
            this.contactBuffer[i].setSurfaceParameters(params);
            ++i;
        }
    }
}

