/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.collision.collider;

import net.java.dev.joode.collision.ContactGeom;
import net.java.dev.joode.collision.collider.Collider;
import net.java.dev.joode.collision.collider.SphereSphereCollider;
import net.java.dev.joode.geom.Capsule;
import net.java.dev.joode.geom.Geom;
import net.java.dev.joode.geom.Sphere;
import net.java.dev.joode.util.Matrix3;
import net.java.dev.joode.util.Vector3;

public class CapsuleSphereCollider
extends Collider {
    public static final CapsuleSphereCollider INSTANCE = new CapsuleSphereCollider();

    public int collide(Geom o1, Geom o2, ContactGeom[] contact, int contactIndex, int skip) {
        Capsule cyl = (Capsule)o1;
        Sphere sphere = (Sphere)o2;
        contact[contactIndex].setGeom1(o1);
        contact[contactIndex].setGeom2(o2);
        Vector3 cylPos = cyl.getPosition();
        Matrix3 cylRot = cyl.getRotation();
        Vector3 spherePos = sphere.getPosition();
        float alpha = o1.getRotation().get(2, 0) * (o2.getPosition().getX() - cylPos.getX()) + cylRot.get(2, 1) * (spherePos.getY() - cylPos.getY()) + cylRot.get(2, 2) * (spherePos.getZ() - cylPos.getZ());
        float lz2 = cyl.getLength() * 0.5f;
        if (alpha > lz2) {
            alpha = lz2;
        }
        if (alpha < -lz2) {
            alpha = -lz2;
        }
        Vector3 p = new Vector3();
        p.setX(cylPos.getX() + alpha * cylRot.get(2, 0));
        p.setY(cylPos.getY() + alpha * cylRot.get(2, 1));
        p.setZ(cylPos.getZ() + alpha * cylRot.get(2, 2));
        return SphereSphereCollider.collideSpheres(p, cyl.getRadius(), spherePos, sphere.getRadius(), contact, contactIndex, o1.hashCode(), o2.hashCode());
    }
}

