/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.collision.collider;

import net.java.dev.joode.Body;
import net.java.dev.joode.collision.ContactGeom;
import net.java.dev.joode.collision.collider.Collider;
import net.java.dev.joode.collision.collider.Colliders;
import net.java.dev.joode.geom.Geom;
import net.java.dev.joode.geom.GeomTransform;
import net.java.dev.joode.util.Matrix3;
import net.java.dev.joode.util.Vector3;

public class GeomTransformCollider
extends Collider {
    public static GeomTransformCollider INSTANCE = new GeomTransformCollider();

    public int collide(Geom o1, Geom o2, ContactGeom[] contact, int contactIndex, int skip) {
        GeomTransform tr = (GeomTransform)o1;
        Geom geom = tr.getGeom();
        if (geom == null) {
            return 0;
        }
        Vector3 posbak = geom.getPosition();
        Matrix3 Rbak = geom.getRotation();
        Body bodybak = geom.getBody();
        if (tr.getFlag(Geom.GEOM_AABB_BAD)) {
            tr.computeFinalTx();
        }
        geom.setBody(o1.getBody());
        geom.directSetPosition(tr.getFinalPosition());
        geom.directSetRotation(tr.getFinalRotation());
        int n = Colliders.collide(geom, o2, contact, contactIndex, true);
        if (tr.isInfoMode()) {
            int i = 0;
            while (i < n) {
                contact[i + contactIndex].setGeom1(o1);
                ++i;
            }
        }
        geom.setBody(bodybak);
        geom.directSetPosition(posbak);
        geom.directSetRotation(Rbak);
        return n;
    }
}

