/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.collision.collider;

import net.java.dev.joode.collision.ContactGeom;
import net.java.dev.joode.collision.collider.Collider;
import net.java.dev.joode.geom.Box;
import net.java.dev.joode.geom.Geom;
import net.java.dev.joode.geom.Ray;
import net.java.dev.joode.util.MathUtils;
import net.java.dev.joode.util.Matrix3;
import net.java.dev.joode.util.Vector3;

public class RayBoxCollider
extends Collider {
    public static final RayBoxCollider INSTANCE = new RayBoxCollider();

    public int collide(Geom o1, Geom o2, ContactGeom[] contact, int contactIndex, int skip) {
        int n;
        float alpha;
        Ray ray = (Ray)o1;
        Box box = (Box)o2;
        Vector3 rayPos = ray.getPosition();
        Matrix3 rayRot = ray.getRotation();
        Vector3 boxPos = box.getPosition();
        Matrix3 boxRot = box.getRotation();
        contact[contactIndex].setGeom1(ray);
        contact[contactIndex].setGeom2(box);
        Vector3 tmp = new Vector3(rayPos);
        tmp.sub(boxPos);
        Vector3 s = new Vector3();
        MathUtils.dMULTIPLY1_331(s, boxRot, tmp);
        tmp.m[0] = rayRot.m[2];
        tmp.m[1] = rayRot.m[6];
        tmp.m[2] = rayRot.m[10];
        Vector3 v = new Vector3();
        MathUtils.dMULTIPLY1_331(v, boxRot, tmp);
        Vector3 sign = new Vector3();
        int i = 0;
        while (i < 3) {
            if (v.m[i] < 0.0f) {
                s.m[i] = -s.m[i];
                v.m[i] = -v.m[i];
                sign.m[i] = 1.0f;
            } else {
                sign.m[i] = -1.0f;
            }
            ++i;
        }
        Vector3 h = new Vector3(box.getSide());
        h.scale(0.5f);
        if (s.m[0] < -h.m[0] && v.m[0] <= 0.0f || s.m[0] > h.m[0] || s.m[1] < -h.m[1] && v.m[1] <= 0.0f || s.m[1] > h.m[1] || s.m[2] < -h.m[2] && v.m[2] <= 0.0f || s.m[2] > h.m[2] || v.m[0] == 0.0f && v.m[1] == 0.0f && v.m[2] == 0.0f) {
            return 0;
        }
        float lo = -3.4028235E38f;
        float hi = Float.MAX_VALUE;
        int nlo = 0;
        int nhi = 0;
        i = 0;
        while (i < 3) {
            if (v.m[i] != 0.0f) {
                float k = (-h.m[i] - s.m[i]) / v.m[i];
                if (k > lo) {
                    lo = k;
                    nlo = i;
                }
                if ((k = (h.m[i] - s.m[i]) / v.m[i]) < hi) {
                    hi = k;
                    nhi = i;
                }
            }
            ++i;
        }
        if (lo > hi) {
            return 0;
        }
        if (lo >= 0.0f) {
            alpha = lo;
            n = nlo;
        } else {
            alpha = hi;
            n = nhi;
        }
        if (alpha < 0.0f || alpha > ray.getLength()) {
            return 0;
        }
        contact[contactIndex].getPosition().setX(rayPos.getX() + alpha * rayRot.m[2]);
        contact[contactIndex].getPosition().setY(rayPos.getY() + alpha * rayRot.m[6]);
        contact[contactIndex].getPosition().setZ(rayPos.getZ() + alpha * rayRot.m[10]);
        contact[contactIndex].getNormal().setX(boxRot.m[0 + n] * sign.m[n]);
        contact[contactIndex].getNormal().setY(boxRot.m[4 + n] * sign.m[n]);
        contact[contactIndex].getNormal().setZ(boxRot.m[8 + n] * sign.m[n]);
        contact[contactIndex].setDepth(alpha);
        return 1;
    }
}

