/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.collision.collider;

import net.java.dev.joode.collision.ContactGeom;
import net.java.dev.joode.collision.collider.Collider;
import net.java.dev.joode.geom.Circle;
import net.java.dev.joode.geom.Geom;
import net.java.dev.joode.geom.Ray;
import net.java.dev.joode.util.Math2D;
import net.java.dev.joode.util.Matrix3;
import net.java.dev.joode.util.Vector3;

public class RayCircleCollider
extends Collider {
    public static final RayCircleCollider INSTANCE = new RayCircleCollider();

    public int collide(Geom o1, Geom o2, ContactGeom[] contact, int contactIndex, int skip) {
        Ray ray = (Ray)o1;
        Circle circle = (Circle)o2;
        contact[contactIndex].setGeom1(ray);
        contact[contactIndex].setGeom2(circle);
        return RayCircleCollider.ray_circle_helper(ray, circle.getPosition(), circle.getRadius(), contact, contactIndex, false);
    }

    public static int ray_circle_helper(Ray ray, Vector3 circlePos, float radius, ContactGeom[] contact, int contactIndex, boolean mode) {
        float alpha;
        Vector3 rayPos = ray.getPosition();
        Matrix3 rayRot = ray.getRotation();
        float[] q = new float[]{rayPos.getX(), rayPos.getY()};
        float[] cPos = new float[]{circlePos.getX(), circlePos.getY()};
        Math2D.sub(q, cPos, q);
        float[] rayDir = new float[]{rayRot.get(2, 0), rayRot.get(2, 1)};
        float B = Math2D.dot(q, rayDir);
        float C = Math2D.norm(q) * Math2D.norm(q) - radius * radius;
        float k = B * B - C;
        if (k < 0.0f) {
            return 0;
        }
        k = (float)Math.sqrt(k);
        if (mode && C >= 0.0f ? (alpha = -B + k) < 0.0f : (alpha = -B - k) < 0.0f && (alpha = -B + k) < 0.0f) {
            return 0;
        }
        if (alpha > ray.getLength()) {
            return 0;
        }
        contact[contactIndex].getPosition().setX(rayPos.getX() + alpha * rayRot.m[2]);
        contact[contactIndex].getPosition().setY(rayPos.getY() + alpha * rayRot.m[6]);
        contact[contactIndex].getPosition().setZ(0.0f);
        float nsign = C < 0.0f || mode ? -1 : 1;
        contact[contactIndex].getNormal().setX(nsign * (contact[contactIndex].getPosition().getX() - circlePos.getX()));
        contact[contactIndex].getNormal().setY(nsign * (contact[contactIndex].getPosition().getY() - circlePos.getY()));
        contact[contactIndex].getNormal().setZ(0.0f);
        contact[contactIndex].getNormal().normalize();
        contact[contactIndex].setDepth(alpha);
        return 1;
    }
}

