/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.collision.collider;

import net.java.dev.joode.collision.ContactGeom;
import net.java.dev.joode.collision.collider.Collider;
import net.java.dev.joode.geom.Geom;
import net.java.dev.joode.geom.Plane;
import net.java.dev.joode.geom.Ray;
import net.java.dev.joode.util.Matrix3;
import net.java.dev.joode.util.Vector3;

public class RayPlaneCollider
extends Collider {
    public static final RayPlaneCollider INSTANCE = new RayPlaneCollider();

    public int collide(Geom o1, Geom o2, ContactGeom[] contact, int contactIndex, int skip) {
        Ray ray = (Ray)o1;
        Plane plane = (Plane)o2;
        Vector3 rayPos = ray.getPosition();
        Matrix3 rayRot = ray.getRotation();
        float alpha = plane.p.m[1] - plane.p.dot(rayPos);
        float nsign = alpha > 0.0f ? -1 : 1;
        float k = plane.p.dot(rayRot.getColumn(2));
        if (k == 0.0f) {
            return 0;
        }
        if ((alpha /= k) < 0.0f || alpha > ray.getLength()) {
            return 0;
        }
        contact[contactIndex].getPosition().setX(rayPos.getX() + alpha * rayRot.m[2]);
        contact[contactIndex].getPosition().setY(rayPos.getY() + alpha * rayRot.m[6]);
        contact[contactIndex].getPosition().setZ(rayPos.getZ() + alpha * rayRot.m[10]);
        contact[contactIndex].getNormal().setX(nsign * plane.p.m[0]);
        contact[contactIndex].getNormal().setY(nsign * plane.p.m[1]);
        contact[contactIndex].getNormal().setZ(nsign * plane.p.m[2]);
        contact[contactIndex].setDepth(alpha);
        contact[contactIndex].setGeom1(ray);
        contact[contactIndex].setGeom2(plane);
        return 1;
    }
}

