/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.collision.collider;

import net.java.dev.joode.collision.ContactGeom;
import net.java.dev.joode.collision.collider.Collider;
import net.java.dev.joode.geom.Geom;
import net.java.dev.joode.geom.Rectangle;
import net.java.dev.joode.util.Math2D;
import net.java.dev.joode.util.Matrix2;
import net.java.dev.joode.util.ROVector2;
import net.java.dev.joode.util.Vector2;

public strictfp class RectangleRectangleCollider
extends Collider {
    public static final int FACE_A_X = 1;
    public static final int FACE_A_Y = 2;
    public static final int FACE_B_X = 3;
    public static final int FACE_B_Y = 4;
    public static final int NO_EDGE = 0;
    public static final int EDGE1 = 1;
    public static final int EDGE2 = 2;
    public static final int EDGE3 = 3;
    public static final int EDGE4 = 4;
    public static final Collider INSTANCE = new RectangleRectangleCollider();

    private RectangleRectangleCollider() {
    }

    public int collide(Geom o1, Geom o2, ContactGeom[] contact, int contactIndex, int skip) {
        Rectangle a = (Rectangle)o1;
        Rectangle b = (Rectangle)o2;
        return this.collide(contact, contactIndex, a, b);
    }

    private void flip(FeaturePair fp) {
        int temp = fp.inEdge1;
        fp.inEdge1 = fp.inEdge2;
        fp.inEdge2 = temp;
        temp = fp.outEdge1;
        fp.outEdge1 = fp.outEdge2;
        fp.outEdge2 = temp;
    }

    private int clipSegmentToLine(ClipVertex[] vOut, ClipVertex[] vIn, Vector2 normal, float offset, char clipEdge) {
        int numOut = 0;
        float distance0 = normal.dot(vIn[0].v) - offset;
        float distance1 = normal.dot(vIn[1].v) - offset;
        if (distance0 <= 0.0f) {
            vOut[numOut++] = vIn[0];
        }
        if (distance1 <= 0.0f) {
            vOut[numOut++] = vIn[1];
        }
        if (distance0 * distance1 < 0.0f) {
            float interp = distance0 / (distance0 - distance1);
            vOut[numOut].v = new Vector2();
            Math2D.sub(vIn[1].v, vIn[0].v, vOut[numOut].v);
            Math2D.scale(vOut[numOut].v, interp);
            vOut[numOut].v.add(vIn[0].v);
            if (distance0 > 0.0f) {
                vOut[numOut].fp = vIn[0].fp;
                vOut[numOut].fp.inEdge1 = clipEdge;
                vOut[numOut].fp.inEdge2 = 0;
            } else {
                vOut[numOut].fp = vIn[1].fp;
                vOut[numOut].fp.outEdge1 = clipEdge;
                vOut[numOut].fp.outEdge2 = 0;
            }
            ++numOut;
        }
        return numOut;
    }

    private void computeIncidentEdge(ClipVertex[] c, ROVector2 h, ROVector2 pos, Matrix2 rot, Vector2 normal) {
        Matrix2 rotT = rot.transpose();
        Vector2 n = Math2D.scale(Math2D.mul(rotT, normal), -1.0f);
        Vector2 nAbs = Math2D.abs(n);
        if (nAbs.x > nAbs.y) {
            if (Math2D.sign(n.x) > 0.0f) {
                c[0].v.set(h.getX(), -h.getY());
                c[0].fp.inEdge2 = 3;
                c[0].fp.outEdge2 = 4;
                c[1].v.set(h.getX(), h.getY());
                c[1].fp.inEdge2 = 4;
                c[1].fp.outEdge2 = 1;
            } else {
                c[0].v.set(-h.getX(), h.getY());
                c[0].fp.inEdge2 = 1;
                c[0].fp.outEdge2 = 2;
                c[1].v.set(-h.getX(), -h.getY());
                c[1].fp.inEdge2 = 2;
                c[1].fp.outEdge2 = 3;
            }
        } else if (Math2D.sign(n.y) > 0.0f) {
            c[0].v.set(h.getX(), h.getY());
            c[0].fp.inEdge2 = 4;
            c[0].fp.outEdge2 = 1;
            c[1].v.set(-h.getX(), h.getY());
            c[1].fp.inEdge2 = 1;
            c[1].fp.outEdge2 = 2;
        } else {
            c[0].v.set(-h.getX(), -h.getY());
            c[0].fp.inEdge2 = 2;
            c[0].fp.outEdge2 = 3;
            c[1].v.set(h.getX(), -h.getY());
            c[1].fp.inEdge2 = 3;
            c[1].fp.outEdge2 = 4;
        }
        c[0].v = Math2D.mul(rot, c[0].v);
        c[0].v.add(pos);
        c[1].v = Math2D.mul(rot, c[1].v);
        c[1].v.add(pos);
    }

    public int collide(ContactGeom[] contacts, int contactIndex, Rectangle a, Rectangle b) {
        char posEdge;
        char negEdge;
        float posSide;
        float negSide;
        Vector2 sideNormal;
        float front;
        Vector2 frontNormal;
        Vector2 normal;
        Vector2 hA = new Vector2(a.getHalfWidth(), a.getHalfHeight());
        Vector2 hB = new Vector2(b.getHalfWidth(), b.getHalfHeight());
        Vector2 posA = new Vector2(a.getPosition());
        Vector2 posB = new Vector2(b.getPosition());
        Matrix2 rotA = new Matrix2();
        rotA.set(a.getRotation());
        Matrix2 rotB = new Matrix2();
        rotB.set(b.getRotation());
        Matrix2 RotAT = rotA.transpose();
        Matrix2 RotBT = rotB.transpose();
        Vector2 dp = new Vector2();
        Math2D.sub(posB, posA, dp);
        Vector2 dA = Math2D.mul(RotAT, dp);
        Vector2 dB = Math2D.mul(RotBT, dp);
        Matrix2 C = Math2D.mul(RotAT, rotB);
        Matrix2 absC = Math2D.abs(C);
        Matrix2 absCT = absC.transpose();
        Vector2 faceA = Math2D.abs(dA);
        faceA.sub(hA);
        faceA.sub(Math2D.mul(absC, hB));
        if (faceA.x > 0.0f || faceA.y > 0.0f) {
            return 0;
        }
        Vector2 faceB = Math2D.abs(dB);
        faceB.sub(Math2D.mul(absCT, hA));
        faceB.sub(hB);
        if (faceB.x > 0.0f || faceB.y > 0.0f) {
            return 0;
        }
        int axis = 1;
        float separation = faceA.x;
        Vector2 vector2 = normal = dA.x > 0.0f ? rotA.col1 : Math2D.scale(rotA.col1, -1.0f);
        if (faceA.y > 1.05f * separation + 0.01f * hA.y) {
            axis = 2;
            separation = faceA.y;
            Vector2 vector22 = normal = dA.y > 0.0f ? rotA.col2 : Math2D.scale(rotA.col2, -1.0f);
        }
        if (faceB.x > 1.05f * separation + 0.01f * hB.x) {
            axis = 3;
            separation = faceB.x;
            Vector2 vector23 = normal = dB.x > 0.0f ? rotB.col1 : Math2D.scale(rotB.col1, -1.0f);
        }
        if (faceB.y > 1.05f * separation + 0.01f * hB.y) {
            axis = 4;
            separation = faceB.y;
            normal = dB.y > 0.0f ? rotB.col2 : Math2D.scale(rotB.col2, -1.0f);
        }
        ClipVertex[] incidentEdge = new ClipVertex[]{new ClipVertex(), new ClipVertex()};
        switch (axis) {
            case 1: {
                frontNormal = normal;
                front = posA.dot(frontNormal) + hA.x;
                sideNormal = rotA.col2;
                float side = posA.dot(sideNormal);
                negSide = -side + hA.y;
                posSide = side + hA.y;
                negEdge = '\u0003';
                posEdge = '\u0001';
                this.computeIncidentEdge(incidentEdge, hB, posB, rotB, frontNormal);
                break;
            }
            case 2: {
                frontNormal = normal;
                front = posA.dot(frontNormal) + hA.y;
                sideNormal = rotA.col1;
                float side = posA.dot(sideNormal);
                negSide = -side + hA.x;
                posSide = side + hA.x;
                negEdge = '\u0002';
                posEdge = '\u0004';
                this.computeIncidentEdge(incidentEdge, hB, posB, rotB, frontNormal);
                break;
            }
            case 3: {
                frontNormal = Math2D.scale(normal, -1.0f);
                front = posB.dot(frontNormal) + hB.x;
                sideNormal = rotB.col2;
                float side = posB.dot(sideNormal);
                negSide = -side + hB.y;
                posSide = side + hB.y;
                negEdge = '\u0003';
                posEdge = '\u0001';
                this.computeIncidentEdge(incidentEdge, hA, posA, rotA, frontNormal);
                break;
            }
            case 4: {
                frontNormal = Math2D.scale(normal, -1.0f);
                front = posB.dot(frontNormal) + hB.y;
                sideNormal = rotB.col1;
                float side = posB.dot(sideNormal);
                negSide = -side + hB.x;
                posSide = side + hB.x;
                negEdge = '\u0002';
                posEdge = '\u0004';
                this.computeIncidentEdge(incidentEdge, hA, posA, rotA, frontNormal);
                break;
            }
            default: {
                throw new RuntimeException("Unknown face!");
            }
        }
        ClipVertex[] clipPoints1 = new ClipVertex[]{new ClipVertex(), new ClipVertex()};
        ClipVertex[] clipPoints2 = new ClipVertex[]{new ClipVertex(), new ClipVertex()};
        int np = this.clipSegmentToLine(clipPoints1, incidentEdge, Math2D.scale(sideNormal, -1.0f), negSide, negEdge);
        if (np < 2) {
            return 0;
        }
        np = this.clipSegmentToLine(clipPoints2, clipPoints1, sideNormal, posSide, posEdge);
        if (np < 2) {
            return 0;
        }
        int numContacts = contactIndex;
        int i = 0;
        while (i < 2) {
            float separation2 = frontNormal.dot(clipPoints2[i].v) - front;
            if (separation2 <= 0.0f) {
                contacts[numContacts].setDepth(separation2);
                contacts[numContacts].setNormal(normal.getX(), normal.getY(), 0.0f);
                contacts[numContacts].getNormal().normalize();
                Vector2 pos = new Vector2();
                Math2D.sub(clipPoints2[i].v, Math2D.scale(frontNormal, separation2), pos);
                contacts[numContacts].setPosition(pos.getX(), pos.getY(), 0.0f);
                contacts[numContacts].setGeom1(a);
                contacts[numContacts].setGeom2(b);
                contacts[numContacts].getNormal().scale(-1.0f);
                ++numContacts;
            }
            ++i;
        }
        return numContacts - contactIndex;
    }

    private strictfp class ClipVertex {
        Vector2 v = new Vector2();
        FeaturePair fp = new FeaturePair();
    }

    public strictfp static class FeaturePair {
        int inEdge1;
        int outEdge1;
        int inEdge2;
        int outEdge2;

        public FeaturePair() {
        }

        public FeaturePair(int inEdge1, int inEdge2, int outEdge1, int outEdge2) {
            this.inEdge1 = inEdge1;
            this.inEdge2 = inEdge2;
            this.outEdge1 = outEdge1;
            this.outEdge2 = outEdge2;
        }

        FeaturePair(int index) {
            this.inEdge1 = index;
        }

        int getKey() {
            return this.inEdge1 + (this.outEdge1 << 8) + (this.inEdge2 << 16) + (this.outEdge2 << 24);
        }

        public int hashCode() {
            return this.getKey();
        }

        public boolean equals(Object other) {
            if (other instanceof FeaturePair) {
                return ((FeaturePair)other).getKey() == this.getKey();
            }
            return false;
        }

        public void set(FeaturePair other) {
            this.inEdge1 = other.inEdge1;
            this.inEdge2 = other.inEdge2;
            this.outEdge1 = other.outEdge1;
            this.outEdge2 = other.outEdge2;
        }

        public String toString() {
            return "((" + this.inEdge1 + "," + this.inEdge2 + "),(" + this.outEdge1 + "," + this.outEdge2 + "))";
        }
    }
}

