/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.force;

import net.java.dev.joode.Body;
import net.java.dev.joode.ClonedReferences;
import net.java.dev.joode.World;
import net.java.dev.joode.force.Gravity;
import net.java.dev.joode.force.WorldForce;
import net.java.dev.joode.util.Vector3;

public class NewtonGravity
extends WorldForce
implements Gravity {
    private static final long serialVersionUID = 4496126049615794252L;
    private final Vector3 gravity;

    public NewtonGravity(World world, float gravityX, float gravityY, float gravityZ) {
        this(world, new Vector3(gravityX, gravityY, gravityZ));
    }

    public NewtonGravity(World world, Vector3 gravity) {
        super(world);
        this.gravity = gravity;
    }

    public void prepare(float t) {
    }

    public void applyForce(Body body, float t, Vector3 faccPassback, Vector3 taccPassback) {
        if (!body.getFlag(64)) {
            return;
        }
        faccPassback.m[0] = faccPassback.m[0] + body.getMass().getMass() * this.gravity.getX();
        faccPassback.m[1] = faccPassback.m[1] + body.getMass().getMass() * this.gravity.getY();
        faccPassback.m[2] = faccPassback.m[2] + body.getMass().getMass() * this.gravity.getZ();
    }

    public NewtonGravity cloneState(ClonedReferences util) {
        NewtonGravity clone = new NewtonGravity((World)util.getClone(this.getWorld()), new Vector3(this.gravity));
        util.addClone(this, clone);
        return clone;
    }

    public Vector3 getGravity() {
        return this.gravity;
    }

    public final void setGravity(Vector3 gravity) {
        this.setGravity(gravity.getX(), gravity.getY(), gravity.getZ());
    }

    public void setGravity(float x, float y, float z) {
        this.gravity.set(x, y, z);
    }
}

