/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.geom;

import net.java.dev.joode.ClonedReferences;
import net.java.dev.joode.geom.Geom;
import net.java.dev.joode.space.Space;
import net.java.dev.joode.util.Matrix3;
import net.java.dev.joode.util.Vector3;

public class Cylinder
extends Geom {
    private static final long serialVersionUID = -3039422999025630546L;
    private float radius;
    private float lz;

    public Cylinder(Space space, float radius, float length) {
        super(space, 3, true);
        assert (radius > 0.0f) : "radius must be greater than zero";
        assert (length > 0.0f) : "length must be greater than zero";
        this.radius = radius;
        this.lz = length;
        if (space != null) {
            space.add(this);
        }
    }

    private Cylinder() {
        super(3, true);
    }

    public final float getRadius() {
        return this.radius;
    }

    public final void setRadius(float radius) {
        this.radius = radius;
        Space.onGeomMoved(this);
    }

    public final float getLength() {
        return this.lz;
    }

    public final void setLength(float length) {
        this.lz = length;
        Space.onGeomMoved(this);
    }

    public void computeAABB() {
        Vector3 pos = this.getPosition();
        Matrix3 rot = this.getRotation();
        float lz2 = this.lz * 0.5f;
        float xrange = Math.abs(rot.m[0] * this.radius) + Math.abs(rot.m[1] * this.radius) + Math.abs(rot.m[2] * lz2);
        float yrange = Math.abs(rot.m[4] * this.radius) + Math.abs(rot.m[5] * this.radius) + Math.abs(rot.m[6] * lz2);
        float zrange = Math.abs(rot.m[8] * this.radius) + Math.abs(rot.m[9] * this.radius) + Math.abs(rot.m[10] * lz2);
        this.getAABB().set(pos.getX() - xrange, pos.getX() + xrange, pos.getY() - yrange, pos.getY() + yrange, pos.getZ() - zrange, pos.getZ() + zrange);
    }

    public float pointDepth(float x, float y, float z) {
        float lz2;
        Vector3 pos = this.getPosition();
        Matrix3 rot = this.getRotation();
        Vector3 a = new Vector3(x - pos.getX(), y - pos.getY(), z - pos.getZ());
        float beta = a.dot(rot.getColumn(2));
        if (beta < -(lz2 = this.lz * 0.5f)) {
            beta = -lz2;
        } else if (beta > lz2) {
            beta = lz2;
        }
        a.setX(x - pos.getX() + beta * rot.get(2, 0));
        a.setY(y - pos.getY() + beta * rot.get(2, 1));
        a.setZ(z - pos.getZ() + beta * rot.get(2, 2));
        return this.radius - (float)Math.sqrt(a.getX() * a.getX() + a.getY() * a.getY() + a.getZ() * a.getZ());
    }

    public Cylinder cloneState(ClonedReferences util) {
        Cylinder clone = new Cylinder();
        this.clonePartialGeom(clone, util);
        clone.radius = this.radius;
        clone.lz = this.lz;
        return clone;
    }
}

