/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.geom;

import net.java.dev.joode.ClonedReferences;
import net.java.dev.joode.geom.Geom;
import net.java.dev.joode.space.Space;
import net.java.dev.joode.util.Vector3;
import net.java.dev.joode.util.Vector4;

public class Plane
extends Geom {
    private static final long serialVersionUID = -7402961699569823837L;
    public final Vector4 p;
    private final Vector3 n = new Vector3();

    public Plane(Space space, float a, float b, float c, float d) {
        super(space, 4, false);
        this.p = new Vector4(a, b, c, d);
        if (space != null) {
            space.add(this);
        }
    }

    public Plane(Space space, Vector3 normal, float d) {
        this(space, normal.getX(), normal.getY(), normal.getZ(), d);
    }

    public Plane(Space space, Vector3 normal, Vector3 pos) {
        this(space, normal, pos.m[0] * normal.m[0] + pos.m[1] * normal.m[1] + pos.m[2] * normal.m[2]);
    }

    private Plane() {
        super(4, false);
        this.p = new Vector4(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public final Vector3 getNormal() {
        this.n.set(this.p.m[0], this.p.m[1], this.p.m[2]);
        return this.n;
    }

    public final float getD() {
        return this.p.m[3];
    }

    public final float getDistance(Vector3 point) {
        return this.p.m[0] * point.m[0] + this.p.m[1] * point.m[1] + this.p.m[2] * point.m[2] - this.p.m[3];
    }

    public void computeAABB() {
        this.getAABB().setInfinity();
    }

    public Plane cloneState(ClonedReferences util) {
        Plane clone = new Plane();
        this.clonePartialGeom(clone, util);
        clone.p.set(this.p);
        return clone;
    }
}

